/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.Context;
import org.apache.juneau.annotation.TargetedAnnotationTImpl;
import org.apache.juneau.annotation.TargetedAnnotationTMFBuilder;
import org.apache.juneau.html.HtmlRender;
import org.apache.juneau.html.annotation.Html;
import org.apache.juneau.html.annotation.HtmlFormat;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.svl.VarResolverSession;

public class HtmlAnnotation {
    public static final Html DEFAULT = HtmlAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(Class<?> ... on) {
        return HtmlAnnotation.create().on((Class[])on);
    }

    public static Builder create(String ... on) {
        return HtmlAnnotation.create().on(on);
    }

    public static Html copy(Html a, VarResolverSession r) {
        return ((Builder)HtmlAnnotation.create().anchorText(r.resolve(a.anchorText())).format(a.format()).link(r.resolve(a.link())).noTableHeaders(a.noTableHeaders()).noTables(a.noTables()).on(r.resolve(a.on())).onClass((Class[])a.onClass())).render(a.render()).build();
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public Html[] value();
    }

    public static class Apply
    extends AnnotationApplier<Html, Context.Builder> {
        public Apply(VarResolverSession vr) {
            super(Html.class, Context.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<Html> ai, Context.Builder b) {
            Html a = ai.inner();
            if (ArrayUtils.isEmptyArray(a.on(), a.onClass())) {
                return;
            }
            b.annotations(HtmlAnnotation.copy(a, this.vr()));
        }
    }

    private static class Impl
    extends TargetedAnnotationTImpl
    implements Html {
        private boolean noTableHeaders;
        private boolean noTables;
        private Class<? extends HtmlRender> render;
        private final String anchorText;
        private final String link;
        private HtmlFormat format;

        Impl(Builder b) {
            super(b);
            this.anchorText = b.anchorText;
            this.format = b.format;
            this.link = b.link;
            this.noTableHeaders = b.noTableHeaders;
            this.noTables = b.noTables;
            this.render = b.render;
            this.postConstruct();
        }

        @Override
        public String anchorText() {
            return this.anchorText;
        }

        @Override
        public HtmlFormat format() {
            return this.format;
        }

        @Override
        public String link() {
            return this.link;
        }

        @Override
        public boolean noTableHeaders() {
            return this.noTableHeaders;
        }

        @Override
        public boolean noTables() {
            return this.noTables;
        }

        @Override
        public Class<? extends HtmlRender> render() {
            return this.render;
        }
    }

    public static class Builder
    extends TargetedAnnotationTMFBuilder {
        String anchorText = "";
        String link = "";
        HtmlFormat format = HtmlFormat.HTML;
        boolean noTableHeaders;
        boolean noTables;
        Class<? extends HtmlRender> render = HtmlRender.class;

        protected Builder() {
            super(Html.class);
        }

        public Html build() {
            return new Impl(this);
        }

        public Builder anchorText(String value) {
            this.anchorText = value;
            return this;
        }

        public Builder format(HtmlFormat value) {
            this.format = value;
            return this;
        }

        public Builder link(String value) {
            this.link = value;
            return this;
        }

        public Builder noTableHeaders(boolean value) {
            this.noTableHeaders = value;
            return this;
        }

        public Builder noTables(boolean value) {
            this.noTables = value;
            return this;
        }

        public Builder render(Class<? extends HtmlRender> value) {
            this.render = value;
            return this;
        }

        @Override
        public Builder on(String ... values) {
            super.on(values);
            return this;
        }

        @Override
        public Builder on(Class<?> ... value) {
            super.on((Class[])value);
            return this;
        }

        @Override
        public Builder onClass(Class<?> ... value) {
            super.onClass((Class[])value);
            return this;
        }

        @Override
        public Builder on(Field ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(Method ... value) {
            super.on(value);
            return this;
        }
    }
}

