/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.io.PrintStream;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.juneau.assertions.FluentListAssertion;
import org.apache.juneau.internal.FluentSetters;

@FluentSetters(returns="ListAssertion<E>")
public class ListAssertion<E>
extends FluentListAssertion<E, ListAssertion<E>> {
    public static <E> ListAssertion<E> create(List<E> value) {
        return new ListAssertion<E>(value);
    }

    public static <E> ListAssertion<E> create(Stream<E> value) {
        return new ListAssertion<E>(value == null ? null : value.collect(Collectors.toList()));
    }

    public ListAssertion(List<E> value) {
        super(value, null);
    }

    @Override
    public ListAssertion<E> setMsg(String msg, Object ... args) {
        super.setMsg(msg, args);
        return this;
    }

    @Override
    public ListAssertion<E> setOut(PrintStream value) {
        super.setOut(value);
        return this;
    }

    @Override
    public ListAssertion<E> setSilent() {
        super.setSilent();
        return this;
    }

    @Override
    public ListAssertion<E> setStdOut() {
        super.setStdOut();
        return this;
    }

    @Override
    public ListAssertion<E> setThrowable(Class<? extends RuntimeException> value) {
        super.setThrowable((Class)value);
        return this;
    }
}

