/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.rrpc;

import java.io.BufferedReader;
import java.lang.reflect.Method;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.http.remote.RrpcInterfaceMethodMeta;
import org.apache.juneau.http.response.BasicHttpException;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.http.response.NotFound;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.RestSession;
import org.apache.juneau.rest.rrpc.RrpcRestOpContext;

public class RrpcRestOpSession
extends RestOpSession {
    private final RrpcRestOpContext ctx;

    public static Builder create(RrpcRestOpContext ctx, RestSession session) {
        return new Builder(ctx, session);
    }

    protected RrpcRestOpSession(Builder builder) {
        super(builder);
        this.ctx = builder.ctx;
    }

    @Override
    public void run() throws Throwable {
        Object o;
        super.run();
        RestRequest req = this.getRequest();
        RestResponse res = this.getResponse();
        RestSession session = this.getRestSession();
        Object object = o = res.hasContent() ? res.getContent(Object.class) : null;
        if ("GET".equals(session.getMethod())) {
            res.setContent(this.ctx.getMeta().getMethodsByPath().keySet());
            return;
        }
        if ("POST".equals(session.getMethod())) {
            String pip = session.getUrlPath().getPath();
            if (pip.indexOf(47) != -1) {
                pip = pip.substring(pip.lastIndexOf(47) + 1);
            }
            pip = StringUtils.urlDecode((String)pip);
            RrpcInterfaceMethodMeta rmm = this.ctx.getMeta().getMethodMetaByPath(pip);
            if (rmm != null) {
                Method m = rmm.getJavaMethod();
                try {
                    Parser p = req.getContent().getParserMatch().get().getParser();
                    Object[] args = null;
                    if (m.getGenericParameterTypes().length == 0) {
                        args = new Object[]{};
                    } else {
                        try (BufferedReader in = p.isReaderParser() ? req.getReader() : req.getInputStream();){
                            args = p.parseArgs((Object)in, m.getGenericParameterTypes());
                        }
                    }
                    res.setContent(m.invoke(o, args));
                    return;
                }
                catch (BasicHttpException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new InternalServerError((Throwable)e);
                }
            }
        }
        throw new NotFound();
    }

    public static class Builder
    extends RestOpSession.Builder {
        RrpcRestOpContext ctx;

        public Builder(RrpcRestOpContext ctx, RestSession session) {
            super(ctx, session);
            this.ctx = ctx;
        }

        @Override
        public RrpcRestOpSession build() {
            return new RrpcRestOpSession(this);
        }
    }
}

