/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client.remote;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.Value;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.remote.RemoteReturn;
import org.apache.juneau.http.remote.RemoteUtils;
import org.apache.juneau.httppart.bean.ResponseBeanMeta;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.MethodInfo;

public final class RemoteOperationReturn {
    private final Type returnType;
    private final RemoteReturn returnValue;
    private final ResponseBeanMeta meta;
    private boolean isFuture;
    private boolean isCompletableFuture;

    RemoteOperationReturn(MethodInfo m) {
        ClassInfo rt = m.getReturnType();
        AnnotationList al = m.getAnnotationList(RemoteUtils.REMOTE_OP_GROUP);
        if (al.isEmpty()) {
            al = m.getReturnType().unwrap(Value.class, Optional.class).getAnnotationList(RemoteUtils.REMOTE_OP_GROUP);
        }
        RemoteReturn rv = null;
        if (rt.is(Future.class)) {
            this.isFuture = true;
            rt = ClassInfo.of(((ParameterizedType)rt.innerType()).getActualTypeArguments()[0]);
        } else if (rt.is(CompletableFuture.class)) {
            this.isCompletableFuture = true;
            rt = ClassInfo.of(((ParameterizedType)rt.innerType()).getActualTypeArguments()[0]);
        }
        if (rt.is(Void.TYPE) || rt.is(Void.class)) {
            rv = RemoteReturn.NONE;
        } else {
            Value<RemoteReturn> v = Value.of(RemoteReturn.BODY);
            al.forEachValue(RemoteReturn.class, "returns", x -> true, x -> v.set((RemoteReturn)x));
            rv = v.get();
        }
        if (rt.hasAnnotation(Response.class) && rt.isInterface()) {
            this.meta = ResponseBeanMeta.create(m, AnnotationWorkList.create());
            rv = RemoteReturn.BEAN;
        } else {
            this.meta = null;
        }
        this.returnType = rt.innerType();
        this.returnValue = rv;
    }

    public ResponseBeanMeta getResponseBeanMeta() {
        return this.meta;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public boolean isFuture() {
        return this.isFuture;
    }

    public boolean isCompletableFuture() {
        return this.isCompletableFuture;
    }

    public RemoteReturn getReturnValue() {
        return this.returnValue;
    }
}

