/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.openapi3;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.bean.openapi3.OpenApiElement;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;

public class SecurityRequirement
extends OpenApiElement {
    private Map<String, List<String>> requirements;

    public SecurityRequirement() {
    }

    public SecurityRequirement(SecurityRequirement copyFrom) {
        super(copyFrom);
        this.requirements = CollectionUtils.copyOf(copyFrom.requirements);
    }

    public SecurityRequirement addRequirement(String schemeName, String ... scopes) {
        AssertionUtils.assertArgNotNull((String)"schemeName", (Object)schemeName);
        AssertionUtils.assertArgNoNulls((String)"scopes", (Object[])scopes);
        if (this.requirements == null) {
            this.requirements = new LinkedHashMap<String, List<String>>();
        }
        this.requirements.put(schemeName, CollectionUtils.l((Object[])scopes));
        return this;
    }

    public SecurityRequirement copy() {
        return new SecurityRequirement(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return (T)(switch (property) {
            case "requirements" -> ConverterUtils.toType(this.getRequirements(), type);
            default -> super.get(property, type);
        });
    }

    public Map<String, List<String>> getRequirements() {
        return this.requirements;
    }

    @Override
    public Set<String> keySet() {
        Set s = CollectionUtils.setb(String.class).addIf(Utils.nn(this.requirements), (Object)"requirements").build();
        return new MultiSet(new Collection[]{s, super.keySet()});
    }

    @Override
    public SecurityRequirement set(String property, Object value) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return switch (property) {
            case "requirements" -> this.setRequirements((Map)value);
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public SecurityRequirement setApiKeyAuth(String schemeName) {
        return this.addRequirement(schemeName, new String[0]);
    }

    public SecurityRequirement setRequirements(Map<String, List<String>> value) {
        this.requirements = value;
        return this;
    }

    @Override
    public SecurityRequirement strict() {
        super.strict();
        return this;
    }

    @Override
    public SecurityRequirement strict(Object value) {
        super.strict(value);
        return this;
    }
}

