/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.sshd.common.PtyMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SttySupport {
    private static String sttyCommand = System.getProperty("sshd.sttyCommand", "stty");
    private static String ttyProps;
    private static long ttyPropsLastFetched;

    public static Map<PtyMode, Integer> getUnixPtyModes() throws IOException, InterruptedException {
        return SttySupport.parsePtyModes(SttySupport.getTtyProps());
    }

    public static Map<PtyMode, Integer> parsePtyModes(String stty) {
        TreeMap<PtyMode, Integer> modes = new TreeMap<PtyMode, Integer>();
        for (PtyMode mode : PtyMode.values()) {
            int v;
            if (mode == PtyMode.TTY_OP_ISPEED || mode == PtyMode.TTY_OP_OSPEED) continue;
            String str = mode.name().toLowerCase();
            if (str.charAt(0) == 'v') {
                v = SttySupport.findChar(stty, str = str.substring(1));
                if (v < 0 && "reprint".equals(str)) {
                    v = SttySupport.findChar(stty, "rprnt");
                }
                if (v < 0) continue;
                modes.put(mode, v);
                continue;
            }
            v = SttySupport.findFlag(stty, str);
            if (v < 0) continue;
            modes.put(mode, v);
        }
        return modes;
    }

    private static int findFlag(String stty, String name) {
        int cur = 0;
        while (cur < stty.length()) {
            int idx1 = stty.indexOf(name, cur);
            int idx2 = idx1 + name.length();
            if (idx1 < 0) {
                return -1;
            }
            if (idx1 > 0 && Character.isLetterOrDigit(stty.charAt(idx1 - 1)) || idx2 < stty.length() && Character.isLetterOrDigit(stty.charAt(idx2))) {
                cur = idx2;
                continue;
            }
            return idx1 == 0 ? 1 : (stty.charAt(idx1 - 1) == '-' ? 0 : 1);
        }
        return -1;
    }

    private static int findChar(String stty, String name) {
        int cur = 0;
        while (cur < stty.length()) {
            int idx1 = stty.indexOf(name, cur);
            int idx2 = stty.indexOf(61, idx1);
            int idx3 = stty.indexOf(59, idx1);
            if (idx1 < 0 || idx2 < 0 || idx3 < idx2) {
                return -1;
            }
            if (idx1 > 0 && Character.isLetterOrDigit(stty.charAt(idx1 - 1)) || idx2 < stty.length() && Character.isLetterOrDigit(stty.charAt(idx2))) {
                cur = idx1 + name.length();
                continue;
            }
            String val = stty.substring(idx2 + 1, idx3 < 0 ? stty.length() : idx3).trim();
            if (val.indexOf("undef") >= 0) {
                return -1;
            }
            if (val.length() == 2 && val.charAt(0) == '^') {
                int v = (val.charAt(1) - 65 + 129) % 128;
                return v;
            }
            try {
                return Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    public static int getTerminalWidth() {
        int val = -1;
        try {
            val = SttySupport.getTerminalProperty("columns");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (val == -1) {
            val = 80;
        }
        return val;
    }

    public static int getTerminalHeight() {
        int val = -1;
        try {
            val = SttySupport.getTerminalProperty("rows");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (val == -1) {
            val = 24;
        }
        return val;
    }

    private static int getTerminalProperty(String prop) throws IOException, InterruptedException {
        StringTokenizer tok = new StringTokenizer(SttySupport.getTtyProps(), ";\n");
        while (tok.hasMoreTokens()) {
            String str = tok.nextToken().trim();
            if (str.startsWith(prop)) {
                int index = str.lastIndexOf(" ");
                return Integer.parseInt(str.substring(index).trim());
            }
            if (!str.endsWith(prop)) continue;
            int index = str.indexOf(" ");
            return Integer.parseInt(str.substring(0, index).trim());
        }
        return -1;
    }

    public static String getTtyProps() throws IOException, InterruptedException {
        if (ttyProps == null || System.currentTimeMillis() - ttyPropsLastFetched > 1000L) {
            ttyProps = SttySupport.stty("-a");
            ttyPropsLastFetched = System.currentTimeMillis();
        }
        return ttyProps;
    }

    public static String stty(String args) throws IOException, InterruptedException {
        return SttySupport.exec("stty " + args + " < /dev/tty").trim();
    }

    public static String exec(String cmd) throws IOException, InterruptedException {
        return SttySupport.exec(new String[]{"sh", "-c", cmd});
    }

    private static String exec(String[] cmd) throws IOException, InterruptedException {
        int c;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Process p = Runtime.getRuntime().exec(cmd);
        InputStream in = p.getInputStream();
        while ((c = in.read()) != -1) {
            bout.write(c);
        }
        in = p.getErrorStream();
        while ((c = in.read()) != -1) {
            bout.write(c);
        }
        p.waitFor();
        String result = new String(bout.toByteArray());
        return result;
    }

    public static void setSttyCommand(String cmd) {
        sttyCommand = cmd;
    }

    public static String getSttyCommand() {
        return sttyCommand;
    }
}

