/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.maven.settings;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import shaded.org.apache.maven.settings.Mirror;
import shaded.org.apache.maven.settings.Profile;
import shaded.org.apache.maven.settings.Proxy;
import shaded.org.apache.maven.settings.RuntimeInfo;
import shaded.org.apache.maven.settings.Server;
import shaded.org.apache.maven.settings.TrackableBase;

public class Settings
extends TrackableBase
implements Serializable,
Cloneable {
    private String localRepository;
    private boolean interactiveMode = true;
    private boolean usePluginRegistry = false;
    private boolean offline = false;
    private List<Proxy> proxies;
    private List<Server> servers;
    private List<Mirror> mirrors;
    private List<Profile> profiles;
    private List<String> activeProfiles;
    private List<String> pluginGroups;
    private String modelEncoding = "UTF-8";
    private Proxy activeProxy;
    private Map<String, Profile> profileMap;
    private RuntimeInfo runtimeInfo;

    public void addActiveProfile(String string) {
        this.getActiveProfiles().add(string);
    }

    public void addMirror(Mirror mirror) {
        this.getMirrors().add(mirror);
    }

    public void addPluginGroup(String string) {
        this.getPluginGroups().add(string);
    }

    public void addProfile(Profile profile) {
        this.getProfiles().add(profile);
    }

    public void addProxy(Proxy proxy) {
        this.getProxies().add(proxy);
    }

    public void addServer(Server server) {
        this.getServers().add(server);
    }

    @Override
    public Settings clone() {
        try {
            Settings copy = (Settings)super.clone();
            if (this.proxies != null) {
                copy.proxies = new ArrayList<Proxy>();
                for (Proxy proxy : this.proxies) {
                    copy.proxies.add(proxy.clone());
                }
            }
            if (this.servers != null) {
                copy.servers = new ArrayList<Server>();
                for (Server server : this.servers) {
                    copy.servers.add(server.clone());
                }
            }
            if (this.mirrors != null) {
                copy.mirrors = new ArrayList<Mirror>();
                for (Mirror mirror : this.mirrors) {
                    copy.mirrors.add(mirror.clone());
                }
            }
            if (this.profiles != null) {
                copy.profiles = new ArrayList<Profile>();
                for (Profile profile : this.profiles) {
                    copy.profiles.add(profile.clone());
                }
            }
            if (this.activeProfiles != null) {
                copy.activeProfiles = new ArrayList<String>();
                copy.activeProfiles.addAll(this.activeProfiles);
            }
            if (this.pluginGroups != null) {
                copy.pluginGroups = new ArrayList<String>();
                copy.pluginGroups.addAll(this.pluginGroups);
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public List<String> getActiveProfiles() {
        if (this.activeProfiles == null) {
            this.activeProfiles = new ArrayList<String>();
        }
        return this.activeProfiles;
    }

    public String getLocalRepository() {
        return this.localRepository;
    }

    public List<Mirror> getMirrors() {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList<Mirror>();
        }
        return this.mirrors;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }

    public List<String> getPluginGroups() {
        if (this.pluginGroups == null) {
            this.pluginGroups = new ArrayList<String>();
        }
        return this.pluginGroups;
    }

    public List<Profile> getProfiles() {
        if (this.profiles == null) {
            this.profiles = new ArrayList<Profile>();
        }
        return this.profiles;
    }

    public List<Proxy> getProxies() {
        if (this.proxies == null) {
            this.proxies = new ArrayList<Proxy>();
        }
        return this.proxies;
    }

    public List<Server> getServers() {
        if (this.servers == null) {
            this.servers = new ArrayList<Server>();
        }
        return this.servers;
    }

    public boolean isInteractiveMode() {
        return this.interactiveMode;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public boolean isUsePluginRegistry() {
        return this.usePluginRegistry;
    }

    public void removeActiveProfile(String string) {
        this.getActiveProfiles().remove(string);
    }

    public void removeMirror(Mirror mirror) {
        this.getMirrors().remove(mirror);
    }

    public void removePluginGroup(String string) {
        this.getPluginGroups().remove(string);
    }

    public void removeProfile(Profile profile) {
        this.getProfiles().remove(profile);
    }

    public void removeProxy(Proxy proxy) {
        this.getProxies().remove(proxy);
    }

    public void removeServer(Server server) {
        this.getServers().remove(server);
    }

    public void setActiveProfiles(List<String> activeProfiles) {
        this.activeProfiles = activeProfiles;
    }

    public void setInteractiveMode(boolean interactiveMode) {
        this.interactiveMode = interactiveMode;
    }

    public void setLocalRepository(String localRepository) {
        this.localRepository = localRepository;
    }

    public void setMirrors(List<Mirror> mirrors) {
        this.mirrors = mirrors;
    }

    public void setModelEncoding(String modelEncoding) {
        this.modelEncoding = modelEncoding;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public void setPluginGroups(List<String> pluginGroups) {
        this.pluginGroups = pluginGroups;
    }

    public void setProfiles(List<Profile> profiles) {
        this.profiles = profiles;
    }

    public void setProxies(List<Proxy> proxies) {
        this.proxies = proxies;
    }

    public void setServers(List<Server> servers) {
        this.servers = servers;
    }

    public void setUsePluginRegistry(boolean usePluginRegistry) {
        this.usePluginRegistry = usePluginRegistry;
    }

    public Boolean getInteractiveMode() {
        return this.isInteractiveMode();
    }

    public void flushActiveProxy() {
        this.activeProxy = null;
    }

    public synchronized Proxy getActiveProxy() {
        List<Proxy> proxies;
        if (this.activeProxy == null && (proxies = this.getProxies()) != null && !proxies.isEmpty()) {
            for (Proxy proxy : proxies) {
                if (!proxy.isActive()) continue;
                this.activeProxy = proxy;
                break;
            }
        }
        return this.activeProxy;
    }

    public Server getServer(String serverId) {
        Server match = null;
        List<Server> servers = this.getServers();
        if (servers != null && serverId != null) {
            for (Server server : servers) {
                if (!serverId.equals(server.getId())) continue;
                match = server;
                break;
            }
        }
        return match;
    }

    @Deprecated
    public Mirror getMirrorOf(String repositoryId) {
        Mirror match = null;
        List<Mirror> mirrors = this.getMirrors();
        if (mirrors != null && repositoryId != null) {
            for (Mirror mirror : mirrors) {
                if (!repositoryId.equals(mirror.getMirrorOf())) continue;
                match = mirror;
                break;
            }
        }
        return match;
    }

    public void flushProfileMap() {
        this.profileMap = null;
    }

    public Map<String, Profile> getProfilesAsMap() {
        if (this.profileMap == null) {
            this.profileMap = new LinkedHashMap<String, Profile>();
            if (this.getProfiles() != null) {
                for (Profile profile : this.getProfiles()) {
                    this.profileMap.put(profile.getId(), profile);
                }
            }
        }
        return this.profileMap;
    }

    @Deprecated
    public void setRuntimeInfo(RuntimeInfo runtimeInfo) {
        this.runtimeInfo = runtimeInfo;
    }

    @Deprecated
    public RuntimeInfo getRuntimeInfo() {
        if (this.runtimeInfo == null) {
            this.runtimeInfo = new RuntimeInfo();
        }
        return this.runtimeInfo;
    }
}

