/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.tasks;

import java.util.Collection;
import java.util.Iterator;
import org.apache.felix.eventadmin.impl.handler.EventHandlerProxy;
import org.apache.felix.eventadmin.impl.tasks.BlacklistLatch;
import org.apache.felix.eventadmin.impl.tasks.DefaultThreadPool;
import org.apache.felix.eventadmin.impl.tasks.HandlerTask;
import org.apache.felix.eventadmin.impl.tasks.SyncThread;
import org.osgi.service.event.Event;

public class SyncDeliverTasks {
    private final DefaultThreadPool pool;
    private long timeout;

    public SyncDeliverTasks(DefaultThreadPool pool, long timeout) {
        this.pool = pool;
        this.update(timeout);
    }

    public void update(long timeout) {
        this.timeout = timeout;
    }

    public void execute(Collection<EventHandlerProxy> tasks, Event event, boolean filterAsyncUnordered) {
        Thread sleepingThread = Thread.currentThread();
        SyncThread syncThread = sleepingThread instanceof SyncThread ? (SyncThread)sleepingThread : null;
        Iterator<EventHandlerProxy> i = tasks.iterator();
        BlacklistLatch handlerLatch = new BlacklistLatch(tasks.size(), this.timeout / 2L);
        while (i.hasNext()) {
            EventHandlerProxy task = i.next();
            HandlerTask handlerTask = new HandlerTask(task, event, this.timeout, handlerLatch);
            if (!handlerTask.useTimeout()) {
                handlerTask.runWithoutBlacklistTiming();
                continue;
            }
            if (syncThread != null) {
                handlerTask.run();
                continue;
            }
            handlerLatch.addToBlacklistCheck(handlerTask);
            if (this.pool.executeTask(handlerTask)) continue;
            handlerTask.run();
        }
        handlerLatch.awaitAndBlacklistCheck();
    }
}

