/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.security.KeyPair;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.karaf.shell.api.console.Session;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.agent.SshAgentServer;
import org.apache.sshd.agent.common.AgentDelegate;
import org.apache.sshd.agent.local.AgentImpl;
import org.apache.sshd.agent.local.AgentServerProxy;
import org.apache.sshd.agent.local.ChannelAgentForwarding;
import org.apache.sshd.common.Channel;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.server.session.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarafAgentFactory
implements SshAgentFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(KarafAgentFactory.class);
    private final Map<String, AgentServerProxy> proxies = new ConcurrentHashMap<String, AgentServerProxy>();
    private final Map<String, SshAgent> locals = new ConcurrentHashMap<String, SshAgent>();

    public NamedFactory<Channel> getChannelForwardingFactory() {
        return new ChannelAgentForwarding.Factory();
    }

    public SshAgent createClient(FactoryManager manager) throws IOException {
        String proxyId = (String)manager.getProperties().get("SSH_AUTH_SOCK");
        if (proxyId == null) {
            throw new IllegalStateException("No SSH_AUTH_SOCK environment variable set");
        }
        AgentServerProxy proxy = this.proxies.get(proxyId);
        if (proxy != null) {
            return proxy.createClient();
        }
        SshAgent agent = this.locals.get(proxyId);
        if (agent != null) {
            return new AgentDelegate(agent);
        }
        throw new IllegalStateException("No ssh agent found");
    }

    public SshAgentServer createServer(ConnectionService service) throws IOException {
        org.apache.sshd.common.Session session = service.getSession();
        if (!(session instanceof ServerSession)) {
            throw new IllegalStateException("The session used to create an agent server proxy must be a server session");
        }
        final AgentServerProxy proxy = new AgentServerProxy(service);
        this.proxies.put(proxy.getId(), proxy);
        return new SshAgentServer(){

            public String getId() {
                return proxy.getId();
            }

            public void close() {
                KarafAgentFactory.this.proxies.remove(proxy.getId());
                proxy.close();
            }
        };
    }

    public void registerSession(Session session) {
        try {
            String user = (String)session.get("USER");
            AgentImpl agent = new AgentImpl();
            URL url = this.getClass().getClassLoader().getResource("karaf.key");
            InputStream is = url.openStream();
            ObjectInputStream r = new ObjectInputStream(is);
            KeyPair keyPair = (KeyPair)r.readObject();
            agent.addIdentity(keyPair, "karaf");
            String agentId = "local:" + user;
            session.put("SSH_AUTH_SOCK", (Object)agentId);
            this.locals.put(agentId, (SshAgent)agent);
        }
        catch (Throwable e) {
            LOGGER.warn("Error starting ssh agent for local console", e);
        }
    }

    public void unregisterSession(Session session) {
        try {
            if (session != null && session.get("SSH_AUTH_SOCK") != null) {
                String agentId = (String)session.get("SSH_AUTH_SOCK");
                session.put("SSH_AUTH_SOCK", null);
                if (agentId != null) {
                    this.locals.remove(agentId);
                }
            }
        }
        catch (Throwable e) {
            LOGGER.warn("Error stopping ssh agent for local console", e);
        }
    }
}

