/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.whiteboard.tracker;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.http.base.internal.runtime.WhiteboardServiceInfo;
import org.apache.felix.http.base.internal.whiteboard.WhiteboardManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public abstract class WhiteboardServiceTracker<T>
extends ServiceTracker<T, ServiceReference<T>> {
    private final Map<Long, WhiteboardServiceInfo<T>> allInfos = new ConcurrentHashMap<Long, WhiteboardServiceInfo<T>>();
    private final WhiteboardManager contextManager;

    private static Filter createFilter(BundleContext btx, String expr) {
        try {
            return btx.createFilter(expr);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return null;
        }
    }

    public WhiteboardServiceTracker(WhiteboardManager contextManager, BundleContext bundleContext, String filterExpr) {
        super(bundleContext, WhiteboardServiceTracker.createFilter(bundleContext, filterExpr), null);
        this.contextManager = contextManager;
    }

    public void close() {
        super.close();
        this.allInfos.clear();
    }

    public final ServiceReference<T> addingService(ServiceReference<T> ref) {
        this.added(ref);
        return ref;
    }

    public final void modifiedService(ServiceReference<T> ref, ServiceReference<T> service) {
        this.modified(ref);
    }

    public final void removedService(ServiceReference<T> ref, ServiceReference<T> service) {
        this.removed(ref);
    }

    private void modified(ServiceReference<T> ref) {
        this.removed(ref);
        this.added(ref);
    }

    private void added(ServiceReference<T> ref) {
        WhiteboardServiceInfo<T> info = this.getServiceInfo(ref);
        if (this.contextManager.addWhiteboardService(info)) {
            this.allInfos.put((Long)ref.getProperty("service.id"), info);
        }
    }

    private void removed(ServiceReference<T> ref) {
        WhiteboardServiceInfo<T> info = this.allInfos.remove(ref.getProperty("service.id"));
        if (info != null) {
            this.contextManager.removeWhiteboardService(info);
        }
    }

    protected abstract WhiteboardServiceInfo<T> getServiceInfo(ServiceReference<T> var1);
}

