/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.deploy;

import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import org.apache.knox.gateway.deploy.DeploymentContext;
import org.apache.knox.gateway.deploy.DeploymentContributorBase;
import org.apache.knox.gateway.deploy.ServiceDeploymentContributor;
import org.apache.knox.gateway.descriptor.FilterParamDescriptor;
import org.apache.knox.gateway.descriptor.ResourceDescriptor;
import org.apache.knox.gateway.topology.Provider;
import org.apache.knox.gateway.topology.Service;
import org.apache.knox.gateway.topology.Version;

public abstract class ServiceDeploymentContributorBase
extends DeploymentContributorBase
implements ServiceDeploymentContributor {
    @Override
    public Version getVersion() {
        return new Version();
    }

    @Override
    public void initializeContribution(DeploymentContext context) {
    }

    @Override
    public void finalizeContribution(DeploymentContext context) {
    }

    protected boolean topologyContainsProviderType(DeploymentContext context, String role) {
        Provider provider = this.getProviderByRole(context, role);
        return provider != null;
    }

    protected Provider getProviderByRole(DeploymentContext context, String role) {
        Provider p = null;
        Collection<Provider> providers = context.getTopology().getProviders();
        for (Provider provider : providers) {
            if (!role.equals(provider.getRole())) continue;
            p = provider;
            break;
        }
        return p;
    }

    protected void addWebAppSecFilters(DeploymentContext context, Service service, ResourceDescriptor resource) {
        if (this.topologyContainsProviderType(context, "webappsec")) {
            context.contributeFilter(service, resource, "webappsec", null, null);
        }
    }

    protected void addAuthenticationFilter(DeploymentContext context, Service service, ResourceDescriptor resource) {
        if (this.topologyContainsProviderType(context, "authentication")) {
            context.contributeFilter(service, resource, "authentication", null, null);
        }
        if (this.topologyContainsProviderType(context, "federation")) {
            context.contributeFilter(service, resource, "federation", null, null);
        }
    }

    protected void addIdentityAssertionFilter(DeploymentContext context, Service service, ResourceDescriptor resource) {
        if (this.topologyContainsProviderType(context, "authentication") || this.topologyContainsProviderType(context, "federation")) {
            context.contributeFilter(service, resource, "identity-assertion", null, null);
        }
    }

    protected void addAuthorizationFilter(DeploymentContext context, Service service, ResourceDescriptor resource) {
        if (this.topologyContainsProviderType(context, "authorization")) {
            context.contributeFilter(service, resource, "authorization", null, null);
        }
    }

    protected void addXForwardedFilter(DeploymentContext context, Service service, ResourceDescriptor resource) {
        String XFORWARDED_FILTER_NAME = "XForwardedHeaderFilter";
        String XFORWARDED_FILTER_ROLE = "xforwardedheaders";
        if (context.getGatewayConfig() != null && context.getGatewayConfig().isXForwardedEnabled()) {
            resource.addFilter().name("XForwardedHeaderFilter").role("xforwardedheaders").impl("org.apache.knox.gateway.filter.XForwardedHeaderFilter");
        }
    }

    protected void addRewriteFilter(DeploymentContext context, Service service, ResourceDescriptor resource, List<FilterParamDescriptor> params) throws URISyntaxException {
        context.contributeFilter(service, resource, "rewrite", null, params);
    }

    protected void addDispatchFilter(DeploymentContext context, Service service, ResourceDescriptor resource, String role, String name) {
        if (name == null) {
            name = "http-client";
        }
        context.contributeFilter(service, resource, role, name, null);
    }
}

