/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;

public class Urls {
    public static String ensureLeadingSlash(String s) {
        if (s == null) {
            return "/";
        }
        if (s.startsWith("/")) {
            return s;
        }
        return "/" + s;
    }

    public static String stripLeadingSlash(String s) {
        if (s != null) {
            s = s.trim();
            while (s.startsWith("/")) {
                s = s.substring(1);
            }
        }
        return s;
    }

    public static String concatUrl(String prefix, String suffix) {
        if (suffix == null) {
            return prefix;
        }
        if (prefix.endsWith("/") && suffix.startsWith("/")) {
            return prefix + Urls.stripLeadingSlash(suffix);
        }
        if (!prefix.endsWith("/") && !suffix.startsWith("/")) {
            return prefix + "/" + suffix;
        }
        return prefix + suffix;
    }

    public static boolean isIp(String domain) {
        Pattern p = Pattern.compile("^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$");
        Matcher m = p.matcher(domain);
        return m.find();
    }

    public static int dotOccurrences(String domain) {
        return domain.length() - domain.replace(".", "").length();
    }

    public static String getDomainName(String url, String domainSuffix) throws MalformedURLException {
        URL originalUrl = new URL(url);
        String domain = originalUrl.getHost();
        if ("*".equals(domainSuffix)) {
            return domain;
        }
        if (domainSuffix != null && domain.endsWith(domainSuffix)) {
            return domainSuffix.startsWith(".") ? domainSuffix : "." + domainSuffix;
        }
        if (Urls.isIp(domain)) {
            return null;
        }
        if (Urls.dotOccurrences(domain) < 2) {
            return null;
        }
        int idx = domain.indexOf(46);
        if (idx == -1) {
            idx = 0;
        }
        return domain.substring(idx);
    }

    public static String encode(String str) {
        URLCodec codec = new URLCodec();
        try {
            return codec.encode(str, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String decode(String str) {
        URLCodec codec = new URLCodec();
        try {
            return codec.decode(str, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String trimLeadingAndTrailingSlash(String s) {
        int b;
        if (s == null) {
            return "";
        }
        int e = s.length();
        for (b = 0; b < e && s.charAt(b) == '/'; ++b) {
        }
        while (e > b && s.charAt(e - 1) == '/') {
            --e;
        }
        return s.substring(b, e);
    }

    public static String trimLeadingAndTrailingSlashJoin(String ... parts) {
        StringBuilder s = new StringBuilder();
        if (parts != null) {
            String p = "";
            String n = "";
            for (int i = 0; i < parts.length; ++i) {
                n = Urls.trimLeadingAndTrailingSlash(parts[i]);
                if (n.isEmpty()) continue;
                if (!p.isEmpty()) {
                    s.append('/');
                }
                s.append(n);
                p = n;
            }
        }
        return s.toString();
    }
}

