/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.webappsec.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class XFrameOptionsFilter
implements Filter {
    private static final String X_FRAME_OPTIONS = "X-Frame-Options";
    private static final String CUSTOM_HEADER_PARAM = "xframe.options";
    private String option = "DENY";

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        ((HttpServletResponse)res).setHeader(X_FRAME_OPTIONS, this.option);
        chain.doFilter(req, (ServletResponse)new XFrameOptionsResponseWrapper((HttpServletResponse)res));
    }

    public void init(FilterConfig config) throws ServletException {
        String customOption = config.getInitParameter(CUSTOM_HEADER_PARAM);
        if (customOption != null) {
            this.option = customOption;
        }
    }

    public class XFrameOptionsResponseWrapper
    extends HttpServletResponseWrapper {
        public void addHeader(String name, String value) {
            if (!name.equals(XFrameOptionsFilter.X_FRAME_OPTIONS)) {
                super.addHeader(name, value);
            }
        }

        public void setHeader(String name, String value) {
            if (!name.equals(XFrameOptionsFilter.X_FRAME_OPTIONS)) {
                super.setHeader(name, value);
            }
        }

        public XFrameOptionsResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public String getHeader(String name) {
            String headerValue = null;
            headerValue = name.equals(XFrameOptionsFilter.X_FRAME_OPTIONS) ? XFrameOptionsFilter.this.option : super.getHeader(name);
            return headerValue;
        }

        public Collection<String> getHeaderNames() {
            ArrayList<String> names = (ArrayList<String>)super.getHeaderNames();
            if (names == null) {
                names = new ArrayList<String>();
            }
            names.add(XFrameOptionsFilter.X_FRAME_OPTIONS);
            return names;
        }

        public Collection<String> getHeaders(String name) {
            ArrayList<String> values = (ArrayList<String>)super.getHeaders(name);
            if (name.equals(XFrameOptionsFilter.X_FRAME_OPTIONS)) {
                if (values == null) {
                    values = new ArrayList<String>();
                }
                values.add(XFrameOptionsFilter.this.option);
            }
            return values;
        }
    }
}

