/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiAuthRoleRef;
import com.cloudera.api.swagger.model.ApiClusterRef;
import com.cloudera.api.swagger.model.ApiExternalUserMappingRef;
import com.cloudera.api.swagger.model.ApiUser2Ref;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="This is the model for user role scope in the API since v18. This is used to support granular permissions.")
public class ApiAuthRole {
    @SerializedName(value="displayName")
    private String displayName = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="clusters")
    private List<ApiClusterRef> clusters = null;
    @SerializedName(value="users")
    private List<ApiUser2Ref> users = null;
    @SerializedName(value="externalUserMappings")
    private List<ApiExternalUserMappingRef> externalUserMappings = null;
    @SerializedName(value="baseRole")
    private ApiAuthRoleRef baseRole = null;
    @SerializedName(value="uuid")
    private String uuid = null;
    @SerializedName(value="isCustom")
    private Boolean isCustom = null;

    public ApiAuthRole displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(value="")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ApiAuthRole name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiAuthRole clusters(List<ApiClusterRef> clusters) {
        this.clusters = clusters;
        return this;
    }

    public ApiAuthRole addClustersItem(ApiClusterRef clustersItem) {
        if (this.clusters == null) {
            this.clusters = new ArrayList<ApiClusterRef>();
        }
        this.clusters.add(clustersItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<ApiClusterRef> getClusters() {
        return this.clusters;
    }

    public void setClusters(List<ApiClusterRef> clusters) {
        this.clusters = clusters;
    }

    public ApiAuthRole users(List<ApiUser2Ref> users) {
        this.users = users;
        return this;
    }

    public ApiAuthRole addUsersItem(ApiUser2Ref usersItem) {
        if (this.users == null) {
            this.users = new ArrayList<ApiUser2Ref>();
        }
        this.users.add(usersItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<ApiUser2Ref> getUsers() {
        return this.users;
    }

    public void setUsers(List<ApiUser2Ref> users) {
        this.users = users;
    }

    public ApiAuthRole externalUserMappings(List<ApiExternalUserMappingRef> externalUserMappings) {
        this.externalUserMappings = externalUserMappings;
        return this;
    }

    public ApiAuthRole addExternalUserMappingsItem(ApiExternalUserMappingRef externalUserMappingsItem) {
        if (this.externalUserMappings == null) {
            this.externalUserMappings = new ArrayList<ApiExternalUserMappingRef>();
        }
        this.externalUserMappings.add(externalUserMappingsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<ApiExternalUserMappingRef> getExternalUserMappings() {
        return this.externalUserMappings;
    }

    public void setExternalUserMappings(List<ApiExternalUserMappingRef> externalUserMappings) {
        this.externalUserMappings = externalUserMappings;
    }

    public ApiAuthRole baseRole(ApiAuthRoleRef baseRole) {
        this.baseRole = baseRole;
        return this;
    }

    @ApiModelProperty(value="A role this user possesses. In Cloudera Enterprise Datahub Edition, possible values are: <ul> <li><b>ROLE_ADMIN</b></li> <li><b>ROLE_USER</b></li> <li><b>ROLE_LIMITED</b>: Added in Cloudera Manager 5.0</li> <li><b>ROLE_OPERATOR</b>: Added in Cloudera Manager 5.1</li> <li><b>ROLE_CONFIGURATOR</b>: Added in Cloudera Manager 5.1</li> <li><b>ROLE_CLUSTER_ADMIN</b>: Added in Cloudera Manager 5.2</li> <li><b>ROLE_BDR_ADMIN</b>: Added in Cloudera Manager 5.2</li> <li><b>ROLE_NAVIGATOR_ADMIN</b>: Added in Cloudera Manager 5.2</li> <li><b>ROLE_USER_ADMIN</b>: Added in Cloudera Manager 5.2</li> <li><b>ROLE_KEY_ADMIN</b>: Added in Cloudera Manager 5.5</li> </ul> An empty role implies ROLE_USER. <p>")
    public ApiAuthRoleRef getBaseRole() {
        return this.baseRole;
    }

    public void setBaseRole(ApiAuthRoleRef baseRole) {
        this.baseRole = baseRole;
    }

    public ApiAuthRole uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    @ApiModelProperty(value="Readonly. The UUID of the authRole. <p>")
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public ApiAuthRole isCustom(Boolean isCustom) {
        this.isCustom = isCustom;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean getIsCustom() {
        return this.isCustom;
    }

    public void setIsCustom(Boolean isCustom) {
        this.isCustom = isCustom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiAuthRole apiAuthRole = (ApiAuthRole)o;
        return Objects.equals(this.displayName, apiAuthRole.displayName) && Objects.equals(this.name, apiAuthRole.name) && Objects.equals(this.clusters, apiAuthRole.clusters) && Objects.equals(this.users, apiAuthRole.users) && Objects.equals(this.externalUserMappings, apiAuthRole.externalUserMappings) && Objects.equals(this.baseRole, apiAuthRole.baseRole) && Objects.equals(this.uuid, apiAuthRole.uuid) && Objects.equals(this.isCustom, apiAuthRole.isCustom);
    }

    public int hashCode() {
        return Objects.hash(this.displayName, this.name, this.clusters, this.users, this.externalUserMappings, this.baseRole, this.uuid, this.isCustom);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiAuthRole {\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    clusters: ").append(this.toIndentedString(this.clusters)).append("\n");
        sb.append("    users: ").append(this.toIndentedString(this.users)).append("\n");
        sb.append("    externalUserMappings: ").append(this.toIndentedString(this.externalUserMappings)).append("\n");
        sb.append("    baseRole: ").append(this.toIndentedString(this.baseRole)).append("\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    isCustom: ").append(this.toIndentedString(this.isCustom)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

