/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.decorators.SingleReplyRequestDecorator;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.ModifyDnRequest;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.util.Strings;

public class ModifyDnRequestDecorator
extends SingleReplyRequestDecorator<ModifyDnRequest>
implements ModifyDnRequest {
    private int modifyDnRequestLength;
    private byte[] dnBytes;
    private byte[] newSuperiorBytes;

    public ModifyDnRequestDecorator(LdapApiService codec, ModifyDnRequest decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public Dn getName() {
        return ((ModifyDnRequest)this.getDecorated()).getName();
    }

    public ModifyDnRequest setName(Dn name) {
        ((ModifyDnRequest)this.getDecorated()).setName(name);
        return this;
    }

    public Rdn getNewRdn() {
        return ((ModifyDnRequest)this.getDecorated()).getNewRdn();
    }

    public ModifyDnRequest setNewRdn(Rdn newRdn) {
        ((ModifyDnRequest)this.getDecorated()).setNewRdn(newRdn);
        return this;
    }

    public boolean getDeleteOldRdn() {
        return ((ModifyDnRequest)this.getDecorated()).getDeleteOldRdn();
    }

    public ModifyDnRequest setDeleteOldRdn(boolean deleteOldRdn) {
        ((ModifyDnRequest)this.getDecorated()).setDeleteOldRdn(deleteOldRdn);
        return this;
    }

    public Dn getNewSuperior() {
        return ((ModifyDnRequest)this.getDecorated()).getNewSuperior();
    }

    public ModifyDnRequest setNewSuperior(Dn newSuperior) {
        ((ModifyDnRequest)this.getDecorated()).setNewSuperior(newSuperior);
        return this;
    }

    public boolean isMove() {
        return ((ModifyDnRequest)this.getDecorated()).isMove();
    }

    public ModifyDnRequest setMessageId(int messageId) {
        super.setMessageId(messageId);
        return this;
    }

    public ModifyDnRequest addControl(Control control) {
        return (ModifyDnRequest)super.addControl(control);
    }

    public ModifyDnRequest addAllControls(Control[] controls) {
        return (ModifyDnRequest)super.addAllControls(controls);
    }

    public ModifyDnRequest removeControl(Control control) {
        return (ModifyDnRequest)super.removeControl(control);
    }

    public int computeLength() {
        int newRdnlength = Strings.getBytesUtf8((String)this.getNewRdn().getName()).length;
        this.dnBytes = Strings.getBytesUtf8((String)this.getName().getName());
        this.modifyDnRequestLength = 1 + TLV.getNbBytes((int)this.dnBytes.length) + this.dnBytes.length + 1 + TLV.getNbBytes((int)newRdnlength) + newRdnlength + 1 + 1 + 1;
        if (this.getNewSuperior() != null) {
            this.newSuperiorBytes = Strings.getBytesUtf8((String)this.getNewSuperior().getName());
            this.modifyDnRequestLength += 1 + TLV.getNbBytes((int)this.newSuperiorBytes.length) + this.newSuperiorBytes.length;
        }
        return 1 + TLV.getNbBytes((int)this.modifyDnRequestLength) + this.modifyDnRequestLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)108);
            buffer.put(TLV.getBytes((int)this.modifyDnRequestLength));
            BerValue.encode((ByteBuffer)buffer, (byte[])this.dnBytes);
            BerValue.encode((ByteBuffer)buffer, (String)this.getNewRdn().getName());
            BerValue.encode((ByteBuffer)buffer, (boolean)this.getDeleteOldRdn());
            if (this.getNewSuperior() != null) {
                buffer.put((byte)-128);
                int newSuperiorLength = this.newSuperiorBytes.length;
                buffer.put(TLV.getBytes((int)newSuperiorLength));
                if (newSuperiorLength != 0) {
                    buffer.put(this.newSuperiorBytes);
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_08212_PDU_BUFFER_TOO_SMALL, (Object[])new Object[0]), (Exception)boe);
        }
        return buffer;
    }
}

