/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.logout.impl;

import java.util.List;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.EncryptedID;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.SessionIndex;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.logout.handler.LogoutHandler;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.crypto.SAML2SignatureTrustEngineProvider;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.profile.impl.AbstractSAML2ResponseValidator;

public class SAML2LogoutValidator
extends AbstractSAML2ResponseValidator {
    public SAML2LogoutValidator(SAML2SignatureTrustEngineProvider engine, Decrypter decrypter, LogoutHandler logoutHandler) {
        super(engine, decrypter, logoutHandler);
    }

    @Override
    public Credentials validate(SAML2MessageContext context) {
        WebContext webContext = context.getWebContext();
        SAMLObject message = (SAMLObject)context.getMessage();
        if (message instanceof LogoutRequest) {
            LogoutRequest logoutRequest = (LogoutRequest)message;
            SignatureTrustEngine engine = this.signatureTrustEngineProvider.build();
            this.validateLogoutRequest(logoutRequest, context, engine);
            return null;
        }
        if (message instanceof LogoutResponse) {
            LogoutResponse logoutResponse = (LogoutResponse)message;
            SignatureTrustEngine engine = this.signatureTrustEngineProvider.build();
            this.validateLogoutResponse(logoutResponse, context, engine);
            throw HttpAction.ok((WebContext)webContext, (String)"");
        }
        throw new SAMLException("Must be a LogoutRequest or LogoutResponse type");
    }

    protected void validateLogoutRequest(LogoutRequest logoutRequest, SAML2MessageContext context, SignatureTrustEngine engine) {
        String sloKey;
        SessionIndex sessionIndexObject;
        this.validateSignatureIfItExists(logoutRequest.getSignature(), context, engine);
        this.validateIssuerIfItExists(logoutRequest.getIssuer(), context);
        NameID nameId = logoutRequest.getNameID();
        EncryptedID encryptedID = logoutRequest.getEncryptedID();
        if (encryptedID != null) {
            nameId = this.decryptEncryptedId(encryptedID, this.decrypter);
        }
        String sessionIndex = null;
        List sessionIndexes = logoutRequest.getSessionIndexes();
        if (sessionIndexes != null && !sessionIndexes.isEmpty() && (sessionIndexObject = (SessionIndex)sessionIndexes.get(0)) != null) {
            sessionIndex = sessionIndexObject.getSessionIndex();
        }
        if ((sloKey = this.computeSloKey(sessionIndex, nameId)) != null) {
            String bindingUri = context.getSAMLBindingContext().getBindingUri();
            if ("urn:oasis:names:tc:SAML:2.0:bindings:SOAP".equals(bindingUri)) {
                this.logoutHandler.destroySessionBack(context.getWebContext(), sloKey);
            } else {
                this.logoutHandler.destroySessionFront(context.getWebContext(), sloKey);
            }
        }
    }

    protected void validateLogoutResponse(LogoutResponse logoutResponse, SAML2MessageContext context, SignatureTrustEngine engine) {
        this.validateSuccess(logoutResponse.getStatus());
        this.validateSignatureIfItExists(logoutResponse.getSignature(), context, engine);
        this.validateIssueInstant(logoutResponse.getIssueInstant());
        this.validateIssuerIfItExists(logoutResponse.getIssuer(), context);
        this.verifyEndpoint((Endpoint)context.getSPSSODescriptor().getSingleLogoutServices().get(0), logoutResponse.getDestination());
    }

    @Override
    public final void setMaximumAuthenticationLifetime(int maximumAuthenticationLifetime) {
    }
}

