/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.Type;

public final class FieldInfo
implements AnnotationTarget {
    private final String name;
    private final Type type;
    private final short flags;
    private final ClassInfo clazz;

    FieldInfo(ClassInfo clazz, String name, Type type, short flags) {
        this.clazz = clazz;
        this.name = name;
        this.type = type;
        this.flags = flags;
    }

    public static final FieldInfo create(ClassInfo clazz, String name, Type type, short flags) {
        if (clazz == null) {
            throw new IllegalArgumentException("Clazz can't be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name can't be null");
        }
        return new FieldInfo(clazz, name, type, flags);
    }

    public final String name() {
        return this.name;
    }

    public final ClassInfo declaringClass() {
        return this.clazz;
    }

    public final Type type() {
        return this.type;
    }

    public final short flags() {
        return this.flags;
    }

    public String toString() {
        return this.type + " " + this.clazz.name() + "." + this.name;
    }
}

