/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.trace;

import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.knox.gateway.trace.TraceOutput;
import org.apache.knox.gateway.trace.TraceUtil;
import org.apache.log4j.Logger;

class TraceResponse
extends HttpServletResponseWrapper {
    private static final Logger log = Logger.getLogger((String)"org.apache.knox.gateway.http.response");
    private static final Logger headLog = Logger.getLogger((String)"org.apache.knox.gateway.http.response.headers");
    private ServletOutputStream output;
    private Set<Integer> filter;

    TraceResponse(HttpServletResponse response, Set<Integer> filter) {
        super(response);
        this.filter = filter;
    }

    public synchronized ServletOutputStream getOutputStream() throws IOException {
        if (log.isTraceEnabled()) {
            this.traceResponseDetails();
            if (this.output == null && (this.filter == null || this.filter.isEmpty() || this.filter.contains(this.getStatus()))) {
                this.output = new TraceOutput(super.getOutputStream());
            }
            return this.output;
        }
        return super.getOutputStream();
    }

    private void traceResponseDetails() {
        StringBuilder sb = new StringBuilder();
        TraceUtil.appendCorrelationContext(sb);
        sb.append("|Response=").append(this.getStatus());
        this.appendHeaders(sb);
        log.trace((Object)sb.toString());
    }

    private void appendHeaders(StringBuilder sb) {
        if (headLog.isTraceEnabled()) {
            Collection names = this.getHeaderNames();
            for (String name : names) {
                for (String value : this.getHeaders(name)) {
                    sb.append(String.format(Locale.ROOT, "%n\tHeader[%s]=%s", name, value));
                }
            }
        }
    }
}

