/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.annotations.TenantTableDiscriminatorType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.MultitenantPolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class TablePerMultitenantPolicy
implements MultitenantPolicy,
Cloneable {
    protected ClassDescriptor descriptor;
    protected Map<DatabaseTable, DatabaseTable> tablePerTenantTables;
    protected TenantTableDiscriminatorType type;
    protected String contextProperty;
    protected String contextTenant;

    TablePerMultitenantPolicy() {
    }

    public TablePerMultitenantPolicy(ClassDescriptor desc) {
        this.descriptor = desc;
        this.type = TenantTableDiscriminatorType.SUFFIX;
        this.tablePerTenantTables = new HashMap<DatabaseTable, DatabaseTable>(4);
        this.contextProperty = "eclipselink.tenant-id";
    }

    @Override
    public void addFieldsToRow(AbstractRecord row, AbstractSession session) {
    }

    @Override
    public void addToTableDefinition(TableDefinition tableDefinition) {
    }

    @Override
    public MultitenantPolicy clone(ClassDescriptor descriptor) {
        TablePerMultitenantPolicy clonedPolicy = null;
        try {
            clonedPolicy = (TablePerMultitenantPolicy)super.clone();
            clonedPolicy.descriptor = descriptor;
            clonedPolicy.tablePerTenantTables = new HashMap<DatabaseTable, DatabaseTable>(4);
            for (DatabaseTable table : this.tablePerTenantTables.keySet()) {
                clonedPolicy.tablePerTenantTables.put(table, this.tablePerTenantTables.get(table));
            }
        }
        catch (CloneNotSupportedException exception) {
            throw new InternalError(exception.getMessage());
        }
        return clonedPolicy;
    }

    public String getContextProperty() {
        return this.contextProperty;
    }

    public DatabaseTable getTable(String tableName) {
        return this.tablePerTenantTables.get(new DatabaseTable(tableName));
    }

    public DatabaseTable getTable(DatabaseTable table) {
        return this.tablePerTenantTables.get(table);
    }

    protected String getTableName(DatabaseTable table, String tenant) {
        if (this.isPrefixPerTable()) {
            return String.valueOf(tenant) + "_" + table.getName();
        }
        return String.valueOf(table.getName()) + "_" + tenant;
    }

    public boolean hasContextTenant() {
        return this.contextTenant != null;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        session.addMultitenantContextProperty(this.contextProperty);
    }

    public boolean isPrefixPerTable() {
        return this.type == TenantTableDiscriminatorType.PREFIX;
    }

    public boolean isSchemaPerTable() {
        return this.type == TenantTableDiscriminatorType.SCHEMA;
    }

    @Override
    public boolean isSingleTableMultitenantPolicy() {
        return false;
    }

    @Override
    public boolean isSchemaPerMultitenantPolicy() {
        return false;
    }

    public boolean isSuffixPerTable() {
        return this.type == null || this.type == TenantTableDiscriminatorType.SUFFIX;
    }

    @Override
    public boolean isTablePerMultitenantPolicy() {
        return true;
    }

    @Override
    public void postInitialize(AbstractSession session) {
    }

    @Override
    public void preInitialize(AbstractSession session) throws DescriptorException {
    }

    public void setTenantTableDiscriminatorType(TenantTableDiscriminatorType type) {
        this.type = type;
    }

    public void setContextProperty(String contextProperty) {
        this.contextProperty = contextProperty;
    }

    protected void setTablePerTenant() {
        NonSynchronizedVector tables = NonSynchronizedVector.newInstance(3);
        for (DatabaseTable table : this.descriptor.getTables()) {
            ((Vector)tables).add(this.updateTable(table));
        }
        this.descriptor.setTables(tables);
        Map<DatabaseTable, Set<DatabaseTable>> existingMultipleTables = this.descriptor.getMultipleTableForeignKeys();
        if (existingMultipleTables != null && !existingMultipleTables.isEmpty()) {
            HashMap<DatabaseTable, Set<DatabaseTable>> updatedMultipleTables = new HashMap<DatabaseTable, Set<DatabaseTable>>();
            HashSet<DatabaseTable> secondaryTables = new HashSet<DatabaseTable>();
            for (DatabaseTable table : existingMultipleTables.keySet()) {
                for (DatabaseTable secondaryTable : existingMultipleTables.get(table)) {
                    DatabaseTable updatedSecondaryTable = this.getTable(secondaryTable);
                    if (updatedSecondaryTable == null) {
                        secondaryTables.add(secondaryTable);
                        continue;
                    }
                    secondaryTables.add(updatedSecondaryTable);
                }
                DatabaseTable updatedTable = this.getTable(table);
                if (updatedTable == null) {
                    updatedMultipleTables.put(table, secondaryTables);
                    continue;
                }
                updatedMultipleTables.put(updatedTable, secondaryTables);
            }
            this.descriptor.setMultipleTableForeignKeys(updatedMultipleTables);
        }
        for (DatabaseMapping mapping : this.descriptor.getMappings()) {
            if (mapping.isManyToManyMapping()) {
                if (mapping.isReadOnly()) continue;
                ((ManyToManyMapping)mapping).setRelationTable(this.updateTable(((ManyToManyMapping)mapping).getRelationTable()));
                continue;
            }
            if (mapping.isOneToOneMapping() && ((OneToOneMapping)mapping).hasRelationTable()) {
                ((OneToOneMapping)mapping).setRelationTable(this.updateTable(((OneToOneMapping)mapping).getRelationTable()));
                continue;
            }
            if (!mapping.isDirectCollectionMapping()) continue;
            ((DirectCollectionMapping)mapping).setReferenceTable(this.updateTable(((DirectCollectionMapping)mapping).getReferenceTable()));
        }
    }

    protected void setTableSchemaPerTenant() {
        this.descriptor.setTableQualifier(this.contextTenant);
        for (DatabaseMapping mapping : this.descriptor.getMappings()) {
            if (mapping.isManyToManyMapping()) {
                ((ManyToManyMapping)mapping).getRelationTable().setTableQualifier(this.contextTenant);
                continue;
            }
            if (mapping.isOneToOneMapping() && ((OneToOneMapping)mapping).hasRelationTable()) {
                ((OneToOneMapping)mapping).getRelationTable().setTableQualifier(this.contextTenant);
                continue;
            }
            if (!mapping.isDirectCollectionMapping()) continue;
            ((DirectCollectionMapping)mapping).getReferenceTable().setTableQualifier(this.contextTenant);
        }
    }

    public void setContextTenant(String contextTenant) {
        this.contextTenant = contextTenant;
        if (this.isSchemaPerTable()) {
            this.setTableSchemaPerTenant();
        } else {
            this.setTablePerTenant();
        }
    }

    public boolean shouldInitialize(AbstractSession session) {
        String tenant;
        if (!this.hasContextTenant() && (tenant = (String)session.getProperty(this.contextProperty)) != null) {
            this.setContextTenant(tenant);
        }
        return this.hasContextTenant();
    }

    protected DatabaseTable updateTable(DatabaseTable table) {
        DatabaseTable tableClone = table.clone();
        this.tablePerTenantTables.put(table, tableClone);
        tableClone.setName(this.getTableName(tableClone, this.contextTenant));
        return tableClone;
    }

    public boolean usesContextProperty(String property) {
        return this.contextProperty.equals(property);
    }
}

