/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.servlet;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import org.apache.shiro.web.servlet.ShiroHttpServletRequest;

public class ShiroHttpServletResponse
extends HttpServletResponseWrapper {
    private static final String DEFAULT_SESSION_ID_PARAMETER_NAME = "JSESSIONID";
    private ServletContext context = null;
    private ShiroHttpServletRequest request = null;

    public ShiroHttpServletResponse(HttpServletResponse wrapped, ServletContext context, ShiroHttpServletRequest request) {
        super(wrapped);
        this.context = context;
        this.request = request;
    }

    public ServletContext getContext() {
        return this.context;
    }

    public void setContext(ServletContext context) {
        this.context = context;
    }

    public ShiroHttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(ShiroHttpServletRequest request) {
        this.request = request;
    }

    public String encodeRedirectURL(String url) {
        if (this.isEncodeable(this.toAbsolute(url))) {
            return this.toEncoded(url, this.request.getSession().getId());
        }
        return url;
    }

    public String encodeRedirectUrl(String s) {
        return this.encodeRedirectURL(s);
    }

    public String encodeURL(String url) {
        String absolute = this.toAbsolute(url);
        if (this.isEncodeable(absolute)) {
            if (url.equalsIgnoreCase("")) {
                url = absolute;
            }
            return this.toEncoded(url, this.request.getSession().getId());
        }
        return url;
    }

    public String encodeUrl(String s) {
        return this.encodeURL(s);
    }

    protected boolean isEncodeable(String location) {
        if (Boolean.FALSE.equals(this.request.getAttribute(ShiroHttpServletRequest.SESSION_ID_URL_REWRITING_ENABLED))) {
            return false;
        }
        if (location == null) {
            return false;
        }
        if (location.startsWith("#")) {
            return false;
        }
        ShiroHttpServletRequest hreq = this.request;
        HttpSession session = hreq.getSession(false);
        if (session == null) {
            return false;
        }
        if (hreq.isRequestedSessionIdFromCookie()) {
            return false;
        }
        return this.doIsEncodeable((HttpServletRequest)hreq, session, location);
    }

    private boolean doIsEncodeable(HttpServletRequest hreq, HttpSession session, String location) {
        int urlPort;
        URL url;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException e) {
            return false;
        }
        if (!hreq.getScheme().equalsIgnoreCase(url.getProtocol())) {
            return false;
        }
        if (!hreq.getServerName().equalsIgnoreCase(url.getHost())) {
            return false;
        }
        int serverPort = hreq.getServerPort();
        if (serverPort == -1) {
            serverPort = "https".equals(hreq.getScheme()) ? 443 : 80;
        }
        if ((urlPort = url.getPort()) == -1) {
            urlPort = "https".equals(url.getProtocol()) ? 443 : 80;
        }
        if (serverPort != urlPort) {
            return false;
        }
        String contextPath = this.getRequest().getContextPath();
        if (contextPath != null) {
            String file = url.getFile();
            if (file == null || !file.startsWith(contextPath)) {
                return false;
            }
            String tok = ";JSESSIONID=" + session.getId();
            if (file.indexOf(tok, contextPath.length()) >= 0) {
                return false;
            }
        }
        return true;
    }

    private String toAbsolute(String location) {
        if (location == null) {
            return location;
        }
        boolean leadingSlash = location.startsWith("/");
        if (leadingSlash || !this.hasScheme(location)) {
            StringBuilder buf = new StringBuilder();
            String scheme = this.request.getScheme();
            String name = this.request.getServerName();
            int port = this.request.getServerPort();
            try {
                buf.append(scheme).append("://").append(name);
                if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
                    buf.append(':').append(port);
                }
                if (!leadingSlash) {
                    String relativePath = this.request.getRequestURI();
                    int pos = relativePath.lastIndexOf(47);
                    relativePath = relativePath.substring(0, pos);
                    String encodedURI = URLEncoder.encode(relativePath, this.getCharacterEncoding());
                    buf.append(encodedURI).append('/');
                }
                buf.append(location);
            }
            catch (IOException e) {
                IllegalArgumentException iae = new IllegalArgumentException(location);
                iae.initCause(e);
                throw iae;
            }
            return buf.toString();
        }
        return location;
    }

    public static boolean isSchemeChar(char c) {
        return Character.isLetterOrDigit(c) || c == '+' || c == '-' || c == '.';
    }

    private boolean hasScheme(String uri) {
        int len = uri.length();
        for (int i = 0; i < len; ++i) {
            char c = uri.charAt(i);
            if (c == ':') {
                return i > 0;
            }
            if (ShiroHttpServletResponse.isSchemeChar(c)) continue;
            return false;
        }
        return false;
    }

    protected String toEncoded(String url, String sessionId) {
        StringBuilder sb;
        int pound;
        if (url == null || sessionId == null) {
            return url;
        }
        String path = url;
        String query = "";
        String anchor = "";
        int question = url.indexOf(63);
        if (question >= 0) {
            path = url.substring(0, question);
            query = url.substring(question);
        }
        if ((pound = path.indexOf(35)) >= 0) {
            anchor = path.substring(pound);
            path = path.substring(0, pound);
        }
        if ((sb = new StringBuilder(path)).length() > 0) {
            sb.append(";");
            sb.append(DEFAULT_SESSION_ID_PARAMETER_NAME);
            sb.append("=");
            sb.append(sessionId);
        }
        sb.append(anchor);
        sb.append(query);
        return sb.toString();
    }
}

