/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.dispatch;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.knox.gateway.SpiGatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;

public class HadoopAuthCookieStore
extends BasicCookieStore {
    private static final SpiGatewayMessages LOG = (SpiGatewayMessages)MessagesFactory.get(SpiGatewayMessages.class);
    private static final String HADOOP_AUTH_COOKIE_NAME = "hadoop.auth";
    private static final String HIVE_SERVER2_AUTH_COOKIE_NAME = "hive.server2.auth";
    private static final String IMPALA_AUTH_COOKIE_NAME = "impala.auth";
    private static String knoxPrincipal;
    private static String shortKnoxPrincipal;

    HadoopAuthCookieStore(GatewayConfig config) {
        String krb5Config = config.getKerberosLoginConfig();
        if (krb5Config != null && !krb5Config.isEmpty()) {
            Properties p = new Properties();
            try (InputStream in = Files.newInputStream(Paths.get(krb5Config, new String[0]), new OpenOption[0]);){
                p.load(in);
                String configuredKnoxPrincipal = p.getProperty("principal");
                if (configuredKnoxPrincipal.startsWith("\"")) {
                    configuredKnoxPrincipal = configuredKnoxPrincipal.substring(1, configuredKnoxPrincipal.length() - 1);
                }
                knoxPrincipal = configuredKnoxPrincipal;
                shortKnoxPrincipal = knoxPrincipal.split("/", 2)[0];
            }
            catch (IOException e) {
                LOG.errorReadingKerberosLoginConfig(krb5Config, e);
            }
        }
    }

    public void addCookie(Cookie cookie) {
        if (this.isAuthCookie(cookie) && this.isKnoxCookie(cookie)) {
            Wrapper wrapper = new Wrapper(cookie);
            LOG.acceptingServiceCookie((Cookie)wrapper);
            super.addCookie((Cookie)wrapper);
        }
    }

    private boolean isAuthCookie(Cookie cookie) {
        return HADOOP_AUTH_COOKIE_NAME.equals(cookie.getName()) || HIVE_SERVER2_AUTH_COOKIE_NAME.equals(cookie.getName()) || IMPALA_AUTH_COOKIE_NAME.equals(cookie.getName());
    }

    private boolean isKnoxCookie(Cookie cookie) {
        String value;
        boolean result = false;
        if (cookie != null && (value = cookie.getValue()) != null && (value.contains('=' + knoxPrincipal) || value.contains('=' + shortKnoxPrincipal))) {
            result = true;
        }
        return result;
    }

    private static class Wrapper
    extends BasicClientCookie {
        private static final String DELEGATE_STR = "delegate";
        private final Cookie delegate;

        Wrapper(Cookie delegate) {
            super(delegate.getName(), delegate.getValue());
            this.delegate = delegate;
        }

        public String getName() {
            return this.delegate.getName();
        }

        public String getValue() {
            String value = this.delegate.getValue();
            if (value != null && !value.isEmpty()) {
                if (!value.startsWith("\"")) {
                    value = "\"" + value;
                }
                if (!value.endsWith("\"")) {
                    value = value + "\"";
                }
            }
            return value;
        }

        public String getComment() {
            return this.delegate.getComment();
        }

        public String getCommentURL() {
            return this.delegate.getCommentURL();
        }

        public Date getExpiryDate() {
            return this.delegate.getExpiryDate();
        }

        public boolean isPersistent() {
            return this.delegate.isPersistent();
        }

        public String getDomain() {
            return this.delegate.getDomain();
        }

        public String getPath() {
            return this.delegate.getPath();
        }

        public int[] getPorts() {
            return this.delegate.getPorts();
        }

        public boolean isSecure() {
            return this.delegate.isSecure();
        }

        public int getVersion() {
            return this.delegate.getVersion();
        }

        public boolean isExpired(Date date) {
            return this.delegate.isExpired(date);
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this){

                protected boolean accept(Field f) {
                    return super.accept(f) && !Wrapper.DELEGATE_STR.equals(f.getName());
                }
            }.toString();
        }
    }
}

