/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.hive;

import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModelGeneratorHandleResponse;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class IcebergRestServiceModelGenerator
extends AbstractServiceModelGenerator {
    public static final String SERVICE = "ICEBERG-REST";
    public static final String SERVICE_TYPE = "HIVE";
    public static final String ROLE_TYPE = "HIVEMETASTORE";
    static final String HTTP_PORT = "hive_metastore_catalog_servlet_port";
    static final String HTTP_PATH = "hive_metastore_catalog_servlet_path";
    static final String REST_CATALOG_ENABLED = "hive_rest_catalog_enabled";
    static final String DEFAULT_HTTP_PATH = "icecli";

    @Override
    public String getService() {
        return SERVICE;
    }

    @Override
    public String getServiceType() {
        return SERVICE_TYPE;
    }

    @Override
    public String getRoleType() {
        return ROLE_TYPE;
    }

    @Override
    public ServiceModel.Type getModelType() {
        return ServiceModel.Type.API;
    }

    @Override
    public ServiceModelGeneratorHandleResponse handles(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) {
        ServiceModelGeneratorHandleResponse response = super.handles(service, serviceConfig, role, roleConfig);
        if (response.handled()) {
            this.validateCatalogEnabled(serviceConfig, response);
        }
        return response;
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig, ApiServiceConfig coreSettingsConfig) throws ApiException {
        String hostname = role.getHostRef().getHostname();
        String scheme = "http";
        String port = this.getHttpPort(serviceConfig);
        String httpPath = this.getHttpPath(serviceConfig);
        if (httpPath == null) {
            httpPath = DEFAULT_HTTP_PATH;
        }
        ServiceModel model = this.createServiceModel(String.format(Locale.getDefault(), "%s://%s:%s/%s", scheme, hostname, port, httpPath));
        model.addServiceProperty(HTTP_PORT, this.getHttpPort(serviceConfig));
        model.addServiceProperty(HTTP_PATH, this.getHttpPath(serviceConfig));
        model.addServiceProperty(REST_CATALOG_ENABLED, this.getRestCatalogEnabled(serviceConfig));
        return model;
    }

    protected String getHttpPort(ApiServiceConfig serviceConfig) {
        return this.getServiceConfigValue(serviceConfig, HTTP_PORT);
    }

    protected String getHttpPath(ApiServiceConfig serviceConfig) {
        return this.getServiceConfigValue(serviceConfig, HTTP_PATH);
    }

    protected String getRestCatalogEnabled(ApiServiceConfig serviceConfig) {
        return this.getServiceConfigValue(serviceConfig, REST_CATALOG_ENABLED);
    }

    protected void validateCatalogEnabled(ApiServiceConfig serviceConfig, ServiceModelGeneratorHandleResponse response) {
        String catalogEnabledValue = this.getRestCatalogEnabled(serviceConfig);
        boolean isCatalogEnabled = Boolean.parseBoolean(catalogEnabledValue);
        if (!isCatalogEnabled) {
            response.addConfigurationIssue("Invalid configuration: hive_rest_catalog_enabled. Expected=true; Found=" + catalogEnabledValue);
        }
    }
}

