/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.knox.gateway.RemoteAuthMessages;
import org.apache.knox.gateway.audit.api.AuditContext;
import org.apache.knox.gateway.audit.api.AuditService;
import org.apache.knox.gateway.audit.api.AuditServiceFactory;
import org.apache.knox.gateway.audit.api.Auditor;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.security.GroupPrincipal;
import org.apache.knox.gateway.security.PrimaryPrincipal;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.apache.knox.gateway.services.security.KeystoreServiceException;
import org.apache.logging.log4j.ThreadContext;

public class RemoteAuthFilter
implements Filter {
    static final String REMOTE_AUTH = "remote.auth.";
    static final String CONFIG_REMOTE_AUTH_URL = "remote.auth.url";
    static final String CONFIG_INCLUDE_HEADERS = "remote.auth.include.headers";
    static final String CONFIG_CACHE_KEY_HEADER = "remote.auth.cache.key";
    static final String CONFIG_EXPIRE_AFTER = "remote.auth.expire.after";
    static final String DEFAULT_CACHE_KEY_HEADER = "Authorization";
    static final String CONFIG_USER_HEADER = "remote.auth.user.header";
    static final String CONFIG_GROUP_HEADER = "remote.auth.group.header";
    static final String DEFAULT_CONFIG_USER_HEADER = "X-Knox-Actor-ID";
    static final String DEFAULT_CONFIG_GROUP_HEADER = "X-Knox-Actor-Groups-*";
    static final String CONFIG_TRUSTSTORE_PATH = "remote.auth.truststore.path";
    static final String CONFIG_TRUSTSTORE_PASSWORD = "remote.auth.truststore.password";
    static final String CONFIG_TRUSTSTORE_TYPE = "remote.auth.truststore.type";
    static final String DEFAULT_TRUSTSTORE_TYPE = "JKS";
    static final String WILDCARD = "*";
    static final String TRACE_ID = "trace_id";
    static final String REQUEST_ID_HEADER_NAME = "X-Request-Id";
    static final String TRUSTSTORE_CONFIGURATION_CANNOT_BE_RESOLVED_INTO_A_VALID_TRUSTSTORE = "Truststore configuration cannot be resolved into a valid truststore";
    private String remoteAuthUrl;
    private List<String> includeHeaders;
    private String cacheKeyHeader;
    private String userHeader;
    private List<String> groupHeaders;
    HttpURLConnection httpURLConnection;
    private Cache<String, Subject> authenticationCache;
    private static final AuditService auditService = AuditServiceFactory.getAuditService();
    private static final Auditor auditor = auditService.getAuditor("audit", "knox", "knox");
    private final RemoteAuthMessages LOGGER = (RemoteAuthMessages)MessagesFactory.get(RemoteAuthMessages.class);
    private KeyStore trustStore;

    public void init(FilterConfig filterConfig) throws ServletException {
        String groupHeaderParam;
        this.remoteAuthUrl = filterConfig.getInitParameter(CONFIG_REMOTE_AUTH_URL);
        if (this.remoteAuthUrl == null || this.remoteAuthUrl.isEmpty()) {
            this.LOGGER.missingRequiredParameter(CONFIG_REMOTE_AUTH_URL);
            throw new ServletException("remote.auth.url is a missing required param.");
        }
        this.includeHeaders = Arrays.asList(filterConfig.getInitParameter(CONFIG_INCLUDE_HEADERS).split(","));
        this.cacheKeyHeader = filterConfig.getInitParameter(CONFIG_CACHE_KEY_HEADER) != null ? filterConfig.getInitParameter(CONFIG_CACHE_KEY_HEADER) : DEFAULT_CACHE_KEY_HEADER;
        String cacheTime = filterConfig.getInitParameter(CONFIG_EXPIRE_AFTER);
        if (cacheTime != null) {
            int expireAfterMinutes = Integer.parseInt(cacheTime);
            this.authenticationCache = CacheBuilder.newBuilder().expireAfterWrite((long)expireAfterMinutes, TimeUnit.MINUTES).build();
        }
        this.userHeader = filterConfig.getInitParameter(CONFIG_USER_HEADER);
        if (this.userHeader == null || this.userHeader.isEmpty()) {
            this.userHeader = DEFAULT_CONFIG_USER_HEADER;
        }
        this.groupHeaders = (groupHeaderParam = filterConfig.getInitParameter(CONFIG_GROUP_HEADER)) == null || groupHeaderParam.isEmpty() ? Arrays.asList(DEFAULT_CONFIG_GROUP_HEADER) : Arrays.asList(groupHeaderParam.split("\\s*,\\s*"));
        this.buildTrustStore(filterConfig);
    }

    private void buildTrustStore(FilterConfig filterConfig) throws ServletException {
        ServletContext context;
        String truststorePath = filterConfig.getInitParameter(CONFIG_TRUSTSTORE_PATH);
        String truststorePassword = filterConfig.getInitParameter(CONFIG_TRUSTSTORE_PASSWORD);
        String truststoreType = filterConfig.getInitParameter(CONFIG_TRUSTSTORE_TYPE);
        if (truststoreType == null || truststoreType.isEmpty()) {
            truststoreType = DEFAULT_TRUSTSTORE_TYPE;
        }
        if ((context = filterConfig.getServletContext()) != null) {
            String topologyName = (String)context.getAttribute("org.apache.knox.gateway.gateway.cluster");
            GatewayServices services = (GatewayServices)context.getAttribute("org.apache.knox.gateway.gateway.services");
            if (services != null) {
                try {
                    AliasService aliasService = (AliasService)services.getService(ServiceType.ALIAS_SERVICE);
                    if (truststorePath != null && !truststorePath.isEmpty() && (truststorePassword == null || truststorePassword.isEmpty())) {
                        char[] passChars = aliasService.getPasswordFromAliasForCluster(topologyName, CONFIG_TRUSTSTORE_PASSWORD, false);
                        if (passChars != null) {
                            truststorePassword = new String(passChars);
                        }
                        if (truststorePassword == null || truststorePassword.isEmpty()) {
                            truststorePassword = new String(aliasService.getPasswordFromAliasForGateway(CONFIG_TRUSTSTORE_PASSWORD));
                        }
                    }
                    KeystoreService keystoreService = (KeystoreService)services.getService(ServiceType.KEYSTORE_SERVICE);
                    this.trustStore = this.getTrustStore(truststorePath, truststoreType, truststorePassword, keystoreService);
                }
                catch (IOException | AliasServiceException e) {
                    throw new ServletException("Error while initializing RemoteAuthProvider", e);
                }
            }
        }
        if (this.trustStore == null) {
            throw new ServletException(TRUSTSTORE_CONFIGURATION_CANNOT_BE_RESOLVED_INTO_A_VALID_TRUSTSTORE);
        }
    }

    private KeyStore getTrustStore(String truststorePath, String truststoreType, String truststorePassword, KeystoreService keystoreService) throws IOException {
        KeyStore truststore = null;
        try {
            if (truststorePath != null && !truststorePath.isEmpty() && (truststore = keystoreService.loadTruststore(truststorePath, truststoreType, truststorePassword)) == null) {
                throw new IOException(TRUSTSTORE_CONFIGURATION_CANNOT_BE_RESOLVED_INTO_A_VALID_TRUSTSTORE);
            }
            if (truststore == null && (truststore = keystoreService.getTruststoreForHttpClient()) == null) {
                truststore = keystoreService.getKeystoreForGateway();
            }
        }
        catch (KeystoreServiceException e) {
            this.LOGGER.failedToLoadTruststore(e.getMessage(), (Exception)((Object)e));
            throw new IOException("Failed to load truststore: ", e);
        }
        return truststore;
    }

    public SSLSocketFactory createSSLSocketFactory(KeyStore trustStore) throws Exception {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(trustStore);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, tmf.getTrustManagers(), null);
        return sslContext.getSocketFactory();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String cacheKey = httpRequest.getHeader(this.cacheKeyHeader);
        Subject cachedSubject = (Subject)this.authenticationCache.getIfPresent((Object)this.hashCacheKey(cacheKey));
        if (cachedSubject != null) {
            this.continueWithEstablishedSecurityContext(cachedSubject, httpRequest, httpResponse, filterChain);
            return;
        }
        try {
            int responseCode;
            HttpURLConnection connection = this.getHttpURLConnection();
            for (String header : this.includeHeaders) {
                String headerValue = httpRequest.getHeader(header);
                if (headerValue == null) continue;
                connection.addRequestProperty(header, headerValue);
            }
            String traceId = ThreadContext.get((String)TRACE_ID);
            if (traceId != null) {
                connection.addRequestProperty(REQUEST_ID_HEADER_NAME, ThreadContext.get((String)TRACE_ID));
            }
            if ((responseCode = connection.getResponseCode()) == 200) {
                String principalName = connection.getHeaderField(this.userHeader);
                Subject subject = new Subject();
                subject.getPrincipals().add((Principal)new PrimaryPrincipal(principalName));
                this.addGroupPrincipals(subject, connection);
                this.authenticationCache.put((Object)this.hashCacheKey(cacheKey), (Object)subject);
                AuditContext context = auditService.getContext();
                if (context != null) {
                    context.setUsername(principalName);
                    auditService.attachContext(context);
                    String sourceUri = (String)request.getAttribute("sourceRequestContextUrl");
                    auditor.audit("authentication", sourceUri, "uri", "success", "Groups: " + Arrays.toString(subject.getPrincipals(GroupPrincipal.class).stream().map(GroupPrincipal::getName).toArray(String[]::new)));
                }
                this.continueWithEstablishedSecurityContext(subject, httpRequest, httpResponse, filterChain);
            } else {
                this.LOGGER.failedToAuthenticateToRemoteAuthServer();
                httpResponse.sendError(401, "Authentication failed");
            }
        }
        catch (Exception e) {
            this.LOGGER.errorReceivedWhileAuthenticatingRequest(e);
            httpResponse.sendError(500, "Error processing authentication request");
        }
    }

    private HttpURLConnection getHttpURLConnection() throws IOException {
        HttpURLConnection connection;
        if (this.httpURLConnection == null) {
            URL url = new URL(this.remoteAuthUrl);
            connection = (HttpURLConnection)url.openConnection();
            if (this.trustStore != null) {
                try {
                    ((HttpsURLConnection)connection).setSSLSocketFactory(this.createSSLSocketFactory(this.trustStore));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            connection = this.httpURLConnection;
        }
        return connection;
    }

    private void continueWithEstablishedSecurityContext(Subject subject, final HttpServletRequest request, final HttpServletResponse response, final FilterChain chain) throws IOException, ServletException {
        try {
            Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            throw new ServletException(t);
        }
    }

    private void addGroupPrincipals(Subject subject, HttpURLConnection connection) {
        for (String headerPattern : this.groupHeaders) {
            if (headerPattern.endsWith(WILDCARD)) {
                String prefix = headerPattern.substring(0, headerPattern.length() - 1);
                connection.getHeaderFields().forEach((key, value) -> {
                    if (key != null && key.startsWith(prefix)) {
                        this.addGroupsFromHeaderValue(subject, (List<String>)value);
                    }
                });
                continue;
            }
            String groupNames = connection.getHeaderField(headerPattern);
            if (groupNames == null || groupNames.isEmpty()) continue;
            this.addGroupsFromHeaderValue(subject, Arrays.asList(groupNames));
        }
    }

    private void addGroupsFromHeaderValue(Subject subject, List<String> headerValues) {
        headerValues.forEach(headerValue -> {
            if (headerValue != null && !headerValue.isEmpty()) {
                Arrays.stream(headerValue.split(",")).map(String::trim).filter(group -> !group.isEmpty()).forEach(groupName -> subject.getPrincipals().add((Principal)new GroupPrincipal(groupName)));
            }
        });
    }

    public void destroy() {
    }

    private String hashCacheKey(String key) {
        return String.valueOf(key.hashCode());
    }

    void setCachedSubject(String cacheKey, Subject subject) {
        this.authenticationCache.put((Object)this.hashCacheKey(cacheKey), (Object)subject);
    }
}

