/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import aQute.bnd.annotation.spi.ServiceProvider;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.context.internal.GarbageFreeSortedArrayThreadContextMap;
import org.apache.logging.log4j.core.impl.CoreProperties;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.kit.env.PropertyEnvironment;
import org.apache.logging.log4j.plugins.Inject;
import org.apache.logging.log4j.plugins.di.ConfigurableInstanceFactory;
import org.apache.logging.log4j.plugins.di.DI;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.spi.DefaultThreadContextMap;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.log4j.spi.NoOpThreadContextMap;
import org.apache.logging.log4j.spi.Provider;
import org.apache.logging.log4j.spi.ThreadContextMap;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Constants;
import org.apache.logging.log4j.util.LoaderUtil;
import org.jspecify.annotations.NullMarked;

@NullMarked
@ServiceProvider(value=Provider.class, resolution="optional")
public class Log4jProvider
extends Provider {
    private static final String NO_OP_CONTEXT_MAP = "NoOp";
    private static final String WEB_APP_CONTEXT_MAP = "WebApp";
    private static final String GARBAGE_FREE_CONTEXT_MAP = "GarbageFree";
    private static final String WEB_APP_CLASS_NAME = "org.apache.logging.log4j.spi.DefaultThreadContextMap";
    private static final String GARBAGE_FREE_CLASS_NAME = "org.apache.logging.log4j.core.context.internal.GarbageFreeSortedArrayThreadContextMap";
    private static final Logger LOGGER = StatusLogger.getLogger();
    final ConfigurableInstanceFactory instanceFactory;

    public Log4jProvider() {
        this(DI.createInitializedFactory());
    }

    @Inject
    public Log4jProvider(ConfigurableInstanceFactory instanceFactory) {
        super(Integer.valueOf(10), "2.6.0", Log4jContextFactory.class);
        this.instanceFactory = instanceFactory;
        instanceFactory.registerBinding(Key.forClass(Provider.class), () -> this);
        instanceFactory.registerBinding(Key.forClass(Log4jProvider.class), () -> this);
        instanceFactory.registerBinding(Key.forClass(ThreadContextMap.class), this::createThreadContextMap);
    }

    public LoggerContextFactory getLoggerContextFactory() {
        return (LoggerContextFactory)this.instanceFactory.getInstance(Key.forClass(LoggerContextFactory.class));
    }

    public String getThreadContextMap() {
        PropertyEnvironment environment = (PropertyEnvironment)this.instanceFactory.getInstance(PropertyEnvironment.class);
        CoreProperties.ThreadContextProperties threadContext = (CoreProperties.ThreadContextProperties)environment.getProperty(CoreProperties.ThreadContextProperties.class);
        if (threadContext.enable() && threadContext.map().enable()) {
            if (threadContext.map().type() != null) {
                return threadContext.map().type();
            }
            return Constants.ENABLE_THREADLOCALS && threadContext.map().garbageFree() ? GARBAGE_FREE_CONTEXT_MAP : WEB_APP_CONTEXT_MAP;
        }
        return NO_OP_CONTEXT_MAP;
    }

    public ThreadContextMap getThreadContextMapInstance() {
        return (ThreadContextMap)this.instanceFactory.getInstance(Key.forClass(ThreadContextMap.class));
    }

    private ThreadContextMap createThreadContextMap() {
        String threadContextMapClass;
        switch (threadContextMapClass = this.getThreadContextMap()) {
            case "NoOp": {
                return NoOpThreadContextMap.INSTANCE;
            }
            case "WebApp": 
            case "org.apache.logging.log4j.spi.DefaultThreadContextMap": {
                return new DefaultThreadContextMap();
            }
            case "GarbageFree": 
            case "org.apache.logging.log4j.core.context.internal.GarbageFreeSortedArrayThreadContextMap": {
                return new GarbageFreeSortedArrayThreadContextMap();
            }
        }
        try {
            return (ThreadContextMap)LoaderUtil.newCheckedInstanceOf((String)threadContextMapClass, ThreadContextMap.class);
        }
        catch (Exception e) {
            LOGGER.error("Unable to create instance of class {}.", (Object)threadContextMapClass, (Object)e);
            LOGGER.warn("Falling back to {}.", (Object)NoOpThreadContextMap.class.getName());
            return NoOpThreadContextMap.INSTANCE;
        }
    }

    void resetThreadContextMap() {
        Key key = Key.forClass(ThreadContextMap.class);
        this.instanceFactory.removeBinding(key);
        this.instanceFactory.registerBinding(key, this::createThreadContextMap);
    }
}

