/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spell.SuggestMode;
import org.apache.lucene.search.spell.SuggestWord;
import org.apache.solr.client.solrj.response.SpellCheckResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.ShardParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.params.SpellingParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrEventListener;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.handler.component.SpellCheckMergeData;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.spelling.ConjunctionSolrSpellChecker;
import org.apache.solr.spelling.IndexBasedSpellChecker;
import org.apache.solr.spelling.QueryConverter;
import org.apache.solr.spelling.SolrSpellChecker;
import org.apache.solr.spelling.SpellCheckCollation;
import org.apache.solr.spelling.SpellCheckCollator;
import org.apache.solr.spelling.SpellingOptions;
import org.apache.solr.spelling.SpellingQueryConverter;
import org.apache.solr.spelling.SpellingResult;
import org.apache.solr.spelling.Token;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpellCheckComponent
extends SearchComponent
implements SolrCoreAware,
SpellingParams {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final boolean DEFAULT_ONLY_MORE_POPULAR = false;
    public static final String COMPONENT_NAME = "spellcheck";
    protected NamedList initParams;
    protected Map<String, SolrSpellChecker> spellCheckers = new ConcurrentHashMap<String, SolrSpellChecker>();
    protected QueryConverter queryConverter;

    @Override
    public void init(NamedList args) {
        super.init(args);
        this.initParams = args;
    }

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false)) {
            return;
        }
        SolrSpellChecker spellChecker = this.getSpellChecker(params);
        if (params.getBool("spellcheck.build", false)) {
            spellChecker.build(rb.req.getCore(), rb.req.getSearcher());
            rb.rsp.add("command", "build");
        } else if (params.getBool("spellcheck.reload", false)) {
            spellChecker.reload(rb.req.getCore(), rb.req.getSearcher());
            rb.rsp.add("command", "reload");
        }
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false) || this.spellCheckers.isEmpty()) {
            return;
        }
        boolean shardRequest = "true".equals(params.get("isShard"));
        SolrSpellChecker spellChecker = this.getSpellChecker(params);
        if (spellChecker != null) {
            Collection<Token> tokens;
            String q = params.get("spellcheck.q");
            if (q != null) {
                tokens = this.getTokens(q, spellChecker.getQueryAnalyzer());
            } else {
                q = rb.getQueryString();
                if (q == null) {
                    q = params.get("q");
                }
                tokens = this.queryConverter.convert(q);
            }
            if (tokens != null && !tokens.isEmpty()) {
                int count = params.getInt("spellcheck.count", 1);
                boolean onlyMorePopular = params.getBool("spellcheck.onlyMorePopular", false);
                boolean extendedResults = params.getBool("spellcheck.extendedResults", false);
                boolean collate = params.getBool("spellcheck.collate", false);
                float accuracy = params.getFloat("spellcheck.accuracy", Float.MIN_VALUE);
                int alternativeTermCount = params.getInt("spellcheck.alternativeTermCount", 0);
                Integer maxResultsForSuggest = this.maxResultsForSuggest(rb);
                ModifiableSolrParams customParams = new ModifiableSolrParams();
                for (String checkerName : this.getDictionaryNames(params)) {
                    customParams.add(this.getCustomParams(checkerName, params));
                }
                Number hitsLong = (Number)rb.rsp.getToLog().get("hits");
                long hits = 0L;
                hits = hitsLong == null ? rb.getNumberDocumentsFound() : hitsLong.longValue();
                SpellingResult spellingResult = null;
                if (maxResultsForSuggest == null || hits <= (long)maxResultsForSuggest.intValue()) {
                    SuggestMode suggestMode = SuggestMode.SUGGEST_WHEN_NOT_IN_INDEX;
                    if (onlyMorePopular) {
                        suggestMode = SuggestMode.SUGGEST_MORE_POPULAR;
                    } else if (alternativeTermCount > 0) {
                        suggestMode = SuggestMode.SUGGEST_ALWAYS;
                    }
                    DirectoryReader reader = rb.req.getSearcher().getIndexReader();
                    SpellingOptions options = new SpellingOptions(tokens, (IndexReader)reader, count, alternativeTermCount, suggestMode, extendedResults, accuracy, (SolrParams)customParams);
                    spellingResult = spellChecker.getSuggestions(options);
                } else {
                    spellingResult = new SpellingResult();
                }
                boolean isCorrectlySpelled = hits > (long)(maxResultsForSuggest == null ? 0 : maxResultsForSuggest);
                SimpleOrderedMap response = new SimpleOrderedMap();
                NamedList suggestions = this.toNamedList(shardRequest, spellingResult, q, extendedResults);
                response.add("suggestions", (Object)suggestions);
                if (extendedResults) {
                    response.add("correctlySpelled", (Object)isCorrectlySpelled);
                }
                if (collate) {
                    this.addCollationsToResponse(params, spellingResult, rb, q, (NamedList)response, spellChecker.isSuggestionsMayOverlap());
                }
                if (shardRequest) {
                    this.addOriginalTermsToResponse((NamedList)response, tokens);
                }
                rb.rsp.add(COMPONENT_NAME, response);
            }
        } else {
            throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "Specified dictionaries do not exist: " + this.getDictionaryNameAsSingleString(this.getDictionaryNames(params)));
        }
    }

    private Integer maxResultsForSuggest(ResponseBuilder rb) {
        SolrParams params = rb.req.getParams();
        float maxResultsForSuggestParamValue = params.getFloat("spellcheck.maxResultsForSuggest", 0.0f);
        Integer maxResultsForSuggest = null;
        if (maxResultsForSuggestParamValue > 0.0f) {
            if (maxResultsForSuggestParamValue == (float)((int)maxResultsForSuggestParamValue)) {
                maxResultsForSuggest = (int)maxResultsForSuggestParamValue;
            } else {
                String maxResultsFilterQueryString = params.get("spellcheck.maxResultsForSuggest.fq");
                int maxResultsByFilters = Integer.MAX_VALUE;
                SolrIndexSearcher searcher = rb.req.getSearcher();
                try {
                    if (maxResultsFilterQueryString != null) {
                        QParser parser = QParser.getParser(maxResultsFilterQueryString, rb.req);
                        DocSet s = searcher.getDocSet(parser.getQuery());
                        maxResultsByFilters = s.size();
                    } else {
                        List<Query> filters = rb.getFilters();
                        if (filters != null) {
                            for (Query query : filters) {
                                DocSet s = searcher.getDocSet(query);
                                if (s == null) continue;
                                maxResultsByFilters = Math.min(s.size(), maxResultsByFilters);
                            }
                        }
                    }
                }
                catch (IOException e) {
                    log.error("Error", (Throwable)e);
                    return null;
                }
                catch (SyntaxError e) {
                    log.error("Error", (Throwable)e);
                    return null;
                }
                if (maxResultsByFilters != Integer.MAX_VALUE) {
                    maxResultsForSuggest = Math.round((float)maxResultsByFilters * maxResultsForSuggestParamValue);
                }
            }
        }
        return maxResultsForSuggest;
    }

    protected void addCollationsToResponse(SolrParams params, SpellingResult spellingResult, ResponseBuilder rb, String q, NamedList response, boolean suggestionsMayOverlap) {
        int maxCollations = params.getInt("spellcheck.maxCollations", 1);
        int maxCollationTries = params.getInt("spellcheck.maxCollationTries", 0);
        int maxCollationEvaluations = params.getInt("spellcheck.maxCollationEvaluations", 10000);
        boolean collationExtendedResults = params.getBool("spellcheck.collateExtendedResults", false);
        int maxCollationCollectDocs = params.getInt("spellcheck.collateMaxCollectDocs", 0);
        if (!collationExtendedResults) {
            maxCollationCollectDocs = 1;
        }
        boolean shard = params.getBool("isShard", false);
        SpellCheckCollator collator = new SpellCheckCollator().setMaxCollations(maxCollations).setMaxCollationTries(maxCollationTries).setMaxCollationEvaluations(maxCollationEvaluations).setSuggestionsMayOverlap(suggestionsMayOverlap).setDocCollectionLimit(maxCollationCollectDocs);
        List<SpellCheckCollation> collations = collator.collate(spellingResult, q, rb);
        Collections.sort(collations);
        NamedList collationList = new NamedList();
        for (SpellCheckCollation collation : collations) {
            if (collationExtendedResults) {
                SimpleOrderedMap extendedResult = new SimpleOrderedMap();
                extendedResult.add("collationQuery", (Object)collation.getCollationQuery());
                extendedResult.add("hits", (Object)collation.getHits());
                extendedResult.add("misspellingsAndCorrections", collation.getMisspellingsAndCorrections());
                if (maxCollationTries > 0 && shard) {
                    extendedResult.add("collationInternalRank", (Object)collation.getInternalRank());
                }
                collationList.add("collation", (Object)extendedResult);
                continue;
            }
            collationList.add("collation", (Object)collation.getCollationQuery());
            if (maxCollationTries <= 0 || !shard) continue;
            collationList.add("collationInternalRank", (Object)collation.getInternalRank());
        }
        response.add("collations", (Object)collationList);
    }

    private void addOriginalTermsToResponse(NamedList response, Collection<Token> originalTerms) {
        ArrayList<String> originalTermStr = new ArrayList<String>();
        for (Token t : originalTerms) {
            originalTermStr.add(t.toString());
        }
        response.add("originalTerms", originalTermStr);
    }

    protected SolrParams getCustomParams(String dictionary, SolrParams params) {
        ModifiableSolrParams result = new ModifiableSolrParams();
        Iterator iter = params.getParameterNamesIterator();
        String prefix = "spellcheck." + dictionary + ".";
        while (iter.hasNext()) {
            String nxt = (String)iter.next();
            if (!nxt.startsWith(prefix)) continue;
            result.add(nxt.substring(prefix.length()), params.getParams(nxt));
        }
        return result;
    }

    @Override
    public void modifyRequest(ResponseBuilder rb, SearchComponent who, ShardRequest sreq) {
        int purpose;
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false)) {
            return;
        }
        int n = purpose = rb.grouping() ? 2048 : 4;
        if ((sreq.purpose & purpose) != 0) {
            int count = sreq.params.getInt("spellcheck.count", 1);
            if (count < 5) {
                count = 5;
            }
            sreq.params.set("spellcheck.count", count);
            sreq.params.set(COMPONENT_NAME, new String[]{"true"});
        } else {
            sreq.params.set(COMPONENT_NAME, new String[]{"false"});
        }
    }

    @Override
    public void finishStage(ResponseBuilder rb) {
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false) || rb.stage != ResponseBuilder.STAGE_GET_FIELDS) {
            return;
        }
        boolean extendedResults = params.getBool("spellcheck.extendedResults", false);
        boolean collate = params.getBool("spellcheck.collate", false);
        boolean collationExtendedResults = params.getBool("spellcheck.collateExtendedResults", false);
        int maxCollationTries = params.getInt("spellcheck.maxCollationTries", 0);
        int maxCollations = params.getInt("spellcheck.maxCollations", 1);
        Integer maxResultsForSuggest = this.maxResultsForSuggest(rb);
        int count = rb.req.getParams().getInt("spellcheck.count", 1);
        int numSug = Math.max(count, 5);
        String origQuery = params.get("spellcheck.q");
        if (origQuery == null && (origQuery = rb.getQueryString()) == null) {
            origQuery = params.get("q");
        }
        long hits = rb.grouping() ? (long)rb.totalHitCount : rb.getNumberDocumentsFound();
        boolean isCorrectlySpelled = hits > (long)(maxResultsForSuggest == null ? 0 : maxResultsForSuggest);
        SpellCheckMergeData mergeData = new SpellCheckMergeData();
        if (maxResultsForSuggest == null || !isCorrectlySpelled) {
            for (ShardRequest sreq : rb.finished) {
                for (ShardResponse srsp : sreq.responses) {
                    NamedList nl = null;
                    try {
                        nl = (NamedList)srsp.getSolrResponse().getResponse().get(COMPONENT_NAME);
                    }
                    catch (Exception e) {
                        if (ShardParams.getShardsTolerantAsBool((SolrParams)rb.req.getParams())) continue;
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to read spelling info for shard: " + srsp.getShard(), (Throwable)e);
                    }
                    if (log.isInfoEnabled()) {
                        log.info("{} {}", (Object)srsp.getShard(), (Object)nl);
                    }
                    if (nl == null) continue;
                    ++mergeData.totalNumberShardResponses;
                    this.collectShardSuggestions(nl, mergeData);
                    this.collectShardCollations(mergeData, nl, maxCollationTries);
                }
            }
        }
        SolrSpellChecker checker = this.getSpellChecker(rb.req.getParams());
        SpellingResult result = checker.mergeSuggestions(mergeData, numSug, count, extendedResults);
        SimpleOrderedMap response = new SimpleOrderedMap();
        NamedList suggestions = this.toNamedList(false, result, origQuery, extendedResults);
        response.add("suggestions", (Object)suggestions);
        if (extendedResults) {
            response.add("correctlySpelled", (Object)isCorrectlySpelled);
        }
        if (collate) {
            Object[] sortedCollations = mergeData.collations.values().toArray(new SpellCheckCollation[mergeData.collations.size()]);
            Arrays.sort(sortedCollations);
            NamedList collations = new NamedList();
            for (int i = 0; i < maxCollations && i < sortedCollations.length; ++i) {
                Object collation = sortedCollations[i];
                if (collationExtendedResults) {
                    SimpleOrderedMap extendedResult = new SimpleOrderedMap();
                    extendedResult.add("collationQuery", (Object)((SpellCheckCollation)collation).getCollationQuery());
                    extendedResult.add("hits", (Object)((SpellCheckCollation)collation).getHits());
                    extendedResult.add("misspellingsAndCorrections", ((SpellCheckCollation)collation).getMisspellingsAndCorrections());
                    collations.add("collation", (Object)extendedResult);
                    continue;
                }
                collations.add("collation", (Object)((SpellCheckCollation)collation).getCollationQuery());
            }
            response.add("collations", (Object)collations);
        }
        rb.rsp.add(COMPONENT_NAME, response);
    }

    private void collectShardSuggestions(NamedList nl, SpellCheckMergeData mergeData) {
        SpellCheckResponse spellCheckResp = new SpellCheckResponse(nl);
        Iterable originalTermStrings = (Iterable)nl.get("originalTerms");
        if (originalTermStrings != null) {
            mergeData.originalTerms = new HashSet<String>();
            for (Object originalTermObj : originalTermStrings) {
                mergeData.originalTerms.add(originalTermObj.toString());
            }
        }
        for (SpellCheckResponse.Suggestion suggestion : spellCheckResp.getSuggestions()) {
            mergeData.origVsSuggestion.put(suggestion.getToken(), suggestion);
            HashSet<String> suggested = mergeData.origVsSuggested.get(suggestion.getToken());
            if (suggested == null) {
                suggested = new HashSet();
                mergeData.origVsSuggested.put(suggestion.getToken(), suggested);
            }
            int origFreq = 0;
            Integer o = mergeData.origVsFreq.get(suggestion.getToken());
            if (o != null) {
                origFreq += o.intValue();
            }
            mergeData.origVsFreq.put(suggestion.getToken(), origFreq += suggestion.getOriginalFrequency());
            Integer origShards = mergeData.origVsShards.get(suggestion.getToken());
            if (origShards == null) {
                mergeData.origVsShards.put(suggestion.getToken(), 1);
            } else {
                origShards = origShards + 1;
                mergeData.origVsShards.put(suggestion.getToken(), origShards);
            }
            for (int i = 0; i < suggestion.getNumFound(); ++i) {
                Integer freq;
                String alternative = (String)suggestion.getAlternatives().get(i);
                suggested.add(alternative);
                SuggestWord sug = mergeData.suggestedVsWord.get(alternative);
                if (sug == null) {
                    sug = new SuggestWord();
                    mergeData.suggestedVsWord.put(alternative, sug);
                }
                sug.string = alternative;
                if (suggestion.getAlternativeFrequencies() == null || suggestion.getAlternativeFrequencies().size() <= 0 || (freq = (Integer)suggestion.getAlternativeFrequencies().get(i)) == null) continue;
                sug.freq += freq.intValue();
            }
        }
    }

    private void collectShardCollations(SpellCheckMergeData mergeData, NamedList spellCheckResponse, int maxCollationTries) {
        Map<String, SpellCheckCollation> collations = mergeData.collations;
        NamedList collationHolder = (NamedList)spellCheckResponse.get("collations");
        if (collationHolder != null) {
            List collationList = collationHolder.getAll("collation");
            List collationRankList = collationHolder.getAll("collationInternalRank");
            int i = 0;
            if (collationList != null) {
                for (Object o : collationList) {
                    if (o instanceof String) {
                        SpellCheckCollation priorColl;
                        SpellCheckCollation coll = new SpellCheckCollation();
                        coll.setCollationQuery((String)o);
                        if (collationRankList != null && collationRankList.size() > 0) {
                            coll.setInternalRank((Integer)collationRankList.get(i));
                            ++i;
                        }
                        if ((priorColl = collations.get(coll.getCollationQuery())) != null) {
                            coll.setInternalRank(Math.max(coll.getInternalRank(), priorColl.getInternalRank()));
                        }
                        collations.put(coll.getCollationQuery(), coll);
                        continue;
                    }
                    NamedList expandedCollation = (NamedList)o;
                    SpellCheckCollation coll = new SpellCheckCollation();
                    coll.setCollationQuery((String)expandedCollation.get("collationQuery"));
                    coll.setHits(((Number)expandedCollation.get("hits")).longValue());
                    if (maxCollationTries > 0) {
                        coll.setInternalRank((Integer)expandedCollation.get("collationInternalRank"));
                    }
                    coll.setMisspellingsAndCorrections((NamedList<String>)((NamedList)expandedCollation.get("misspellingsAndCorrections")));
                    SpellCheckCollation priorColl = collations.get(coll.getCollationQuery());
                    if (priorColl != null) {
                        coll.setHits(coll.getHits() + priorColl.getHits());
                        coll.setInternalRank(Math.max(coll.getInternalRank(), priorColl.getInternalRank()));
                    }
                    collations.put(coll.getCollationQuery(), coll);
                }
            }
        }
    }

    private Collection<Token> getTokens(String q, Analyzer analyzer) throws IOException {
        ArrayList<Token> result = new ArrayList<Token>();
        assert (analyzer != null);
        try (TokenStream ts = analyzer.tokenStream("", q);){
            ts.reset();
            CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
            OffsetAttribute offsetAtt = (OffsetAttribute)ts.addAttribute(OffsetAttribute.class);
            TypeAttribute typeAtt = (TypeAttribute)ts.addAttribute(TypeAttribute.class);
            FlagsAttribute flagsAtt = (FlagsAttribute)ts.addAttribute(FlagsAttribute.class);
            PayloadAttribute payloadAtt = (PayloadAttribute)ts.addAttribute(PayloadAttribute.class);
            PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)ts.addAttribute(PositionIncrementAttribute.class);
            while (ts.incrementToken()) {
                Token token = new Token();
                token.copyBuffer(termAtt.buffer(), 0, termAtt.length());
                token.setOffset(offsetAtt.startOffset(), offsetAtt.endOffset());
                token.setType(typeAtt.type());
                token.setFlags(flagsAtt.getFlags());
                token.setPayload(payloadAtt.getPayload());
                token.setPositionIncrement(posIncAtt.getPositionIncrement());
                result.add(token);
            }
            ts.end();
            ArrayList<Token> arrayList = result;
            return arrayList;
        }
    }

    protected SolrSpellChecker getSpellChecker(SolrParams params) {
        String[] dictName = this.getDictionaryNames(params);
        if (dictName.length == 1) {
            return this.spellCheckers.get(dictName[0]);
        }
        String singleStr = this.getDictionaryNameAsSingleString(dictName);
        SolrSpellChecker ssc = this.spellCheckers.get(singleStr);
        if (ssc == null) {
            ConjunctionSolrSpellChecker cssc = new ConjunctionSolrSpellChecker();
            for (String dn : dictName) {
                cssc.addChecker(this.spellCheckers.get(dn));
            }
            ssc = cssc;
        }
        return ssc;
    }

    private String getDictionaryNameAsSingleString(String[] dictName) {
        StringBuilder sb = new StringBuilder();
        for (String dn : dictName) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(dn);
        }
        return sb.toString();
    }

    private String[] getDictionaryNames(SolrParams params) {
        String[] dictName = params.getParams("spellcheck.dictionary");
        if (dictName == null) {
            return new String[]{"default"};
        }
        return dictName;
    }

    public SolrSpellChecker getSpellChecker(String name) {
        return this.spellCheckers.get(name);
    }

    protected NamedList toNamedList(boolean shardRequest, SpellingResult spellingResult, String origQuery, boolean extendedResults) {
        NamedList result = new NamedList();
        Map<Token, LinkedHashMap<String, Integer>> suggestions = spellingResult.getSuggestions();
        boolean hasFreqInfo = spellingResult.hasTokenFrequencyInfo();
        boolean hasSuggestions = false;
        boolean hasZeroFrequencyToken = false;
        for (Map.Entry<Token, LinkedHashMap<String, Integer>> entry : suggestions.entrySet()) {
            Integer tokenFrequency;
            Token inputToken = entry.getKey();
            String tokenString = new String(inputToken.buffer(), 0, inputToken.length());
            LinkedHashMap theSuggestions = new LinkedHashMap(entry.getValue());
            Iterator sugIter = theSuggestions.keySet().iterator();
            while (sugIter.hasNext()) {
                String sug = (String)sugIter.next();
                if (!sug.equals(tokenString)) continue;
                sugIter.remove();
            }
            if (theSuggestions.size() > 0) {
                hasSuggestions = true;
            }
            if (theSuggestions == null || theSuggestions.size() <= 0 && !shardRequest) continue;
            SimpleOrderedMap suggestionList = new SimpleOrderedMap();
            suggestionList.add("numFound", (Object)theSuggestions.size());
            suggestionList.add("startOffset", (Object)inputToken.startOffset());
            suggestionList.add("endOffset", (Object)inputToken.endOffset());
            if (extendedResults && hasFreqInfo) {
                suggestionList.add("origFreq", (Object)spellingResult.getTokenFrequency(inputToken));
                ArrayList<SimpleOrderedMap> sugs = new ArrayList<SimpleOrderedMap>();
                suggestionList.add("suggestion", sugs);
                for (Map.Entry suggEntry : theSuggestions.entrySet()) {
                    SimpleOrderedMap sugEntry = new SimpleOrderedMap();
                    sugEntry.add("word", suggEntry.getKey());
                    sugEntry.add("freq", suggEntry.getValue());
                    sugs.add(sugEntry);
                }
            } else {
                suggestionList.add("suggestion", theSuggestions.keySet());
            }
            if (hasFreqInfo && ((tokenFrequency = spellingResult.getTokenFrequency(inputToken)) == null || tokenFrequency == 0)) {
                hasZeroFrequencyToken = true;
            }
            result.add(tokenString, (Object)suggestionList);
        }
        return result;
    }

    @Override
    public void inform(SolrCore core) {
        if (this.initParams != null) {
            log.info("Initializing spell checkers");
            boolean hasDefault = false;
            for (int i = 0; i < this.initParams.size(); ++i) {
                if (!this.initParams.getName(i).equals("spellchecker")) continue;
                Object cfg = this.initParams.getVal(i);
                if (cfg instanceof NamedList) {
                    this.addSpellChecker(core, hasDefault, (NamedList)cfg);
                    continue;
                }
                if (cfg instanceof Map) {
                    this.addSpellChecker(core, hasDefault, new NamedList((Map)cfg));
                    continue;
                }
                if (!(cfg instanceof List)) continue;
                for (Object o : (List)cfg) {
                    if (!(o instanceof Map)) continue;
                    this.addSpellChecker(core, hasDefault, new NamedList((Map)o));
                }
            }
            HashMap<String, SpellingQueryConverter> queryConverters = new HashMap<String, SpellingQueryConverter>();
            core.initPlugins(queryConverters, QueryConverter.class);
            if (queryConverters.size() == 0) {
                log.trace("No queryConverter defined, using default converter");
                queryConverters.put("queryConverter", new SpellingQueryConverter());
            }
            if (queryConverters.size() == 1) {
                this.queryConverter = (QueryConverter)queryConverters.values().iterator().next();
                IndexSchema schema = core.getLatestSchema();
                String fieldTypeName = (String)this.initParams.get("queryAnalyzerFieldType");
                FieldType fieldType = schema.getFieldTypes().get(fieldTypeName);
                WhitespaceAnalyzer analyzer = fieldType == null ? new WhitespaceAnalyzer() : fieldType.getQueryAnalyzer();
                this.queryConverter.setAnalyzer((Analyzer)analyzer);
            }
        }
    }

    private boolean addSpellChecker(SolrCore core, boolean hasDefault, NamedList spellchecker) {
        SolrResourceLoader loader;
        SolrSpellChecker checker;
        String className = (String)spellchecker.get("classname");
        if (className == null) {
            className = (String)spellchecker.get("class");
        }
        if (className == null) {
            className = IndexBasedSpellChecker.class.getName();
        }
        if ((checker = (loader = core.getResourceLoader()).newInstance(className, SolrSpellChecker.class)) != null) {
            String dictionary = checker.init(spellchecker, core);
            if (dictionary != null) {
                boolean isDefault = dictionary.equals("default");
                if (isDefault && !hasDefault) {
                    hasDefault = true;
                } else if (isDefault && hasDefault) {
                    throw new RuntimeException("More than one dictionary is missing name.");
                }
                this.spellCheckers.put(dictionary, checker);
            } else if (!hasDefault) {
                this.spellCheckers.put("default", checker);
                hasDefault = true;
            } else {
                throw new RuntimeException("More than one dictionary is missing name.");
            }
            core.registerFirstSearcherListener(new SpellCheckerListener(core, checker, false, false));
            boolean buildOnCommit = Boolean.parseBoolean((String)spellchecker.get("buildOnCommit"));
            boolean buildOnOptimize = Boolean.parseBoolean((String)spellchecker.get("buildOnOptimize"));
            if (buildOnCommit || buildOnOptimize) {
                if (log.isInfoEnabled()) {
                    log.info("Registering newSearcher listener for spellchecker: {}", (Object)checker.getDictionaryName());
                }
                core.registerNewSearcherListener(new SpellCheckerListener(core, checker, buildOnCommit, buildOnOptimize));
            }
        } else {
            throw new RuntimeException("Can't load spell checker: " + className);
        }
        return hasDefault;
    }

    public Map<String, SolrSpellChecker> getSpellCheckers() {
        return Collections.unmodifiableMap(this.spellCheckers);
    }

    @Override
    public String getDescription() {
        return "A Spell Checker component";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.SPELLCHECKER;
    }

    private static class SpellCheckerListener
    implements SolrEventListener {
        private final SolrCore core;
        private final SolrSpellChecker checker;
        private final boolean buildOnCommit;
        private final boolean buildOnOptimize;

        public SpellCheckerListener(SolrCore core, SolrSpellChecker checker, boolean buildOnCommit, boolean buildOnOptimize) {
            this.core = core;
            this.checker = checker;
            this.buildOnCommit = buildOnCommit;
            this.buildOnOptimize = buildOnOptimize;
        }

        @Override
        public void init(NamedList args) {
        }

        @Override
        public void newSearcher(SolrIndexSearcher newSearcher, SolrIndexSearcher currentSearcher) {
            if (currentSearcher == null) {
                try {
                    if (log.isInfoEnabled()) {
                        log.info("Loading spell index for spellchecker: {}", (Object)this.checker.getDictionaryName());
                    }
                    this.checker.reload(this.core, newSearcher);
                }
                catch (IOException e) {
                    log.error("Exception in reloading spell check index for spellchecker: {}", (Object)this.checker.getDictionaryName(), (Object)e);
                }
            } else if (this.buildOnCommit) {
                this.buildSpellIndex(newSearcher);
            } else if (this.buildOnOptimize) {
                if (newSearcher.getIndexReader().leaves().size() == 1) {
                    this.buildSpellIndex(newSearcher);
                } else if (log.isInfoEnabled()) {
                    log.info("Index is not optimized therefore skipping building spell check index for: {}", (Object)this.checker.getDictionaryName());
                }
            }
        }

        private void buildSpellIndex(SolrIndexSearcher newSearcher) {
            try {
                if (log.isInfoEnabled()) {
                    log.info("Building spell index for spell checker: {}", (Object)this.checker.getDictionaryName());
                }
                this.checker.build(this.core, newSearcher);
            }
            catch (Exception e) {
                log.error("Exception in building spell check index for spellchecker: {}", (Object)this.checker.getDictionaryName(), (Object)e);
            }
        }

        @Override
        public void postCommit() {
        }

        @Override
        public void postSoftCommit() {
        }
    }
}

