/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.reduction;

import java.util.function.UnaryOperator;
import org.apache.solr.analytics.function.ReductionFunction;
import org.apache.solr.analytics.function.reduction.PercentileFunction;
import org.apache.solr.analytics.function.reduction.data.ReductionDataCollector;
import org.apache.solr.analytics.function.reduction.data.SortedListCollector;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.StringValueStream;

class StringPercentileFunction
extends StringValue.AbstractStringValue
implements ReductionFunction {
    private SortedListCollector.SortedStringListCollector collector;
    private double percentile;
    public static final String name = "percentile";
    private final String exprStr;

    public StringPercentileFunction(StringValueStream param, double percentile) {
        this.collector = new SortedListCollector.SortedStringListCollector(param);
        this.percentile = percentile;
        this.exprStr = PercentileFunction.createPercentileExpressionString(param, percentile);
    }

    @Override
    public String getString() {
        int size = this.collector.size();
        return size > 0 ? (String)this.collector.get((int)Math.round(this.percentile * (double)size - 0.5)) : null;
    }

    @Override
    public boolean exists() {
        return this.collector.size() > 0;
    }

    @Override
    public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
        this.collector = (SortedListCollector.SortedStringListCollector)sync.apply(this.collector);
        this.collector.calcPercentile(this.percentile);
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return AnalyticsValueStream.ExpressionType.REDUCTION;
    }
}

