/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc.authentication;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Arrays;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.derby.authentication.UserAuthenticator;
import org.apache.derby.catalog.SystemProcedures;
import org.apache.derby.iapi.error.SQLWarningFactory;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PasswordHasher;
import org.apache.derby.iapi.sql.dictionary.UserDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.impl.jdbc.authentication.AuthenticationServiceBase;
import org.apache.derby.jdbc.InternalDriver;

public final class NativeAuthenticationServiceImpl
extends AuthenticationServiceBase
implements UserAuthenticator {
    private boolean _creatingCredentialsDB = false;
    private String _credentialsDB;
    private boolean _authenticateDatabaseOperationsLocally;
    private long _passwordLifetimeMillis = 2678400000L;
    private double _passwordExpirationThreshold = 0.125;
    private String _badlyFormattedPasswordProperty;

    public boolean canSupport(Properties properties) {
        if (!this.requireAuthentication(properties)) {
            return false;
        }
        if (PropertyUtil.nativeAuthenticationEnabled(properties)) {
            this.parseNativeSpecification(properties);
            return true;
        }
        return false;
    }

    private void parseNativeSpecification(Properties properties) {
        Object object;
        int n;
        String string = PropertyUtil.getPropertyFromSet(properties, "derby.authentication.provider");
        this._authenticateDatabaseOperationsLocally = PropertyUtil.localNativeAuthenticationEnabled(properties);
        int n2 = string.indexOf(":") + 1;
        int n3 = n = this._authenticateDatabaseOperationsLocally ? string.lastIndexOf(":") : string.length();
        if (n > n2) {
            this._credentialsDB = string.substring(n2, n);
            if (this._credentialsDB.length() == 0) {
                this._credentialsDB = null;
            }
        }
        this._badlyFormattedPasswordProperty = null;
        String string2 = PropertyUtil.getPropertyFromSet(properties, "derby.authentication.native.passwordLifetimeMillis");
        if (string2 != null) {
            object = this.parsePasswordLifetime(string2);
            if (object != null) {
                this._passwordLifetimeMillis = (Long)object;
            } else {
                this._badlyFormattedPasswordProperty = "derby.authentication.native.passwordLifetimeMillis";
            }
        }
        if ((object = PropertyUtil.getPropertyFromSet(properties, "derby.authentication.native.passwordLifetimeThreshold")) != null) {
            Double d = this.parsePasswordThreshold((String)object);
            if (d != null) {
                this._passwordExpirationThreshold = d;
            } else {
                this._badlyFormattedPasswordProperty = "derby.authentication.native.passwordLifetimeThreshold";
            }
        }
    }

    private boolean validAuthenticationProvider() throws StandardException {
        boolean bl;
        boolean bl2 = bl = this.getServiceName() == null;
        if (this._credentialsDB != null) {
            if (Monitor.getMonitor().getCanonicalServiceName(this._credentialsDB) == null) {
                throw StandardException.newException("4251L", this._credentialsDB);
            }
            return true;
        }
        if (bl) {
            return false;
        }
        return this._authenticateDatabaseOperationsLocally;
    }

    public void boot(boolean bl, Properties properties) throws StandardException {
        super.boot(bl, properties);
        if (!this.validAuthenticationProvider()) {
            throw StandardException.newException("4251H");
        }
        if (this._badlyFormattedPasswordProperty != null) {
            throw StandardException.newException("4251J", this._badlyFormattedPasswordProperty);
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.reset();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw Monitor.exceptionStartingModule(noSuchAlgorithmException);
        }
        this._creatingCredentialsDB = bl && this.authenticatingInThisService(this.getCanonicalServiceName());
        this.setAuthenticationService(this);
    }

    public String getSystemCredentialsDatabaseName() {
        return this._credentialsDB;
    }

    public boolean authenticateUser(String string, String string2, String string3, Properties properties) throws SQLException {
        try {
            if (string == null) {
                return false;
            }
            if (string2 == null) {
                return false;
            }
            if (string3 == null || !this.authenticatingInThisDatabase(string3)) {
                return this.authenticateRemotely(string, string2, string3);
            }
            return this.authenticateLocally(string, string2, string3);
        }
        catch (StandardException standardException) {
            throw Util.generateCsSQLException(standardException);
        }
    }

    private boolean authenticatingInThisDatabase(String string) throws StandardException {
        return this.authenticatingInThisService(Monitor.getMonitor().getCanonicalServiceName(string));
    }

    private boolean authenticatingInThisService(String string) throws StandardException {
        if (this._authenticateDatabaseOperationsLocally) {
            return true;
        }
        return this.isCredentialsService(string);
    }

    private boolean isCredentialsService(String string) throws StandardException {
        String string2 = this.getCanonicalServiceName(this._credentialsDB);
        String string3 = Monitor.getMonitor().getCanonicalServiceName(string);
        if (string2 == null) {
            return false;
        }
        return string2.equals(string);
    }

    private String getCanonicalServiceName() throws StandardException {
        return this.getCanonicalServiceName(this.getServiceName());
    }

    private String getCanonicalServiceName(String string) throws StandardException {
        return Monitor.getMonitor().getCanonicalServiceName(string);
    }

    private boolean authenticateRemotely(String string, String string2, String string3) throws StandardException, SQLWarning {
        if (this._credentialsDB == null) {
            throw StandardException.newException("4251H");
        }
        SQLWarning sQLWarning = null;
        try {
            Properties properties = new Properties();
            properties.setProperty("user", string);
            properties.setProperty("password", string2);
            String string4 = "jdbc:derby:" + this._credentialsDB;
            Connection connection = InternalDriver.activeDriver().connect(string4, properties, 0);
            sQLWarning = connection.getWarnings();
            connection.close();
        }
        catch (SQLException sQLException) {
            String string5 = sQLException.getSQLState();
            if ("08004".equals(string5)) {
                return false;
            }
            if ("XJ004.C".startsWith(string5)) {
                throw StandardException.newException("4251I", this._credentialsDB);
            }
            throw this.wrap(sQLException);
        }
        if (sQLWarning != null) {
            throw sQLWarning;
        }
        return true;
    }

    private void callDataSourceSetter(DataSource dataSource, String string, String string2) throws StandardException {
        try {
            dataSource.getClass().getMethod(string, String.class).invoke((Object)dataSource, string2);
        }
        catch (Exception exception) {
            throw this.wrap(exception);
        }
    }

    private StandardException wrap(Throwable throwable) {
        return StandardException.plainWrapException(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean authenticateLocally(String string, String string2, String string3) throws StandardException, SQLException {
        string = IdUtil.getUserAuthorizationId(string);
        if (this._creatingCredentialsDB) {
            this._creatingCredentialsDB = false;
            TransactionController transactionController = this.getTransaction();
            SystemProcedures.addUser(string, string2, transactionController);
            transactionController.commit();
            return true;
        }
        DataDictionary dataDictionary = (DataDictionary)Monitor.getServiceModule(this, "org.apache.derby.iapi.sql.dictionary.DataDictionary");
        UserDescriptor userDescriptor = dataDictionary.getUser(string);
        if (userDescriptor == null) {
            PasswordHasher passwordHasher = dataDictionary.makePasswordHasher(this.getDatabaseProperties());
            passwordHasher.hashPasswordIntoString(string, string2).toCharArray();
            return false;
        }
        PasswordHasher passwordHasher = new PasswordHasher(userDescriptor.getHashingScheme());
        char[] cArray = passwordHasher.hashPasswordIntoString(string, string2).toCharArray();
        char[] cArray2 = userDescriptor.getAndZeroPassword();
        try {
            if (cArray == null || cArray2 == null) {
                boolean bl = false;
                return bl;
            }
            if (cArray.length != cArray2.length) {
                boolean bl = false;
                return bl;
            }
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == cArray2[i]) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (cArray != null) {
                Arrays.fill(cArray, '\u0000');
            }
            if (cArray2 != null) {
                Arrays.fill(cArray2, '\u0000');
            }
        }
        if (this._passwordLifetimeMillis > 0L) {
            long l;
            long l2 = System.currentTimeMillis() - userDescriptor.getLastModified().getTime();
            long l3 = this._passwordLifetimeMillis - l2;
            if (l3 <= 0L) {
                if (!dataDictionary.getAuthorizationDatabaseOwner().equals(string)) {
                    return false;
                }
                l3 = 0L;
            }
            if (l3 <= (l = (long)((double)this._passwordLifetimeMillis * this._passwordExpirationThreshold))) {
                if (dataDictionary.getAuthorizationDatabaseOwner().equals(string)) {
                    throw SQLWarningFactory.newSQLWarning("01J16", string3);
                }
                long l4 = l3 / 86400000L;
                throw SQLWarningFactory.newSQLWarning("01J15", Long.toString(l4), string3);
            }
        }
        return true;
    }
}

