/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigDoubleArrayList;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AbstractIndexFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.DoubleValuesComparatorSource;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.DoubleArrayAtomicFieldData;
import org.elasticsearch.index.fielddata.plain.NonEstimatingEstimator;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.indices.fielddata.breaker.CircuitBreakerService;

public class DoubleArrayIndexFieldData
extends AbstractIndexFieldData<DoubleArrayAtomicFieldData>
implements IndexNumericFieldData<DoubleArrayAtomicFieldData> {
    private final CircuitBreakerService breakerService;

    public DoubleArrayIndexFieldData(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache, CircuitBreakerService breakerService) {
        super(index, indexSettings, fieldNames, fieldDataType, cache);
        this.breakerService = breakerService;
    }

    @Override
    public IndexNumericFieldData.NumericType getNumericType() {
        return IndexNumericFieldData.NumericType.DOUBLE;
    }

    @Override
    public boolean valuesOrdered() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DoubleArrayAtomicFieldData loadDirect(AtomicReaderContext context) throws Exception {
        AtomicReader reader = context.reader();
        Terms terms = reader.terms(this.getFieldNames().indexName());
        DoubleArrayAtomicFieldData data = null;
        NonEstimatingEstimator estimator = new NonEstimatingEstimator(this.breakerService.getBreaker());
        if (terms == null) {
            data = DoubleArrayAtomicFieldData.empty(reader.maxDoc());
            estimator.afterLoad(null, data.getMemorySizeInBytes());
            return data;
        }
        BigDoubleArrayList values = new BigDoubleArrayList();
        values.add(0.0);
        float acceptableTransientOverheadRatio = this.fieldDataType.getSettings().getAsFloat("acceptable_transient_overhead_ratio", Float.valueOf(0.5f)).floatValue();
        OrdinalsBuilder builder = new OrdinalsBuilder(reader.maxDoc(), acceptableTransientOverheadRatio);
        boolean success = false;
        try {
            BytesRef term;
            BytesRefIterator iter = builder.buildFromTerms(this.getNumericType().wrapTermsEnum(terms.iterator(null)));
            while ((term = iter.next()) != null) {
                values.add(NumericUtils.sortableLongToDouble((long)NumericUtils.prefixCodedToLong((BytesRef)term)));
            }
            Ordinals build = builder.build(this.fieldDataType.getSettings());
            if (!build.isMultiValued() && IndexFieldData.CommonSettings.removeOrdsOnSingleValue(this.fieldDataType)) {
                long ordinalsSize;
                Ordinals.Docs ordinals = build.ordinals();
                FixedBitSet set = builder.buildDocsWithValuesSet();
                long singleValuesArraySize = (long)(reader.maxDoc() * 8) + (set == null ? 0L : RamUsageEstimator.sizeOf((long[])set.getBits()) + 4L);
                long uniqueValuesArraySize = values.sizeInBytes();
                if (uniqueValuesArraySize + (ordinalsSize = build.getMemorySizeInBytes()) < singleValuesArraySize) {
                    data = new DoubleArrayAtomicFieldData.WithOrdinals(values, reader.maxDoc(), build);
                    success = true;
                    DoubleArrayAtomicFieldData doubleArrayAtomicFieldData = data;
                    return doubleArrayAtomicFieldData;
                }
                int maxDoc = reader.maxDoc();
                BigDoubleArrayList sValues = new BigDoubleArrayList(maxDoc);
                for (int i = 0; i < maxDoc; ++i) {
                    sValues.add(values.get(ordinals.getOrd(i)));
                }
                assert (sValues.size() == (long)maxDoc);
                data = set == null ? new DoubleArrayAtomicFieldData.Single(sValues, maxDoc, ordinals.getNumOrds()) : new DoubleArrayAtomicFieldData.SingleFixedSet(sValues, maxDoc, set, ordinals.getNumOrds());
            } else {
                data = new DoubleArrayAtomicFieldData.WithOrdinals(values, reader.maxDoc(), build);
            }
            success = true;
            DoubleArrayAtomicFieldData doubleArrayAtomicFieldData = data;
            return doubleArrayAtomicFieldData;
        }
        finally {
            if (success) {
                estimator.afterLoad(null, data.getMemorySizeInBytes());
            }
            builder.close();
        }
    }

    @Override
    public IndexFieldData.XFieldComparatorSource comparatorSource(@Nullable Object missingValue, SortMode sortMode) {
        return new DoubleValuesComparatorSource(this, missingValue, sortMode);
    }

    public static class Builder
    implements IndexFieldData.Builder {
        @Override
        public IndexFieldData<?> build(Index index, @IndexSettings Settings indexSettings, FieldMapper<?> mapper, IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new DoubleArrayIndexFieldData(index, indexSettings, mapper.names(), mapper.fieldDataType(), cache, breakerService);
        }
    }
}

