/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.rss;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.CircularRedirectException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.connectorcommon.common.InterruptibleSocketFactory;
import org.apache.manifoldcf.connectorcommon.common.XThreadInputStream;
import org.apache.manifoldcf.connectorcommon.interfaces.BreakException;
import org.apache.manifoldcf.connectorcommon.interfaces.IBreakCheck;
import org.apache.manifoldcf.connectorcommon.interfaces.IConnectionThrottler;
import org.apache.manifoldcf.connectorcommon.interfaces.IFetchThrottler;
import org.apache.manifoldcf.connectorcommon.interfaces.IStreamThrottler;
import org.apache.manifoldcf.connectorcommon.interfaces.IThrottleGroups;
import org.apache.manifoldcf.connectorcommon.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.connectorcommon.interfaces.ThrottleGroupsFactory;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.connectors.rss.IThrottledConnection;
import org.apache.manifoldcf.crawler.interfaces.IAbortActivity;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.system.Logging;

public class ThrottledFetcher {
    public static final String _rcsid = "@(#)$Id: ThrottledFetcher.java 988245 2010-08-23 18:39:35Z kwright $";
    protected static final boolean recordEverything = false;
    protected static final int READ_CHUNK_LENGTH = 4096;
    protected static int globalHandleCount = 0;
    protected static Integer globalHandleCounterLock = new Integer(0);
    protected final Map<String, IConnectionThrottler> serverMap = new HashMap<String, IConnectionThrottler>();
    protected int refCount = 0;
    private static String currentHost = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void registerGlobalHandle(int maxHandles) throws ManifoldCFException {
        try {
            Integer n = globalHandleCounterLock;
            synchronized (n) {
                while (globalHandleCount >= maxHandles) {
                    globalHandleCounterLock.wait();
                }
                ++globalHandleCount;
            }
        }
        catch (InterruptedException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void releaseGlobalHandle() {
        Integer n = globalHandleCounterLock;
        synchronized (n) {
            --globalHandleCount;
            globalHandleCounterLock.notifyAll();
        }
    }

    public synchronized IThrottledConnection createConnection(IThreadContext threadContext, String throttleGroupName, String serverName, int connectionLimit, int connectionTimeoutMilliseconds, String proxyHost, int proxyPort, String proxyAuthDomain, String proxyAuthUsername, String proxyAuthPassword, IAbortActivity activities) throws ManifoldCFException, ServiceInterruption {
        IConnectionThrottler server = this.serverMap.get(serverName);
        if (server == null) {
            IThrottleGroups tg = ThrottleGroupsFactory.make((IThreadContext)threadContext);
            server = tg.obtainConnectionThrottler("_RSS_", throttleGroupName, new String[]{serverName});
            this.serverMap.put(serverName, server);
        }
        return new ThrottledConnection(serverName, server, connectionTimeoutMilliseconds, connectionLimit, proxyHost, proxyPort, proxyAuthDomain, proxyAuthUsername, proxyAuthPassword, activities);
    }

    public synchronized void poll() throws ManifoldCFException {
    }

    public synchronized void noteConnectionEstablished() {
        ++this.refCount;
    }

    public synchronized void noteConnectionReleased() {
        --this.refCount;
        if (this.refCount == 0) {
            this.serverMap.clear();
        }
    }

    static {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            currentHost = addr.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    protected static class AbortChecker
    implements IBreakCheck {
        protected final IAbortActivity activities;
        protected ServiceInterruption serviceInterruption = null;
        protected ManifoldCFException mcfException = null;

        public AbortChecker(IAbortActivity activities) {
            this.activities = activities;
        }

        public long abortCheck() throws BreakException, InterruptedException {
            try {
                this.activities.checkJobStillActive();
                return 1000L;
            }
            catch (ServiceInterruption e) {
                this.serviceInterruption = e;
                throw new BreakException("Break requested: " + e.getMessage(), (Throwable)e);
            }
            catch (ManifoldCFException e) {
                if (e.getErrorCode() == 2) {
                    throw new InterruptedException("Interrupted: " + e.getMessage());
                }
                this.mcfException = e;
                throw new BreakException("Error during break check: " + e.getMessage(), (Throwable)e);
            }
        }

        public void rethrowExceptions() throws ManifoldCFException, ServiceInterruption {
            if (this.serviceInterruption != null) {
                throw this.serviceInterruption;
            }
            if (this.mcfException != null) {
                throw this.mcfException;
            }
        }
    }

    protected static class ExecuteMethodThread
    extends Thread {
        protected final ThrottledConnection theConnection;
        protected final IFetchThrottler fetchThrottler;
        protected final HttpClient httpClient;
        protected final HttpRequestBase executeMethod;
        protected HttpResponse response = null;
        protected Throwable responseException = null;
        protected XThreadInputStream threadStream = null;
        protected InputStream bodyStream = null;
        protected boolean streamCreated = false;
        protected Throwable streamException = null;
        protected boolean abortThread = false;
        protected Throwable shutdownException = null;
        protected Throwable generalException = null;

        public ExecuteMethodThread(ThrottledConnection theConnection, IFetchThrottler fetchThrottler, HttpClient httpClient, HttpRequestBase executeMethod) {
            this.setDaemon(true);
            this.theConnection = theConnection;
            this.fetchThrottler = fetchThrottler;
            this.httpClient = httpClient;
            this.executeMethod = executeMethod;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ExecuteMethodThread executeMethodThread;
                try {
                    executeMethodThread = this;
                    synchronized (executeMethodThread) {
                        if (!this.abortThread) {
                            try {
                                this.response = this.httpClient.execute((HttpUriRequest)this.executeMethod);
                            }
                            catch (SocketTimeoutException e) {
                                this.responseException = e;
                            }
                            catch (ConnectTimeoutException e) {
                                this.responseException = e;
                            }
                            catch (InterruptedIOException e) {
                                throw e;
                            }
                            catch (Throwable e) {
                                this.responseException = e;
                            }
                            this.notifyAll();
                        }
                    }
                    if (this.responseException == null) {
                        executeMethodThread = this;
                        synchronized (executeMethodThread) {
                            if (!this.abortThread) {
                                try {
                                    this.bodyStream = this.response.getEntity().getContent();
                                    if (this.bodyStream != null) {
                                        this.bodyStream = new ThrottledInputstream(this.theConnection, this.fetchThrottler.createFetchStream(), this.bodyStream);
                                        this.threadStream = new XThreadInputStream(this.bodyStream);
                                    }
                                    this.streamCreated = true;
                                }
                                catch (SocketTimeoutException e) {
                                    this.streamException = e;
                                }
                                catch (ConnectTimeoutException e) {
                                    this.streamException = e;
                                }
                                catch (InterruptedIOException e) {
                                    throw e;
                                }
                                catch (Throwable e) {
                                    this.streamException = e;
                                }
                                this.notifyAll();
                            }
                        }
                    }
                    if (this.responseException == null && this.streamException == null && this.threadStream != null) {
                        this.threadStream.stuffQueue();
                    }
                }
                finally {
                    if (this.bodyStream != null) {
                        try {
                            this.bodyStream.close();
                        }
                        catch (IOException iOException) {}
                        this.bodyStream = null;
                    }
                    executeMethodThread = this;
                    synchronized (executeMethodThread) {
                        try {
                            this.executeMethod.abort();
                        }
                        catch (Throwable e) {
                            this.shutdownException = e;
                        }
                        this.notifyAll();
                    }
                }
            }
            catch (Throwable e) {
                this.generalException = e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getResponseCode() throws InterruptedException, IOException, HttpException {
            while (true) {
                ExecuteMethodThread executeMethodThread = this;
                synchronized (executeMethodThread) {
                    this.checkException(this.responseException);
                    if (this.response != null) {
                        return this.response.getStatusLine().getStatusCode();
                    }
                    this.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getFirstHeader(String headerName) throws InterruptedException, IOException, HttpException {
            while (true) {
                ExecuteMethodThread executeMethodThread = this;
                synchronized (executeMethodThread) {
                    this.checkException(this.responseException);
                    if (this.response != null) {
                        Header h = this.response.getFirstHeader(headerName);
                        if (h == null) {
                            return null;
                        }
                        return h.getValue();
                    }
                    this.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream getSafeInputStream() throws InterruptedException, IOException, HttpException {
            while (true) {
                ExecuteMethodThread executeMethodThread = this;
                synchronized (executeMethodThread) {
                    if (this.responseException != null) {
                        throw new IllegalStateException("Check for response before getting stream");
                    }
                    this.checkException(this.streamException);
                    if (this.streamCreated) {
                        return this.threadStream;
                    }
                    this.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void abort() {
            ExecuteMethodThread executeMethodThread = this;
            synchronized (executeMethodThread) {
                if (this.streamCreated && this.threadStream != null) {
                    this.threadStream.abort();
                }
                this.abortThread = true;
            }
        }

        public void finishUp() throws InterruptedException {
            this.join();
        }

        protected synchronized void checkException(Throwable exception) throws IOException, HttpException {
            if (exception != null) {
                Throwable e = exception;
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof HttpException) {
                    throw (HttpException)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                throw new RuntimeException("Unhandled exception of type: " + e.getClass().getName(), e);
            }
        }
    }

    protected static class ThrottledInputstream
    extends InputStream {
        protected final ThrottledConnection throttledConnection;
        protected final IStreamThrottler streamThrottler;
        protected final InputStream inputStream;

        public ThrottledInputstream(ThrottledConnection throttledConnection, IStreamThrottler streamThrottler, InputStream is) {
            this.throttledConnection = throttledConnection;
            this.streamThrottler = streamThrottler;
            this.inputStream = is;
        }

        @Override
        public int read() throws IOException {
            byte[] byteArray = new byte[1];
            int count = this.read(byteArray, 0, 1);
            if (count == -1) {
                return count;
            }
            return byteArray[0];
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int amt;
            int totalCount = 0;
            while (len > 4096) {
                amt = this.basicRead(b, off, 4096, totalCount);
                if (amt == -1) {
                    if (totalCount == 0) {
                        return amt;
                    }
                    return totalCount;
                }
                totalCount += amt;
                off += amt;
                len -= amt;
            }
            if (len > 0) {
                amt = this.basicRead(b, off, len, totalCount);
                if (amt == -1) {
                    if (totalCount == 0) {
                        return amt;
                    }
                    return totalCount;
                }
                return totalCount + amt;
            }
            return totalCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int basicRead(byte[] b, int off, int len, int totalSoFar) throws IOException {
            int n;
            block9: {
                int amt;
                block8: {
                    if (!this.streamThrottler.obtainReadPermission(len)) {
                        throw new IllegalStateException("Throttler shut down while still active");
                    }
                    amt = 0;
                    try {
                        n = amt = this.inputStream.read(b, off, len);
                        if (amt != -1) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (amt == -1) {
                                this.streamThrottler.releaseReadPermission(len, 0);
                            } else {
                                this.streamThrottler.releaseReadPermission(len, amt);
                                this.throttledConnection.logFetchCount(amt);
                            }
                            throw throwable;
                        }
                        catch (InterruptedException e) {
                            InterruptedIOException e2 = new InterruptedIOException("Interrupted");
                            e2.bytesTransferred = totalSoFar;
                            throw e2;
                        }
                    }
                    this.streamThrottler.releaseReadPermission(len, 0);
                    break block9;
                }
                this.streamThrottler.releaseReadPermission(len, amt);
                this.throttledConnection.logFetchCount(amt);
            }
            return n;
        }

        @Override
        public long skip(long n) throws IOException {
            return this.inputStream.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.inputStream.available();
        }

        @Override
        public void mark(int readLimit) {
            this.inputStream.mark(readLimit);
        }

        @Override
        public void reset() throws IOException {
            this.inputStream.reset();
        }

        @Override
        public boolean markSupported() {
            return this.inputStream.markSupported();
        }

        @Override
        public void close() throws IOException {
            try {
                this.inputStream.close();
            }
            finally {
                this.streamThrottler.closeStream();
            }
        }
    }

    protected static class ThrottledConnection
    implements IThrottledConnection {
        protected final String serverName;
        protected final IConnectionThrottler connectionThrottler;
        protected final IFetchThrottler fetchThrottler;
        protected final int connectionTimeoutMilliseconds;
        protected final HttpClientConnectionManager connectionManager;
        protected final HttpClient httpClient;
        protected HttpRequestBase executeMethod = null;
        protected long startFetchTime = -1L;
        protected Throwable throwable = null;
        protected String myUrl = null;
        protected int statusCode = -1;
        protected String fetchType = null;
        protected long fetchCounter = 0L;
        protected ExecuteMethodThread methodThread = null;
        protected boolean threadStarted = false;
        protected final AbortChecker abortChecker;

        public ThrottledConnection(String serverName, IConnectionThrottler connectionThrottler, int connectionTimeoutMilliseconds, int connectionLimit, String proxyHost, int proxyPort, String proxyAuthDomain, String proxyAuthUsername, String proxyAuthPassword, IAbortActivity activities) throws ManifoldCFException, ServiceInterruption {
            this.serverName = serverName;
            this.connectionThrottler = connectionThrottler;
            this.connectionTimeoutMilliseconds = connectionTimeoutMilliseconds;
            this.abortChecker = new AbortChecker(activities);
            SSLSocketFactory httpsSocketFactory = KeystoreManagerFactory.getTrustingSecureSocketFactory();
            SSLConnectionSocketFactory myFactory = new SSLConnectionSocketFactory((SSLSocketFactory)new InterruptibleSocketFactory(httpsSocketFactory, (long)connectionTimeoutMilliseconds), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            PoolingHttpClientConnectionManager poolingConnectionManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)myFactory).build());
            poolingConnectionManager.setDefaultMaxPerRoute(1);
            poolingConnectionManager.setValidateAfterInactivity(2000);
            poolingConnectionManager.setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).setSoTimeout(connectionTimeoutMilliseconds).build());
            this.connectionManager = poolingConnectionManager;
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            RequestConfig.Builder requestBuilder = RequestConfig.custom().setCircularRedirectsAllowed(true).setSocketTimeout(connectionTimeoutMilliseconds).setExpectContinueEnabled(true).setConnectTimeout(connectionTimeoutMilliseconds).setConnectionRequestTimeout(connectionTimeoutMilliseconds);
            if (proxyHost != null && proxyHost.length() > 0) {
                if (proxyAuthUsername != null && proxyAuthUsername.length() > 0) {
                    if (proxyAuthPassword == null) {
                        proxyAuthPassword = "";
                    }
                    if (proxyAuthDomain == null) {
                        proxyAuthDomain = "";
                    }
                    credentialsProvider.setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new NTCredentials(proxyAuthUsername, proxyAuthPassword, currentHost, proxyAuthDomain));
                }
                HttpHost proxy = new HttpHost(proxyHost, proxyPort);
                requestBuilder.setProxy(proxy);
            }
            this.httpClient = HttpClients.custom().setConnectionManager(this.connectionManager).setMaxConnTotal(1).disableAutomaticRetries().setDefaultRequestConfig(requestBuilder.build()).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setRequestExecutor(new HttpRequestExecutor(connectionTimeoutMilliseconds)).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
            ThrottledFetcher.registerGlobalHandle(connectionLimit);
            try {
                int result = connectionThrottler.waitConnectionAvailable((IBreakCheck)this.abortChecker);
                if (result != 1) {
                    throw new IllegalStateException("Got back unexpected value from waitForAConnection() of " + result);
                }
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException(e.getMessage(), 2);
            }
            catch (BreakException e) {
                this.abortChecker.rethrowExceptions();
            }
            this.fetchThrottler = connectionThrottler.getNewConnectionFetchThrottler();
        }

        @Override
        public void beginFetch(String fetchType) throws ManifoldCFException, ServiceInterruption {
            this.fetchType = fetchType;
            this.fetchCounter = 0L;
            try {
                if (!this.fetchThrottler.obtainFetchDocumentPermission((IBreakCheck)this.abortChecker)) {
                    throw new IllegalStateException("obtainFetchDocumentPermission() had unexpected return value");
                }
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException("Interrupted", 2);
            }
            catch (BreakException e) {
                this.abortChecker.rethrowExceptions();
            }
            this.threadStarted = false;
        }

        public void logFetchCount(int count) {
            this.fetchCounter += (long)count;
        }

        @Override
        public int executeFetch(String protocol, int port, String urlPath, String userAgent, String from, String lastETag, String lastModified) throws ManifoldCFException, ServiceInterruption {
            StringBuilder sb = new StringBuilder(protocol);
            sb.append("://").append(this.serverName);
            if (port != -1) {
                sb.append(":").append(Integer.toString(port));
            }
            sb.append(urlPath);
            this.myUrl = sb.toString();
            this.executeMethod = new HttpGet(this.myUrl);
            this.startFetchTime = System.currentTimeMillis();
            this.executeMethod.setHeader((Header)new BasicHeader("User-Agent", userAgent));
            this.executeMethod.setHeader((Header)new BasicHeader("From", from));
            this.executeMethod.setHeader((Header)new BasicHeader("Accept", "*/*"));
            if (lastETag != null) {
                this.executeMethod.setHeader((Header)new BasicHeader("ETag", lastETag));
            }
            if (lastModified != null) {
                this.executeMethod.setHeader((Header)new BasicHeader("Last-Modified", lastModified));
            }
            this.methodThread = new ExecuteMethodThread(this, this.fetchThrottler, this.httpClient, this.executeMethod);
            try {
                this.methodThread.start();
                this.threadStarted = true;
                try {
                    this.statusCode = this.methodThread.getResponseCode();
                    switch (this.statusCode) {
                        case 200: {
                            return 0;
                        }
                        case 305: 
                        case 401: {
                            return 1;
                        }
                        case 408: 
                        case 503: 
                        case 504: {
                            long currentTime = System.currentTimeMillis();
                            throw new ServiceInterruption("Http response temporary error on '" + this.myUrl + "': " + Integer.toString(this.statusCode), null, currentTime + 3600000L, currentTime + 86400000L, -1, false);
                        }
                        case 304: {
                            return 3;
                        }
                        case 500: {
                            long currentTime = System.currentTimeMillis();
                            throw new ServiceInterruption("Http response internal server error on '" + this.myUrl + "': " + Integer.toString(this.statusCode), null, currentTime + 3600000L, currentTime + 86400000L, -1, false);
                        }
                    }
                    return 2;
                }
                catch (InterruptedException e) {
                    try {
                        this.methodThread.interrupt();
                        this.methodThread = null;
                        this.threadStarted = false;
                        throw e;
                    }
                    catch (InterruptedException e2) {
                        this.executeMethod = null;
                        throw new ManifoldCFException("Interrupted: " + e2.getMessage(), (Throwable)e2, 2);
                    }
                }
            }
            catch (MalformedURLException e) {
                this.throwable = new ManifoldCFException("Illegal URI: '" + this.myUrl + "'", (Throwable)e);
                this.statusCode = -101;
                return 2;
            }
            catch (SocketTimeoutException e) {
                this.throwable = e;
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("Timed out waiting for IO for '" + this.myUrl + "': " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 0x6DDD00L, -1, false);
            }
            catch (ConnectTimeoutException e) {
                this.throwable = e;
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("Timed out waiting for connect for '" + this.myUrl + "': " + e.getMessage(), (Throwable)e, currentTime + 3600000L, currentTime + 43200000L, -1, false);
            }
            catch (InterruptedIOException e) {
                throw new ManifoldCFException("Interrupted", 2);
            }
            catch (CircularRedirectException e) {
                this.throwable = e;
                this.statusCode = -100;
                return 2;
            }
            catch (NoHttpResponseException e) {
                this.throwable = e;
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("Timed out waiting for response for '" + this.myUrl + "'", (Throwable)e, currentTime + 900000L, currentTime + 0x6DDD00L, -1, false);
            }
            catch (ConnectException e) {
                this.throwable = e;
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("Timed out waiting for a connection for '" + this.myUrl + "'", (Throwable)e, currentTime + 1000000L, currentTime + 43200000L, -1, false);
            }
            catch (NoRouteToHostException e) {
                this.throwable = e;
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("No route to host for '" + this.myUrl + "'", (Throwable)e, currentTime + 1000000L, currentTime + 43200000L, -1, false);
            }
            catch (HttpException e) {
                this.throwable = e;
                this.statusCode = -103;
                return 2;
            }
            catch (IOException e) {
                this.throwable = e;
                this.statusCode = -103;
                return 2;
            }
            catch (Throwable e) {
                Logging.connectors.debug((Object)("RSS: Caught an unexpected exception: " + e.getMessage()), e);
                this.throwable = e;
                this.statusCode = -999;
                return 2;
            }
        }

        @Override
        public int getResponseCode() throws ManifoldCFException, ServiceInterruption {
            return this.statusCode;
        }

        @Override
        public InputStream getResponseBodyStream() throws ManifoldCFException, ServiceInterruption {
            if (this.executeMethod == null) {
                throw new ManifoldCFException("Attempt to get an input stream when there is no method");
            }
            if (this.methodThread == null || !this.threadStarted) {
                throw new ManifoldCFException("Attempt to get an input stream when no method thread");
            }
            try {
                return this.methodThread.getSafeInputStream();
            }
            catch (InterruptedException e) {
                this.methodThread.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (SocketTimeoutException e) {
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("Timed out waiting for IO for '" + this.myUrl + "': " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 0x6DDD00L, -1, false);
            }
            catch (ConnectTimeoutException e) {
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("Timed out waiting for connect for '" + this.myUrl + "': " + e.getMessage(), (Throwable)e, currentTime + 3600000L, currentTime + 43200000L, -1, false);
            }
            catch (InterruptedIOException e) {
                this.methodThread.interrupt();
                throw new ManifoldCFException("Interrupted", 2);
            }
            catch (NoHttpResponseException e) {
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("Timed out waiting for response for '" + this.myUrl + "'", (Throwable)e, currentTime + 900000L, currentTime + 0x6DDD00L, -1, false);
            }
            catch (ConnectException e) {
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("Timed out waiting for a stream connection for '" + this.myUrl + "'", (Throwable)e, currentTime + 1000000L, currentTime + 43200000L, -1, false);
            }
            catch (NoRouteToHostException e) {
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("No route to host for '" + this.myUrl + "'", (Throwable)e, currentTime + 1000000L, currentTime + 43200000L, -1, false);
            }
            catch (HttpException e) {
                throw new ManifoldCFException("Http exception reading stream: " + e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                throw new ManifoldCFException("I/O exception reading stream: " + e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public String getResponseHeader(String headerName) throws ManifoldCFException, ServiceInterruption {
            if (this.executeMethod == null) {
                throw new ManifoldCFException("Attempt to get a header when there is no method");
            }
            if (this.methodThread == null || !this.threadStarted) {
                throw new ManifoldCFException("Attempt to get a header when no method thread");
            }
            try {
                return this.methodThread.getFirstHeader(headerName);
            }
            catch (InterruptedException e) {
                this.methodThread.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (SocketTimeoutException e) {
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("Timed out waiting for IO for '" + this.myUrl + "': " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 0x6DDD00L, -1, false);
            }
            catch (ConnectTimeoutException e) {
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("Timed out waiting for connect for '" + this.myUrl + "': " + e.getMessage(), (Throwable)e, currentTime + 3600000L, currentTime + 43200000L, -1, false);
            }
            catch (InterruptedIOException e) {
                this.methodThread.interrupt();
                throw new ManifoldCFException("Interrupted", 2);
            }
            catch (NoHttpResponseException e) {
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("Timed out waiting for response for '" + this.myUrl + "'", (Throwable)e, currentTime + 900000L, currentTime + 0x6DDD00L, -1, false);
            }
            catch (ConnectException e) {
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("Timed out waiting for a connection for '" + this.myUrl + "'", (Throwable)e, currentTime + 1000000L, currentTime + 43200000L, -1, false);
            }
            catch (NoRouteToHostException e) {
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("No route to host for '" + this.myUrl + "'", (Throwable)e, currentTime + 1000000L, currentTime + 43200000L, -1, false);
            }
            catch (HttpException e) {
                throw new ManifoldCFException("Http exception reading response: " + e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                throw new ManifoldCFException("I/O exception reading response: " + e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public void doneFetch(IProcessActivity activities) throws ManifoldCFException {
            if (this.fetchType != null) {
                if (this.methodThread != null && this.threadStarted) {
                    this.methodThread.abort();
                }
                long endTime = System.currentTimeMillis();
                activities.recordActivity(new Long(this.startFetchTime), "fetch", new Long(this.fetchCounter), this.myUrl, Integer.toString(this.statusCode), this.throwable == null ? null : this.throwable.getMessage(), null);
                Logging.connectors.info((Object)("RSS: FETCH " + this.fetchType + "|" + this.myUrl + "|" + new Long(this.startFetchTime).toString() + "+" + new Long(endTime - this.startFetchTime).toString() + "|" + Integer.toString(this.statusCode) + "|" + new Long(this.fetchCounter).toString() + "|" + (this.throwable == null ? "" : this.throwable.getClass().getName() + "| " + this.throwable.getMessage())));
                if (this.throwable != null && Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("RSS: Fetch exception for '" + this.myUrl + "'"), this.throwable);
                }
                if (this.methodThread != null) {
                    if (this.threadStarted) {
                        try {
                            this.methodThread.finishUp();
                        }
                        catch (InterruptedException e) {
                            throw new ManifoldCFException(e.getMessage(), (Throwable)e, 2);
                        }
                        this.threadStarted = false;
                    }
                    this.methodThread = null;
                }
                this.executeMethod = null;
                this.throwable = null;
                this.startFetchTime = -1L;
                this.myUrl = null;
                this.statusCode = -1;
                this.fetchType = null;
            }
        }

        @Override
        public void close() throws ManifoldCFException {
            this.connectionManager.shutdown();
            this.connectionThrottler.noteConnectionDestroyed();
            ThrottledFetcher.releaseGlobalHandle();
        }
    }
}

