/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.xml;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.system.SystemListener;

public final class XmlUtilities
extends SystemListener {
    private static volatile DatatypeFactory factory;

    private XmlUtilities() {
        super("org.apache.sis.util");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void classpathChanged() {
        Class<XmlUtilities> clazz = XmlUtilities.class;
        synchronized (XmlUtilities.class) {
            factory = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DatatypeFactory getDatatypeFactory() throws DatatypeConfigurationException {
        DatatypeFactory datatypeFactory = factory;
        if (datatypeFactory != null) return datatypeFactory;
        Class<XmlUtilities> clazz = XmlUtilities.class;
        synchronized (XmlUtilities.class) {
            datatypeFactory = factory;
            if (datatypeFactory != null) return datatypeFactory;
            factory = datatypeFactory = DatatypeFactory.newInstance();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return datatypeFactory;
        }
    }

    public static boolean trimTime(XMLGregorianCalendar xMLGregorianCalendar, boolean bl) {
        if (bl || xMLGregorianCalendar.getMillisecond() == 0) {
            xMLGregorianCalendar.setMillisecond(Integer.MIN_VALUE);
            if (bl || xMLGregorianCalendar.getHour() == 0 && xMLGregorianCalendar.getMinute() == 0 && xMLGregorianCalendar.getSecond() == 0) {
                xMLGregorianCalendar.setHour(Integer.MIN_VALUE);
                xMLGregorianCalendar.setMinute(Integer.MIN_VALUE);
                xMLGregorianCalendar.setSecond(Integer.MIN_VALUE);
                xMLGregorianCalendar.setTimezone(Integer.MIN_VALUE);
                return true;
            }
        }
        return false;
    }

    public static XMLGregorianCalendar toXML(Context context, Date date) throws DatatypeConfigurationException {
        if (date != null) {
            GregorianCalendar gregorianCalendar = XmlUtilities.createGregorianCalendar(context);
            gregorianCalendar.setTime(date);
            return XmlUtilities.getDatatypeFactory().newXMLGregorianCalendar(gregorianCalendar);
        }
        return null;
    }

    private static GregorianCalendar createGregorianCalendar(Context context) {
        if (context != null) {
            Locale locale = context.getLocale();
            TimeZone timeZone = context.getTimeZone();
            if (timeZone != null) {
                return locale != null ? new GregorianCalendar(timeZone, locale) : new GregorianCalendar(timeZone);
            }
            if (locale != null) {
                return new GregorianCalendar(locale);
            }
        }
        return new GregorianCalendar();
    }

    public static Date toDate(Context context, XMLGregorianCalendar xMLGregorianCalendar) {
        if (xMLGregorianCalendar != null) {
            TimeZone timeZone;
            GregorianCalendar gregorianCalendar = xMLGregorianCalendar.toGregorianCalendar();
            if (context != null && xMLGregorianCalendar.getTimezone() == Integer.MIN_VALUE && (timeZone = context.getTimeZone()) != null) {
                gregorianCalendar.setTimeZone(timeZone);
            }
            return gregorianCalendar.getTime();
        }
        return null;
    }

    static {
        SystemListener.add(new XmlUtilities());
    }
}

