/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.measure.Unit;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.extent.Extent;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

abstract class AuthorityFactoryProxy<T> {
    final Class<T> type;
    final byte factoryType;
    static final AuthorityFactoryProxy<InternationalString> DESCRIPTION = new AuthorityFactoryProxy<InternationalString>(InternationalString.class, 5){

        @Override
        InternationalString createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return authorityFactory.getDescriptionText(string);
        }

        @Override
        AuthorityFactoryProxy<InternationalString> specialize(String string) {
            return this;
        }
    };
    static final AuthorityFactoryProxy<IdentifiedObject> OBJECT = new AuthorityFactoryProxy<IdentifiedObject>(IdentifiedObject.class, 5){

        @Override
        IdentifiedObject createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return authorityFactory.createObject(string);
        }
    };
    static final AuthorityFactoryProxy<Datum> DATUM = new AuthorityFactoryProxy<Datum>(Datum.class, 2){

        @Override
        Datum create(GeodeticAuthorityFactory geodeticAuthorityFactory, String string) throws FactoryException {
            return geodeticAuthorityFactory.createDatum(string);
        }

        @Override
        Datum createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.datumFactory(authorityFactory).createDatum(string);
        }
    };
    static final AuthorityFactoryProxy<EngineeringDatum> ENGINEERING_DATUM = new AuthorityFactoryProxy<EngineeringDatum>(EngineeringDatum.class, 2){

        @Override
        EngineeringDatum create(GeodeticAuthorityFactory geodeticAuthorityFactory, String string) throws FactoryException {
            return geodeticAuthorityFactory.createEngineeringDatum(string);
        }

        @Override
        EngineeringDatum createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.datumFactory(authorityFactory).createEngineeringDatum(string);
        }
    };
    static final AuthorityFactoryProxy<ImageDatum> IMAGE_DATUM = new AuthorityFactoryProxy<ImageDatum>(ImageDatum.class, 2){

        @Override
        ImageDatum create(GeodeticAuthorityFactory geodeticAuthorityFactory, String string) throws FactoryException {
            return geodeticAuthorityFactory.createImageDatum(string);
        }

        @Override
        ImageDatum createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.datumFactory(authorityFactory).createImageDatum(string);
        }
    };
    static final AuthorityFactoryProxy<VerticalDatum> VERTICAL_DATUM = new AuthorityFactoryProxy<VerticalDatum>(VerticalDatum.class, 2){

        @Override
        VerticalDatum create(GeodeticAuthorityFactory geodeticAuthorityFactory, String string) throws FactoryException {
            return geodeticAuthorityFactory.createVerticalDatum(string);
        }

        @Override
        VerticalDatum createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.datumFactory(authorityFactory).createVerticalDatum(string);
        }
    };
    static final AuthorityFactoryProxy<TemporalDatum> TEMPORAL_DATUM = new AuthorityFactoryProxy<TemporalDatum>(TemporalDatum.class, 2){

        @Override
        TemporalDatum create(GeodeticAuthorityFactory geodeticAuthorityFactory, String string) throws FactoryException {
            return geodeticAuthorityFactory.createTemporalDatum(string);
        }

        @Override
        TemporalDatum createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.datumFactory(authorityFactory).createTemporalDatum(string);
        }
    };
    static final AuthorityFactoryProxy<GeodeticDatum> GEODETIC_DATUM = new AuthorityFactoryProxy<GeodeticDatum>(GeodeticDatum.class, 2){

        @Override
        GeodeticDatum create(GeodeticAuthorityFactory geodeticAuthorityFactory, String string) throws FactoryException {
            return geodeticAuthorityFactory.createGeodeticDatum(string);
        }

        @Override
        GeodeticDatum createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.datumFactory(authorityFactory).createGeodeticDatum(string);
        }
    };
    static final AuthorityFactoryProxy<Ellipsoid> ELLIPSOID = new AuthorityFactoryProxy<Ellipsoid>(Ellipsoid.class, 2){

        @Override
        Ellipsoid create(GeodeticAuthorityFactory geodeticAuthorityFactory, String string) throws FactoryException {
            return geodeticAuthorityFactory.createEllipsoid(string);
        }

        @Override
        Ellipsoid createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.datumFactory(authorityFactory).createEllipsoid(string);
        }
    };
    static final AuthorityFactoryProxy<PrimeMeridian> PRIME_MERIDIAN = new AuthorityFactoryProxy<PrimeMeridian>(PrimeMeridian.class, 2){

        @Override
        PrimeMeridian create(GeodeticAuthorityFactory geodeticAuthorityFactory, String string) throws FactoryException {
            return geodeticAuthorityFactory.createPrimeMeridian(string);
        }

        @Override
        PrimeMeridian createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.datumFactory(authorityFactory).createPrimeMeridian(string);
        }
    };
    static final AuthorityFactoryProxy<Extent> EXTENT = new AuthorityFactoryProxy<Extent>(Extent.class, 4){

        @Override
        Extent create(GeodeticAuthorityFactory geodeticAuthorityFactory, String string) throws FactoryException {
            return geodeticAuthorityFactory.createExtent(string);
        }

        @Override
        Extent createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.geodeticFactory(authorityFactory).createExtent(string);
        }
    };
    static final AuthorityFactoryProxy<CoordinateSystem> COORDINATE_SYSTEM = new AuthorityFactoryProxy<CoordinateSystem>(CoordinateSystem.class, 1){

        @Override
        CoordinateSystem create(GeodeticAuthorityFactory geodeticAuthorityFactory, String string) throws FactoryException {
            return geodeticAuthorityFactory.createCoordinateSystem(string);
        }

        @Override
        CoordinateSystem createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.csFactory(authorityFactory).createCoordinateSystem(string);
        }
    };
    static final AuthorityFactoryProxy<CartesianCS> CARTESIAN_CS = new AuthorityFactoryProxy<CartesianCS>(CartesianCS.class, 1){

        @Override
        CartesianCS create(GeodeticAuthorityFactory geodeticAuthorityFactory, String string) throws FactoryException {
            return geodeticAuthorityFactory.createCartesianCS(string);
        }

        @Override
        CartesianCS createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.csFactory(authorityFactory).createCartesianCS(string);
        }
    };
    static final AuthorityFactoryProxy<PolarCS> POLAR_CS = new AuthorityFactoryProxy<PolarCS>(PolarCS.class, 1){

        @Override
        PolarCS create(GeodeticAuthorityFactory geodeticAuthorityFactory, String string) throws FactoryException {
            return geodeticAuthorityFactory.createPolarCS(string);
        }

        @Override
        PolarCS createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.csFactory(authorityFactory).createPolarCS(string);
        }
    };
    static final AuthorityFactoryProxy<CylindricalCS> CYLINDRICAL_CS = new AuthorityFactoryProxy<CylindricalCS>(CylindricalCS.class, 1){

        @Override
        CylindricalCS create(GeodeticAuthorityFactory geodeticAuthorityFactory, String string) throws FactoryException {
            return geodeticAuthorityFactory.createCylindricalCS(string);
        }

        @Override
        CylindricalCS createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.csFactory(authorityFactory).createCylindricalCS(string);
        }
    };
    static final AuthorityFactoryProxy<SphericalCS> SPHERICAL_CS = new AuthorityFactoryProxy<SphericalCS>(SphericalCS.class, 1){

        @Override
        SphericalCS create(GeodeticAuthorityFactory geodeticAuthorityFactory, String string) throws FactoryException {
            return geodeticAuthorityFactory.createSphericalCS(string);
        }

        @Override
        SphericalCS createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.csFactory(authorityFactory).createSphericalCS(string);
        }
    };
    static final AuthorityFactoryProxy<EllipsoidalCS> ELLIPSOIDAL_CS = new AuthorityFactoryProxy<EllipsoidalCS>(EllipsoidalCS.class, 1){

        @Override
        EllipsoidalCS create(GeodeticAuthorityFactory geodeticAuthorityFactory, String string) throws FactoryException {
            return geodeticAuthorityFactory.createEllipsoidalCS(string);
        }

        @Override
        EllipsoidalCS createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.csFactory(authorityFactory).createEllipsoidalCS(string);
        }
    };
    static final AuthorityFactoryProxy<VerticalCS> VERTICAL_CS = new AuthorityFactoryProxy<VerticalCS>(VerticalCS.class, 1){

        @Override
        VerticalCS create(GeodeticAuthorityFactory geodeticAuthorityFactory, String string) throws FactoryException {
            return geodeticAuthorityFactory.createVerticalCS(string);
        }

        @Override
        VerticalCS createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.csFactory(authorityFactory).createVerticalCS(string);
        }
    };
    static final AuthorityFactoryProxy<TimeCS> TIME_CS = new AuthorityFactoryProxy<TimeCS>(TimeCS.class, 1){

        @Override
        TimeCS create(GeodeticAuthorityFactory geodeticAuthorityFactory, String string) throws FactoryException {
            return geodeticAuthorityFactory.createTimeCS(string);
        }

        @Override
        TimeCS createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.csFactory(authorityFactory).createTimeCS(string);
        }
    };
    static final AuthorityFactoryProxy<CoordinateSystemAxis> AXIS = new AuthorityFactoryProxy<CoordinateSystemAxis>(CoordinateSystemAxis.class, 1){

        @Override
        CoordinateSystemAxis create(GeodeticAuthorityFactory geodeticAuthorityFactory, String string) throws FactoryException {
            return geodeticAuthorityFactory.createCoordinateSystemAxis(string);
        }

        @Override
        CoordinateSystemAxis createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.csFactory(authorityFactory).createCoordinateSystemAxis(string);
        }
    };
    static final AuthorityFactoryProxy<Unit<?>> UNIT = new AuthorityFactoryProxy<Unit<?>>(Unit.class, 1){

        @Override
        Unit<?> create(GeodeticAuthorityFactory geodeticAuthorityFactory, String string) throws FactoryException {
            return geodeticAuthorityFactory.createUnit(string);
        }

        @Override
        Unit<?> createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.csFactory(authorityFactory).createUnit(string);
        }
    };
    static final AuthorityFactoryProxy<CoordinateReferenceSystem> CRS = new AuthorityFactoryProxy<CoordinateReferenceSystem>(CoordinateReferenceSystem.class, 0){

        @Override
        CoordinateReferenceSystem create(GeodeticAuthorityFactory geodeticAuthorityFactory, String string) throws FactoryException {
            return geodeticAuthorityFactory.createCoordinateReferenceSystem(string);
        }

        @Override
        CoordinateReferenceSystem createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.crsFactory(authorityFactory).createCoordinateReferenceSystem(string);
        }
    };
    static final AuthorityFactoryProxy<CompoundCRS> COMPOUND_CRS = new AuthorityFactoryProxy<CompoundCRS>(CompoundCRS.class, 0){

        @Override
        CompoundCRS create(GeodeticAuthorityFactory geodeticAuthorityFactory, String string) throws FactoryException {
            return geodeticAuthorityFactory.createCompoundCRS(string);
        }

        @Override
        CompoundCRS createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.crsFactory(authorityFactory).createCompoundCRS(string);
        }
    };
    static final AuthorityFactoryProxy<DerivedCRS> DERIVED_CRS = new AuthorityFactoryProxy<DerivedCRS>(DerivedCRS.class, 0){

        @Override
        DerivedCRS create(GeodeticAuthorityFactory geodeticAuthorityFactory, String string) throws FactoryException {
            return geodeticAuthorityFactory.createDerivedCRS(string);
        }

        @Override
        DerivedCRS createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.crsFactory(authorityFactory).createDerivedCRS(string);
        }
    };
    static final AuthorityFactoryProxy<EngineeringCRS> ENGINEERING_CRS = new AuthorityFactoryProxy<EngineeringCRS>(EngineeringCRS.class, 0){

        @Override
        EngineeringCRS create(GeodeticAuthorityFactory geodeticAuthorityFactory, String string) throws FactoryException {
            return geodeticAuthorityFactory.createEngineeringCRS(string);
        }

        @Override
        EngineeringCRS createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.crsFactory(authorityFactory).createEngineeringCRS(string);
        }
    };
    static final AuthorityFactoryProxy<GeographicCRS> GEOGRAPHIC_CRS = new AuthorityFactoryProxy<GeographicCRS>(GeographicCRS.class, 0){

        @Override
        GeographicCRS create(GeodeticAuthorityFactory geodeticAuthorityFactory, String string) throws FactoryException {
            return geodeticAuthorityFactory.createGeographicCRS(string);
        }

        @Override
        GeographicCRS createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.crsFactory(authorityFactory).createGeographicCRS(string);
        }
    };
    static final AuthorityFactoryProxy<GeocentricCRS> GEOCENTRIC_CRS = new AuthorityFactoryProxy<GeocentricCRS>(GeocentricCRS.class, 0){

        @Override
        GeocentricCRS create(GeodeticAuthorityFactory geodeticAuthorityFactory, String string) throws FactoryException {
            return geodeticAuthorityFactory.createGeocentricCRS(string);
        }

        @Override
        GeocentricCRS createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.crsFactory(authorityFactory).createGeocentricCRS(string);
        }
    };
    static final AuthorityFactoryProxy<ImageCRS> IMAGE_CRS = new AuthorityFactoryProxy<ImageCRS>(ImageCRS.class, 0){

        @Override
        ImageCRS create(GeodeticAuthorityFactory geodeticAuthorityFactory, String string) throws FactoryException {
            return geodeticAuthorityFactory.createImageCRS(string);
        }

        @Override
        ImageCRS createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.crsFactory(authorityFactory).createImageCRS(string);
        }
    };
    static final AuthorityFactoryProxy<ProjectedCRS> PROJECTED_CRS = new AuthorityFactoryProxy<ProjectedCRS>(ProjectedCRS.class, 0){

        @Override
        ProjectedCRS create(GeodeticAuthorityFactory geodeticAuthorityFactory, String string) throws FactoryException {
            return geodeticAuthorityFactory.createProjectedCRS(string);
        }

        @Override
        ProjectedCRS createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.crsFactory(authorityFactory).createProjectedCRS(string);
        }
    };
    static final AuthorityFactoryProxy<TemporalCRS> TEMPORAL_CRS = new AuthorityFactoryProxy<TemporalCRS>(TemporalCRS.class, 0){

        @Override
        TemporalCRS create(GeodeticAuthorityFactory geodeticAuthorityFactory, String string) throws FactoryException {
            return geodeticAuthorityFactory.createTemporalCRS(string);
        }

        @Override
        TemporalCRS createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.crsFactory(authorityFactory).createTemporalCRS(string);
        }
    };
    static final AuthorityFactoryProxy<VerticalCRS> VERTICAL_CRS = new AuthorityFactoryProxy<VerticalCRS>(VerticalCRS.class, 0){

        @Override
        VerticalCRS create(GeodeticAuthorityFactory geodeticAuthorityFactory, String string) throws FactoryException {
            return geodeticAuthorityFactory.createVerticalCRS(string);
        }

        @Override
        VerticalCRS createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.crsFactory(authorityFactory).createVerticalCRS(string);
        }
    };
    static final AuthorityFactoryProxy<ParameterDescriptor> PARAMETER = new AuthorityFactoryProxy<ParameterDescriptor>(ParameterDescriptor.class, 4){

        @Override
        ParameterDescriptor<?> create(GeodeticAuthorityFactory geodeticAuthorityFactory, String string) throws FactoryException {
            return geodeticAuthorityFactory.createParameterDescriptor(string);
        }

        @Override
        ParameterDescriptor createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.geodeticFactory(authorityFactory).createParameterDescriptor(string);
        }
    };
    static final AuthorityFactoryProxy<OperationMethod> METHOD = new AuthorityFactoryProxy<OperationMethod>(OperationMethod.class, 3){

        @Override
        OperationMethod create(GeodeticAuthorityFactory geodeticAuthorityFactory, String string) throws FactoryException {
            return geodeticAuthorityFactory.createOperationMethod(string);
        }

        @Override
        OperationMethod createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.opFactory(authorityFactory).createOperationMethod(string);
        }
    };
    static final AuthorityFactoryProxy<CoordinateOperation> OPERATION = new AuthorityFactoryProxy<CoordinateOperation>(CoordinateOperation.class, 3){

        @Override
        CoordinateOperation create(GeodeticAuthorityFactory geodeticAuthorityFactory, String string) throws FactoryException {
            return geodeticAuthorityFactory.createCoordinateOperation(string);
        }

        @Override
        CoordinateOperation createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.opFactory(authorityFactory).createCoordinateOperation(string);
        }
    };
    static final AuthorityFactoryProxy<?>[] PROXIES = new AuthorityFactoryProxy[]{PROJECTED_CRS, GEOGRAPHIC_CRS, GEOCENTRIC_CRS, VERTICAL_CRS, TEMPORAL_CRS, IMAGE_CRS, ENGINEERING_CRS, DERIVED_CRS, COMPOUND_CRS, CRS, GEODETIC_DATUM, VERTICAL_DATUM, TEMPORAL_DATUM, IMAGE_DATUM, ENGINEERING_DATUM, DATUM, ELLIPSOID, PRIME_MERIDIAN, CARTESIAN_CS, ELLIPSOIDAL_CS, SPHERICAL_CS, CYLINDRICAL_CS, POLAR_CS, VERTICAL_CS, TIME_CS, COORDINATE_SYSTEM, AXIS, OPERATION, METHOD, PARAMETER, UNIT, EXTENT, OBJECT, DESCRIPTION};
    private static final Map<String, AuthorityFactoryProxy<?>> BY_URN_TYPE;

    AuthorityFactoryProxy(Class<T> clazz, byte by) {
        this.type = clazz;
        this.factoryType = by;
    }

    public String toString() {
        return Strings.bracket(AuthorityFactoryProxy.class, (Object)this.type.getSimpleName());
    }

    final DatumAuthorityFactory datumFactory(AuthorityFactory authorityFactory) throws FactoryException {
        if (authorityFactory instanceof DatumAuthorityFactory) {
            return (DatumAuthorityFactory)authorityFactory;
        }
        throw AuthorityFactoryProxy.factoryNotFound(DatumAuthorityFactory.class);
    }

    final CSAuthorityFactory csFactory(AuthorityFactory authorityFactory) throws FactoryException {
        if (authorityFactory instanceof CSAuthorityFactory) {
            return (CSAuthorityFactory)authorityFactory;
        }
        throw AuthorityFactoryProxy.factoryNotFound(CSAuthorityFactory.class);
    }

    final CRSAuthorityFactory crsFactory(AuthorityFactory authorityFactory) throws FactoryException {
        if (authorityFactory instanceof CRSAuthorityFactory) {
            return (CRSAuthorityFactory)authorityFactory;
        }
        throw AuthorityFactoryProxy.factoryNotFound(CRSAuthorityFactory.class);
    }

    final CoordinateOperationAuthorityFactory opFactory(AuthorityFactory authorityFactory) throws FactoryException {
        if (authorityFactory instanceof CoordinateOperationAuthorityFactory) {
            return (CoordinateOperationAuthorityFactory)authorityFactory;
        }
        throw AuthorityFactoryProxy.factoryNotFound(CoordinateOperationAuthorityFactory.class);
    }

    final GeodeticAuthorityFactory geodeticFactory(AuthorityFactory authorityFactory) throws FactoryException {
        if (authorityFactory instanceof CRSAuthorityFactory) {
            return (GeodeticAuthorityFactory)authorityFactory;
        }
        throw AuthorityFactoryProxy.factoryNotFound(GeodeticAuthorityFactory.class);
    }

    private static FactoryException factoryNotFound(Class<? extends AuthorityFactory> clazz) {
        return new FactoryException(Errors.format((short)38, clazz));
    }

    T create(GeodeticAuthorityFactory geodeticAuthorityFactory, String string) throws FactoryException {
        return this.createFromAPI(geodeticAuthorityFactory, string);
    }

    abstract T createFromAPI(AuthorityFactory var1, String var2) throws FactoryException;

    static <T> AuthorityFactoryProxy<? super T> getInstance(Class<T> clazz) throws IllegalArgumentException {
        for (AuthorityFactoryProxy<?> authorityFactoryProxy : PROXIES) {
            if (!authorityFactoryProxy.type.isAssignableFrom(clazz)) continue;
            return authorityFactoryProxy;
        }
        throw new IllegalArgumentException(Errors.format((short)50, IdentifiedObject.class, clazz));
    }

    AuthorityFactoryProxy<? extends T> specialize(String string) {
        AuthorityFactoryProxy<?> authorityFactoryProxy = BY_URN_TYPE.get(string.toLowerCase(Locale.US));
        if (authorityFactoryProxy != null) {
            if (authorityFactoryProxy.type.isAssignableFrom(this.type)) {
                return this;
            }
            if (this.type.isAssignableFrom(authorityFactoryProxy.type)) {
                return authorityFactoryProxy;
            }
        }
        return null;
    }

    static {
        HashMap hashMap = new HashMap(16);
        hashMap.put("crs", CRS);
        hashMap.put("crs-compound", CRS);
        hashMap.put("datum", DATUM);
        hashMap.put("ellipsoid", ELLIPSOID);
        hashMap.put("meridian", PRIME_MERIDIAN);
        hashMap.put("cs", COORDINATE_SYSTEM);
        hashMap.put("axis", AXIS);
        hashMap.put("coordinateoperation", OPERATION);
        hashMap.put("method", METHOD);
        hashMap.put("parameter", PARAMETER);
        hashMap.put("referencesystem", CRS);
        hashMap.put("uom", UNIT);
        BY_URN_TYPE = hashMap;
    }
}

