/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.nio.Buffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Optional;
import org.apache.sis.image.BandedIterator;
import org.apache.sis.image.ImageAdapter;
import org.apache.sis.image.SequenceType;
import org.apache.sis.image.TransferType;
import org.apache.sis.image.WritablePixelIterator;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Errors;

public class PixelIterator {
    final RenderedImage image;
    private Raster currentRaster;
    final int numBands;
    final int lowerX;
    final int lowerY;
    final int upperX;
    final int upperY;
    private final int tileWidth;
    private final int tileHeight;
    private final int tileGridXOffset;
    private final int tileGridYOffset;
    private final int tileLowerX;
    private final int tileLowerY;
    private final int tileUpperX;
    private final int tileUpperY;
    private final int windowWidth;
    private final int windowHeight;
    int tileX;
    int tileY;
    int x;
    int y;
    private int currentLowerX;
    private int currentUpperX;
    private int currentUpperY;
    private int windowLimitX;
    private int windowLimitY;
    private final boolean isDefaultOrder;

    PixelIterator(Raster raster, Rectangle rectangle, Dimension dimension, SequenceType sequenceType) {
        this.image = null;
        this.currentRaster = raster;
        this.numBands = raster.getNumBands();
        this.tileWidth = raster.getWidth();
        this.tileHeight = raster.getHeight();
        this.tileGridXOffset = raster.getMinX();
        this.tileGridYOffset = raster.getMinY();
        Rectangle rectangle2 = PixelIterator.intersection(this.tileGridXOffset, this.tileGridYOffset, this.tileWidth, this.tileHeight, rectangle, dimension);
        this.tileLowerX = 0;
        this.tileLowerY = 0;
        this.tileUpperX = rectangle2.width == 0 ? 0 : 1;
        this.tileUpperY = rectangle2.height == 0 ? 0 : 1;
        this.lowerX = rectangle2.x;
        this.lowerY = rectangle2.y;
        this.upperX = Math.addExact(this.lowerX, rectangle2.width);
        this.upperY = Math.addExact(this.lowerY, rectangle2.height);
        this.windowWidth = dimension != null ? dimension.width : 0;
        this.windowHeight = dimension != null ? dimension.height : 0;
        this.currentLowerX = this.lowerX;
        this.currentUpperX = this.upperX;
        this.currentUpperY = this.upperY;
        this.windowLimitX = Math.addExact(this.tileGridXOffset, this.tileWidth);
        this.windowLimitY = Math.addExact(this.tileGridYOffset, this.tileHeight);
        this.x = Math.decrementExact(this.lowerX);
        this.y = this.lowerY;
        this.isDefaultOrder = true;
    }

    PixelIterator(RenderedImage renderedImage, Rectangle rectangle, Dimension dimension, SequenceType sequenceType) {
        this.image = renderedImage;
        this.numBands = renderedImage.getSampleModel().getNumBands();
        this.tileWidth = renderedImage.getTileWidth();
        this.tileHeight = renderedImage.getTileHeight();
        this.tileGridXOffset = renderedImage.getTileGridXOffset();
        this.tileGridYOffset = renderedImage.getTileGridYOffset();
        Rectangle rectangle2 = PixelIterator.intersection(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight(), rectangle, dimension);
        this.lowerX = rectangle2.x;
        this.lowerY = rectangle2.y;
        this.upperX = Math.addExact(this.lowerX, rectangle2.width);
        this.upperY = Math.addExact(this.lowerY, rectangle2.height);
        this.tileLowerX = Math.floorDiv(Math.subtractExact(this.lowerX, this.tileGridXOffset), this.tileWidth);
        this.tileLowerY = Math.floorDiv(Math.subtractExact(this.lowerY, this.tileGridYOffset), this.tileHeight);
        this.tileUpperX = Numerics.ceilDiv(Math.subtractExact(this.upperX, this.tileGridXOffset), this.tileWidth);
        this.tileUpperY = Numerics.ceilDiv(Math.subtractExact(this.upperY, this.tileGridYOffset), this.tileHeight);
        this.windowWidth = dimension != null ? dimension.width : 0;
        this.windowHeight = dimension != null ? dimension.height : 0;
        this.tileX = Math.decrementExact(this.tileLowerX);
        this.tileY = this.tileLowerY;
        this.currentLowerX = this.lowerX;
        this.currentUpperX = this.lowerX;
        this.currentUpperY = this.lowerY;
        this.x = Math.decrementExact(this.lowerX);
        this.y = this.lowerY;
        boolean bl = this.isDefaultOrder = sequenceType == null || this.tileUpperX - this.tileLowerX <= 1;
        if (this.tileUpperY == Integer.MAX_VALUE) {
            throw new ArithmeticException(Errors.format((short)10, 32));
        }
    }

    private static Rectangle intersection(int n, int n2, int n3, int n4, Rectangle rectangle, Dimension dimension) {
        if (dimension != null) {
            if (n3 <= 0 || n4 <= 0) {
                throw new IllegalArgumentException(Resources.format((short)19));
            }
            ArgumentChecks.ensureBetween("window.width", 1, n3, dimension.width);
            ArgumentChecks.ensureBetween("window.height", 1, n4, dimension.height);
            n3 -= dimension.width - 1;
            n4 -= dimension.height - 1;
        }
        Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
        if (rectangle != null) {
            rectangle2 = rectangle2.intersection(rectangle);
            if (rectangle2.width < 0) {
                rectangle2.x = n;
                rectangle2.width = 0;
            }
            if (rectangle2.height < 0) {
                rectangle2.y = n2;
                rectangle2.height = 0;
            }
        }
        return rectangle2;
    }

    public static PixelIterator create(RenderedImage renderedImage) {
        return new Builder().create(renderedImage);
    }

    public boolean isWritable() {
        return false;
    }

    public TransferType<?> getTransferType() {
        return TransferType.valueOf(this.getSampleModel().getTransferType());
    }

    private SampleModel getSampleModel() {
        return this.image != null ? this.image.getSampleModel() : this.currentRaster.getSampleModel();
    }

    public NumberRange<?>[] getSampleRanges() {
        SampleModel sampleModel = this.getSampleModel();
        Object[] objectArray = new NumberRange[sampleModel.getNumBands()];
        if (objectArray.length != 0) {
            int n = sampleModel.getDataType();
            if (ImageUtilities.isIntegerType(n)) {
                int n2;
                int n3 = 0;
                do {
                    NumberRange<Number> numberRange;
                    int n4 = sampleModel.getSampleSize(n3);
                    long l = 0L;
                    long l2 = Numerics.bitmask(n4) - 1L;
                    if (!ImageUtilities.isUnsignedType(sampleModel)) {
                        l = (l2 >>>= 1) ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                    objectArray[n3] = numberRange = n == 0 || n == 2 ? NumberRange.create((short)l, true, (short)l2, true) : NumberRange.create((int)l, true, (int)l2, true);
                    n2 = n3;
                    int n5 = objectArray.length;
                    while (--n5 > n2) {
                        if (objectArray[n5] != null) continue;
                        if (sampleModel.getSampleSize(n5) == n4) {
                            objectArray[n5] = numberRange;
                            continue;
                        }
                        n3 = n5;
                    }
                } while (n3 > n2);
            } else {
                Arrays.fill(objectArray, n == 4 ? NumberRange.create(Float.NEGATIVE_INFINITY, false, Float.POSITIVE_INFINITY, false) : NumberRange.create(Double.NEGATIVE_INFINITY, false, Double.POSITIVE_INFINITY, false));
            }
        }
        return objectArray;
    }

    public Optional<SequenceType> getIterationOrder() {
        if (this.isDefaultOrder && this.tileUpperX - this.tileLowerX > 1) {
            return Optional.empty();
        }
        return Optional.of(SequenceType.LINEAR);
    }

    public int getNumBands() {
        return this.numBands;
    }

    public Rectangle getDomain() {
        return new Rectangle(this.lowerX, this.lowerY, this.upperX - this.lowerX, this.upperY - this.lowerY);
    }

    public Point getPosition() {
        int n;
        if (this.x < this.lowerX) {
            n = 39;
        } else if (this.tileY >= this.tileUpperY) {
            n = 38;
        } else {
            return new Point(this.x, this.y);
        }
        throw new IllegalStateException(Resources.format((short)n));
    }

    public void moveTo(int n, int n2) {
        if (n < this.lowerX || n >= this.upperX || n2 < this.lowerY || n2 >= this.upperY) {
            throw new IndexOutOfBoundsException(Resources.format((short)57, n, n2));
        }
        if (this.image != null) {
            int n3 = Math.floorDiv(n - this.tileGridXOffset, this.tileWidth);
            int n4 = Math.floorDiv(n2 - this.tileGridYOffset, this.tileHeight);
            if (n3 != this.tileX || n4 != this.tileY) {
                this.releaseTile();
                this.tileX = n3;
                this.tileY = n4;
                if (this.fetchTile() > n2 || this.currentLowerX > n) {
                    throw new RasterFormatException(Resources.format((short)35, this.tileX, this.tileY));
                }
            }
        }
        this.x = n;
        this.y = n2;
    }

    public boolean next() {
        if (++this.x >= this.currentUpperX) {
            if (this.isDefaultOrder) {
                if (++this.y >= this.currentUpperY) {
                    this.releaseTile();
                    if (++this.tileX >= this.tileUpperX) {
                        if (++this.tileY >= this.tileUpperY) {
                            this.endOfIteration();
                            return false;
                        }
                        this.tileX = this.tileLowerX;
                    }
                    this.y = this.fetchTile();
                }
                this.x = this.currentLowerX;
            } else {
                this.releaseTile();
                if (this.x < this.upperX) {
                    ++this.tileX;
                } else {
                    if (++this.y >= this.currentUpperY && ++this.tileY >= this.tileUpperY) {
                        this.endOfIteration();
                        return false;
                    }
                    this.tileX = this.tileLowerX;
                    this.x = this.lowerX;
                }
                if (this.fetchTile() > this.y) {
                    throw new RasterFormatException(Resources.format((short)35, this.tileX, this.tileY));
                }
            }
            this.changedRowOrTile();
        }
        return true;
    }

    void changedRowOrTile() {
    }

    final boolean isSameRowAndTile(int n, int n2) {
        return n2 == this.y && n >= this.currentLowerX && n < this.currentUpperX;
    }

    private int fetchTile() {
        Raster raster = this.fetchWritableTile();
        if (raster == null) {
            raster = this.image.getTile(this.tileX, this.tileY);
        }
        if (raster.getNumBands() != this.numBands || raster.getWidth() != this.tileWidth || raster.getHeight() != this.tileHeight) {
            throw new RasterFormatException(Resources.format((short)35, this.tileX, this.tileY));
        }
        int n = raster.getMinX();
        int n2 = raster.getMinY();
        this.windowLimitX = Math.addExact(n, this.tileWidth);
        this.windowLimitY = Math.addExact(n2, this.tileHeight);
        this.currentUpperX = Math.min(this.upperX, this.windowLimitX);
        this.currentUpperY = Math.min(this.upperY, this.windowLimitY);
        this.currentLowerX = Math.max(this.lowerX, n);
        this.currentRaster = raster;
        this.acquiredTile(raster);
        return Math.max(this.lowerY, n2);
    }

    Raster fetchWritableTile() {
        return null;
    }

    void acquiredTile(Raster raster) {
    }

    void releaseTile() {
        if (this.image != null) {
            this.currentRaster = null;
        }
    }

    private void endOfIteration() {
        boolean bl = this.tileY > Math.max(this.tileUpperY, this.tileLowerY + 1);
        this.x = this.currentUpperX - 1;
        this.y = this.currentUpperY - 1;
        this.tileX = this.tileUpperX - 1;
        this.tileY = this.tileUpperY;
        if (bl) {
            throw new IllegalStateException(Resources.format((short)38));
        }
    }

    public int getSample(int n) {
        return this.currentRaster.getSample(this.x, this.y, n);
    }

    public float getSampleFloat(int n) {
        return this.currentRaster.getSampleFloat(this.x, this.y, n);
    }

    public double getSampleDouble(int n) {
        return this.currentRaster.getSampleDouble(this.x, this.y, n);
    }

    public int[] getPixel(int[] nArray) {
        return this.currentRaster.getPixel(this.x, this.y, nArray);
    }

    public float[] getPixel(float[] fArray) {
        return this.currentRaster.getPixel(this.x, this.y, fArray);
    }

    public double[] getPixel(double[] dArray) {
        return this.currentRaster.getPixel(this.x, this.y, dArray);
    }

    public Object getDataElements(Object object) {
        return this.currentRaster.getDataElements(this.x, this.y, object);
    }

    public <T extends Buffer> Window<T> createWindow(TransferType<T> transferType) {
        IntWindow intWindow;
        ArgumentChecks.ensureNonNull("type", transferType);
        int n = this.numBands * this.windowWidth * this.windowHeight;
        int n2 = n - this.numBands * Math.min(this.windowWidth, this.windowHeight);
        switch (transferType.dataBufferType) {
            case 3: {
                intWindow = new IntWindow(new int[n], new int[n2]);
                break;
            }
            case 4: {
                intWindow = this.createWindow(new float[n], new float[n2]);
                break;
            }
            case 5: {
                intWindow = this.createWindow(new double[n], new double[n2]);
                break;
            }
            default: {
                throw new AssertionError(transferType);
            }
        }
        return intWindow;
    }

    Window<FloatBuffer> createWindow(float[] fArray, float[] fArray2) {
        return new FloatWindow(fArray, fArray2);
    }

    Window<DoubleBuffer> createWindow(double[] dArray, double[] dArray2) {
        return new DoubleWindow(dArray, dArray2);
    }

    final void fetchValues(Window<?> window, Object object) {
        boolean bl;
        int n = this.windowLimitX - this.x;
        int n2 = this.windowLimitY - this.y;
        int n3 = Math.min(this.windowWidth, n);
        int n4 = Math.min(this.windowHeight, n2);
        boolean bl2 = bl = n3 == this.windowWidth;
        if (bl && n4 == this.windowHeight) {
            Object object2 = window.getPixels(this.currentRaster, this.x, this.y, n3, n4, 0);
            assert (object2 == object);
            return;
        }
        Raster raster = this.currentRaster;
        int n5 = 1;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = this.tileX;
        int n10 = this.tileY;
        int n11 = this.windowWidth * this.numBands;
        int n12 = n;
        while (true) {
            if (n3 > 0 && n4 > 0) {
                Object object3 = window.getPixels(raster, this.x + n7, this.y + n8, n3, n4, n5);
                if (bl) {
                    System.arraycopy(object3, 0, object, n6, n11 * n4);
                } else {
                    int n13 = this.numBands * n3;
                    int n14 = n13 * n4;
                    for (int i = 0; i < n14; i += n13) {
                        System.arraycopy(object3, i, object, n6, n13);
                        n6 += n11;
                    }
                }
            }
            if (n < this.windowWidth) {
                n7 = n;
                n += this.tileWidth;
                ++n9;
            } else {
                if (n2 >= this.windowHeight) {
                    return;
                }
                n8 = n2;
                n2 += this.tileHeight;
                ++n10;
                n9 = this.tileX;
                n = n12;
                n7 = 0;
            }
            n5 = 2;
            raster = this.image.getTile(n9, n10);
            n6 = (n8 * this.windowWidth + n7) * this.numBands;
            n3 = Math.min(this.windowWidth, n) - n7;
            n4 = Math.min(this.windowHeight, n2) - n8;
            bl = n3 == this.windowWidth;
        }
    }

    public void rewind() {
        this.releaseTile();
        if (this.image == null) {
            this.tileX = 0;
            this.tileY = 0;
        } else {
            this.tileX = this.tileLowerX - 1;
            this.tileY = this.tileLowerY;
            this.currentLowerX = this.lowerX;
            this.currentUpperX = this.lowerX;
            this.currentUpperY = this.lowerY;
        }
        this.x = this.lowerX - 1;
        this.y = this.lowerY;
        this.changedRowOrTile();
    }

    public static class Builder {
        private Rectangle subArea;
        private Dimension window;
        private SequenceType order;

        public Builder setRegionOfInterest(Rectangle rectangle) {
            if (rectangle != null && rectangle.isEmpty()) {
                throw new IllegalArgumentException(Resources.format((short)20));
            }
            this.subArea = rectangle;
            return this;
        }

        public Builder setWindowSize(Dimension dimension) {
            this.window = dimension;
            return this;
        }

        public Builder setIteratorOrder(SequenceType sequenceType) {
            if (sequenceType != null && !sequenceType.equals((Object)SequenceType.LINEAR)) {
                throw new IllegalArgumentException(Errors.format((short)163, (Object)sequenceType));
            }
            this.order = sequenceType;
            return this;
        }

        private static RenderedImage unwrap(RenderedImage renderedImage) {
            while (renderedImage instanceof ImageAdapter) {
                renderedImage = ((ImageAdapter)renderedImage).source;
            }
            return renderedImage;
        }

        static int getScanlineStride(SampleModel sampleModel) {
            MultiPixelPackedSampleModel multiPixelPackedSampleModel;
            if (sampleModel instanceof ComponentSampleModel) {
                ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
                if (componentSampleModel.getPixelStride() == 1) {
                    for (int n : componentSampleModel.getBandOffsets()) {
                        if (n == 0) continue;
                        return 0;
                    }
                    if (ArraysExt.isRange(0, componentSampleModel.getBankIndices())) {
                        return componentSampleModel.getScanlineStride();
                    }
                }
            } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
                SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
                int[] nArray = singlePixelPackedSampleModel.getBitOffsets();
                if (nArray.length == 1 && nArray[0] == 0) {
                    return singlePixelPackedSampleModel.getScanlineStride();
                }
            } else if (sampleModel instanceof MultiPixelPackedSampleModel && (multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel).getDataBitOffset() == 0 && multiPixelPackedSampleModel.getPixelBitStride() == DataBuffer.getDataTypeSize(multiPixelPackedSampleModel.getDataType())) {
                return multiPixelPackedSampleModel.getScanlineStride();
            }
            return 0;
        }

        public PixelIterator create(Raster raster) {
            ArgumentChecks.ensureNonNull("data", raster);
            int n = Builder.getScanlineStride(raster.getSampleModel());
            if (n > 0) {
                return new BandedIterator(raster, null, this.subArea, this.window, this.order, n);
            }
            return new PixelIterator(raster, this.subArea, this.window, this.order);
        }

        public PixelIterator create(RenderedImage renderedImage) {
            ArgumentChecks.ensureNonNull("data", renderedImage);
            renderedImage = Builder.unwrap(renderedImage);
            if (renderedImage instanceof BufferedImage) {
                return this.create(((BufferedImage)renderedImage).getRaster());
            }
            int n = Builder.getScanlineStride(renderedImage.getSampleModel());
            if (n > 0) {
                return new BandedIterator(renderedImage, null, this.subArea, this.window, this.order, n);
            }
            return new PixelIterator(renderedImage, this.subArea, this.window, this.order);
        }

        public WritablePixelIterator createWritable(WritableRaster writableRaster) {
            ArgumentChecks.ensureNonNull("data", writableRaster);
            return this.createWritable(writableRaster, writableRaster);
        }

        public WritablePixelIterator createWritable(WritableRenderedImage writableRenderedImage) {
            ArgumentChecks.ensureNonNull("data", writableRenderedImage);
            if (writableRenderedImage instanceof BufferedImage) {
                return this.createWritable(((BufferedImage)writableRenderedImage).getRaster());
            }
            return this.createWritable(writableRenderedImage, writableRenderedImage);
        }

        public WritablePixelIterator createWritable(Raster raster, WritableRaster writableRaster) {
            ArgumentChecks.ensureNonNull("input", raster);
            ArgumentChecks.ensureNonNull("output", writableRaster);
            int n = Builder.getScanlineStride(raster.getSampleModel());
            if (n > 0) {
                return new BandedIterator(raster, writableRaster, this.subArea, this.window, this.order, n);
            }
            return new WritablePixelIterator(raster, writableRaster, this.subArea, this.window, this.order);
        }

        public WritablePixelIterator createWritable(RenderedImage renderedImage, WritableRenderedImage writableRenderedImage) {
            ArgumentChecks.ensureNonNull("input", renderedImage);
            ArgumentChecks.ensureNonNull("output", writableRenderedImage);
            renderedImage = Builder.unwrap(renderedImage);
            int n = Builder.getScanlineStride(renderedImage.getSampleModel());
            if (n > 0) {
                return new BandedIterator(renderedImage, writableRenderedImage, this.subArea, this.window, this.order, n);
            }
            return new WritablePixelIterator(renderedImage, writableRenderedImage, this.subArea, this.window, this.order);
        }
    }

    private final class IntWindow
    extends Window<IntBuffer> {
        private final int[] data;
        private final int[] transfer;

        IntWindow(int[] nArray, int[] nArray2) {
            super(IntBuffer.wrap(nArray).asReadOnlyBuffer());
            this.data = nArray;
            this.transfer = nArray2;
        }

        @Override
        final PixelIterator owner() {
            return PixelIterator.this;
        }

        @Override
        Object getPixels(Raster raster, int n, int n2, int n3, int n4, int n5) {
            return raster.getPixels(n, n2, n3, n4, n5 == 0 ? this.data : this.transfer);
        }

        @Override
        public void update() {
            ((IntBuffer)this.values).clear();
            PixelIterator.this.fetchValues(this, this.data);
        }
    }

    public static abstract class Window<T extends Buffer> {
        static final int DIRECT = 0;
        static final int TRANSFER = 1;
        static final int TRANSFER_FROM_OTHER = 2;
        public final T values;

        Window(T t) {
            this.values = t;
        }

        abstract PixelIterator owner();

        public final Dimension getSize() {
            PixelIterator pixelIterator = this.owner();
            return new Dimension(pixelIterator.windowWidth, pixelIterator.windowHeight);
        }

        public abstract void update();

        abstract Object getPixels(Raster var1, int var2, int var3, int var4, int var5, int var6);
    }

    private final class FloatWindow
    extends Window<FloatBuffer> {
        private final float[] data;
        private final float[] transfer;

        FloatWindow(float[] fArray, float[] fArray2) {
            super(FloatBuffer.wrap(fArray).asReadOnlyBuffer());
            this.data = fArray;
            this.transfer = fArray2;
        }

        @Override
        final PixelIterator owner() {
            return PixelIterator.this;
        }

        @Override
        Object getPixels(Raster raster, int n, int n2, int n3, int n4, int n5) {
            return raster.getPixels(n, n2, n3, n4, n5 == 0 ? this.data : this.transfer);
        }

        @Override
        public void update() {
            ((FloatBuffer)this.values).clear();
            PixelIterator.this.fetchValues(this, this.data);
        }
    }

    private final class DoubleWindow
    extends Window<DoubleBuffer> {
        private final double[] data;
        private final double[] transfer;

        DoubleWindow(double[] dArray, double[] dArray2) {
            super(DoubleBuffer.wrap(dArray).asReadOnlyBuffer());
            this.data = dArray;
            this.transfer = dArray2;
        }

        @Override
        final PixelIterator owner() {
            return PixelIterator.this;
        }

        @Override
        Object getPixels(Raster raster, int n, int n2, int n3, int n4, int n5) {
            return raster.getPixels(n, n2, n3, n4, n5 == 0 ? this.data : this.transfer);
        }

        @Override
        public void update() {
            ((DoubleBuffer)this.values).clear();
            PixelIterator.this.fetchValues(this, this.data);
        }
    }
}

