/*
 * Decompiled with CFR 0.152.
 */
package org.itadaki.bzip2;

public class BZip2DivSufSort {
    private static final int STACK_SIZE = 64;
    private static final int BUCKET_A_SIZE = 256;
    private static final int BUCKET_B_SIZE = 65536;
    private static final int SS_BLOCKSIZE = 1024;
    private static final int INSERTIONSORT_THRESHOLD = 8;
    private static final int[] log2table = new int[]{-1, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private final int[] SA;
    private final byte[] T;
    private final int n;

    private static final void swapElements(int[] array1, int index1, int[] array2, int index2) {
        int temp = array1[index1];
        array1[index1] = array2[index2];
        array2[index2] = temp;
    }

    private int ssCompare(int p1, int p2, int depth) {
        int U2;
        int[] SA = this.SA;
        byte[] T = this.T;
        int U1 = depth + SA[p1];
        int U1n = SA[p1 + 1] + 2;
        int U2n = SA[p2 + 1] + 2;
        for (U2 = depth + SA[p2]; U1 < U1n && U2 < U2n && T[U1] == T[U2]; ++U1, ++U2) {
        }
        return U1 < U1n ? (U2 < U2n ? (T[U1] & 0xFF) - (T[U2] & 0xFF) : 1) : (U2 < U2n ? -1 : 0);
    }

    private int ssCompareLast(int PA, int p1, int p2, int depth, int size) {
        int U2;
        int[] SA = this.SA;
        byte[] T = this.T;
        int U1 = depth + SA[p1];
        int U1n = size;
        int U2n = SA[p2 + 1] + 2;
        for (U2 = depth + SA[p2]; U1 < U1n && U2 < U2n && T[U1] == T[U2]; ++U1, ++U2) {
        }
        if (U1 < U1n) {
            return U2 < U2n ? (T[U1] & 0xFF) - (T[U2] & 0xFF) : 1;
        }
        if (U2 == U2n) {
            return 1;
        }
        U1 %= size;
        U1n = SA[PA] + 2;
        while (U1 < U1n && U2 < U2n && T[U1] == T[U2]) {
            ++U1;
            ++U2;
        }
        return U1 < U1n ? (U2 < U2n ? (T[U1] & 0xFF) - (T[U2] & 0xFF) : 1) : (U2 < U2n ? -1 : 0);
    }

    private void ssInsertionSort(int PA, int first, int last, int depth) {
        int[] SA = this.SA;
        for (int i = last - 2; first <= i; --i) {
            int r;
            int t = SA[i];
            int j = i + 1;
            while (0 < (r = this.ssCompare(PA + t, PA + SA[j], depth))) {
                do {
                    SA[j - 1] = SA[j];
                } while (++j < last && SA[j] < 0);
                if (last > j) continue;
            }
            if (r == 0) {
                SA[j] = ~SA[j];
            }
            SA[j - 1] = t;
        }
    }

    private void ssFixdown(int Td, int PA, int sa, int i, int size) {
        int j;
        int[] SA = this.SA;
        byte[] T = this.T;
        int v = SA[sa + i];
        int c = T[Td + SA[PA + v]] & 0xFF;
        while ((j = 2 * i + 1) < size) {
            int e;
            int k;
            int d;
            if ((d = T[Td + SA[PA + SA[sa + (k = j++)]]] & 0xFF) < (e = T[Td + SA[PA + SA[sa + j]]] & 0xFF)) {
                k = j;
                d = e;
            }
            if (d <= c) break;
            SA[sa + i] = SA[sa + k];
            i = k;
        }
        SA[sa + i] = v;
    }

    private void ssHeapSort(int Td, int PA, int sa, int size) {
        int i;
        int[] SA = this.SA;
        byte[] T = this.T;
        int m = size;
        if (size % 2 == 0 && (T[Td + SA[PA + SA[sa + --m / 2]]] & 0xFF) < (T[Td + SA[PA + SA[sa + m]]] & 0xFF)) {
            BZip2DivSufSort.swapElements(SA, sa + m, SA, sa + m / 2);
        }
        for (i = m / 2 - 1; 0 <= i; --i) {
            this.ssFixdown(Td, PA, sa, i, m);
        }
        if (size % 2 == 0) {
            BZip2DivSufSort.swapElements(SA, sa, SA, sa + m);
            this.ssFixdown(Td, PA, sa, 0, m);
        }
        for (i = m - 1; 0 < i; --i) {
            int t = SA[sa];
            SA[sa] = SA[sa + i];
            this.ssFixdown(Td, PA, sa, 0, i);
            SA[sa + i] = t;
        }
    }

    private int ssMedian3(int Td, int PA, int v1, int v2, int v3) {
        int[] SA = this.SA;
        byte[] T = this.T;
        int T_v1 = T[Td + SA[PA + SA[v1]]] & 0xFF;
        int T_v2 = T[Td + SA[PA + SA[v2]]] & 0xFF;
        int T_v3 = T[Td + SA[PA + SA[v3]]] & 0xFF;
        if (T_v1 > T_v2) {
            int temp = v1;
            v1 = v2;
            v2 = temp;
            int T_vtemp = T_v1;
            T_v1 = T_v2;
            T_v2 = T_vtemp;
        }
        if (T_v2 > T_v3) {
            if (T_v1 > T_v3) {
                return v1;
            }
            return v3;
        }
        return v2;
    }

    private int ssMedian5(int Td, int PA, int v1, int v2, int v3, int v4, int v5) {
        int T_vtemp;
        int temp;
        int[] SA = this.SA;
        byte[] T = this.T;
        int T_v1 = T[Td + SA[PA + SA[v1]]] & 0xFF;
        int T_v2 = T[Td + SA[PA + SA[v2]]] & 0xFF;
        int T_v3 = T[Td + SA[PA + SA[v3]]] & 0xFF;
        int T_v4 = T[Td + SA[PA + SA[v4]]] & 0xFF;
        int T_v5 = T[Td + SA[PA + SA[v5]]] & 0xFF;
        if (T_v2 > T_v3) {
            temp = v2;
            v2 = v3;
            v3 = temp;
            T_vtemp = T_v2;
            T_v2 = T_v3;
            T_v3 = T_vtemp;
        }
        if (T_v4 > T_v5) {
            temp = v4;
            v4 = v5;
            v5 = temp;
            T_vtemp = T_v4;
            T_v4 = T_v5;
            T_v5 = T_vtemp;
        }
        if (T_v2 > T_v4) {
            temp = v2;
            v2 = v4;
            v4 = temp;
            T_vtemp = T_v2;
            T_v2 = T_v4;
            T_v4 = T_vtemp;
            temp = v3;
            v3 = v5;
            v5 = temp;
            T_vtemp = T_v3;
            T_v3 = T_v5;
            T_v5 = T_vtemp;
        }
        if (T_v1 > T_v3) {
            temp = v1;
            v1 = v3;
            v3 = temp;
            T_vtemp = T_v1;
            T_v1 = T_v3;
            T_v3 = T_vtemp;
        }
        if (T_v1 > T_v4) {
            temp = v1;
            v1 = v4;
            v4 = temp;
            T_vtemp = T_v1;
            T_v1 = T_v4;
            T_v4 = T_vtemp;
            temp = v3;
            v3 = v5;
            v5 = temp;
            T_vtemp = T_v3;
            T_v3 = T_v5;
            T_v5 = T_vtemp;
        }
        if (T_v3 > T_v4) {
            return v4;
        }
        return v3;
    }

    private int ssPivot(int Td, int PA, int first, int last) {
        int t = last - first;
        int middle = first + t / 2;
        if (t <= 512) {
            if (t <= 32) {
                return this.ssMedian3(Td, PA, first, middle, last - 1);
            }
            return this.ssMedian5(Td, PA, first, first + (t >>= 2), middle, last - 1 - t, last - 1);
        }
        return this.ssMedian3(Td, PA, this.ssMedian3(Td, PA, first, first + (t >>= 3), first + (t << 1)), this.ssMedian3(Td, PA, middle - t, middle, middle + t), this.ssMedian3(Td, PA, last - 1 - (t << 1), last - 1 - t, last - 1));
    }

    private int ssLog(int n) {
        return (n & 0xFF00) != 0 ? 8 + log2table[n >> 8 & 0xFF] : log2table[n & 0xFF];
    }

    private int ssSubstringPartition(int PA, int first, int last, int depth) {
        int[] SA = this.SA;
        int a = first - 1;
        int b = last;
        while (true) {
            if (++a < b && SA[PA + SA[a]] + depth >= SA[PA + SA[a] + 1] + 1) {
                SA[a] = ~SA[a];
                continue;
            }
            while (a < --b && SA[PA + SA[b]] + depth < SA[PA + SA[b] + 1] + 1) {
            }
            if (b <= a) break;
            int t = ~SA[b];
            SA[b] = SA[a];
            SA[a] = t;
        }
        if (first < a) {
            SA[first] = ~SA[first];
        }
        return a;
    }

    private void ssMultiKeyIntroSort(int PA, int first, int last, int depth) {
        int[] SA = this.SA;
        byte[] T = this.T;
        StackEntry[] stack = new StackEntry[64];
        int Td = 0;
        int a = 0;
        int b = 0;
        int c = 0;
        int d = 0;
        int e = 0;
        int f = 0;
        int s = 0;
        int t = 0;
        int v = 0;
        int x = 0;
        int ssize = 0;
        int limit = this.ssLog(last - first);
        while (true) {
            if (last - first <= 8) {
                if (1 < last - first) {
                    this.ssInsertionSort(PA, first, last, depth);
                }
                if (ssize == 0) {
                    return;
                }
                StackEntry entry = stack[--ssize];
                first = entry.a;
                last = entry.b;
                depth = entry.c;
                limit = entry.d;
                continue;
            }
            Td = depth;
            if (limit-- == 0) {
                this.ssHeapSort(Td, PA, first, last - first);
            }
            if (limit < 0) {
                v = T[Td + SA[PA + SA[first]]] & 0xFF;
                for (a = first + 1; a < last; ++a) {
                    x = T[Td + SA[PA + SA[a]]] & 0xFF;
                    if (x == v) continue;
                    if (1 < a - first) break;
                    v = x;
                    first = a;
                }
                if ((T[Td + SA[PA + SA[first]] - 1] & 0xFF) < v) {
                    first = this.ssSubstringPartition(PA, first, a, depth);
                }
                if (a - first <= last - a) {
                    if (1 < a - first) {
                        stack[ssize++] = new StackEntry(a, last, depth, -1);
                        last = a;
                        ++depth;
                        limit = this.ssLog(a - first);
                        continue;
                    }
                    first = a;
                    limit = -1;
                    continue;
                }
                if (1 < last - a) {
                    stack[ssize++] = new StackEntry(first, a, depth + 1, this.ssLog(a - first));
                    first = a;
                    limit = -1;
                    continue;
                }
                last = a;
                ++depth;
                limit = this.ssLog(a - first);
                continue;
            }
            a = this.ssPivot(Td, PA, first, last);
            v = T[Td + SA[PA + SA[a]]] & 0xFF;
            BZip2DivSufSort.swapElements(SA, first, SA, a);
            b = first;
            while (++b < last && (x = T[Td + SA[PA + SA[b]]] & 0xFF) == v) {
            }
            a = b;
            if (a < last && x < v) {
                while (++b < last && (x = T[Td + SA[PA + SA[b]]] & 0xFF) <= v) {
                    if (x != v) continue;
                    BZip2DivSufSort.swapElements(SA, b, SA, a);
                    ++a;
                }
            }
            c = last;
            while (b < --c && (x = T[Td + SA[PA + SA[c]]] & 0xFF) == v) {
            }
            d = c;
            if (b < d && x > v) {
                while (b < --c && (x = T[Td + SA[PA + SA[c]]] & 0xFF) >= v) {
                    if (x != v) continue;
                    BZip2DivSufSort.swapElements(SA, c, SA, d);
                    --d;
                }
            }
            while (b < c) {
                BZip2DivSufSort.swapElements(SA, b, SA, c);
                while (++b < c && (x = T[Td + SA[PA + SA[b]]] & 0xFF) <= v) {
                    if (x != v) continue;
                    BZip2DivSufSort.swapElements(SA, b, SA, a);
                    ++a;
                }
                while (b < --c && (x = T[Td + SA[PA + SA[c]]] & 0xFF) >= v) {
                    if (x != v) continue;
                    BZip2DivSufSort.swapElements(SA, c, SA, d);
                    --d;
                }
            }
            if (a <= d) {
                c = b - 1;
                s = a - first;
                t = b - a;
                if (s > t) {
                    s = t;
                }
                e = first;
                f = b - s;
                while (0 < s) {
                    BZip2DivSufSort.swapElements(SA, e, SA, f);
                    --s;
                    ++e;
                    ++f;
                }
                s = d - c;
                t = last - d - 1;
                if (s > t) {
                    s = t;
                }
                e = b;
                f = last - s;
                while (0 < s) {
                    BZip2DivSufSort.swapElements(SA, e, SA, f);
                    --s;
                    ++e;
                    ++f;
                }
                a = first + (b - a);
                c = last - (d - c);
                int n = b = v <= (T[Td + SA[PA + SA[a]] - 1] & 0xFF) ? a : this.ssSubstringPartition(PA, a, c, depth);
                if (a - first <= last - c) {
                    if (last - c <= c - b) {
                        stack[ssize++] = new StackEntry(b, c, depth + 1, this.ssLog(c - b));
                        stack[ssize++] = new StackEntry(c, last, depth, limit);
                        last = a;
                        continue;
                    }
                    if (a - first <= c - b) {
                        stack[ssize++] = new StackEntry(c, last, depth, limit);
                        stack[ssize++] = new StackEntry(b, c, depth + 1, this.ssLog(c - b));
                        last = a;
                        continue;
                    }
                    stack[ssize++] = new StackEntry(c, last, depth, limit);
                    stack[ssize++] = new StackEntry(first, a, depth, limit);
                    first = b;
                    last = c;
                    ++depth;
                    limit = this.ssLog(c - b);
                    continue;
                }
                if (a - first <= c - b) {
                    stack[ssize++] = new StackEntry(b, c, depth + 1, this.ssLog(c - b));
                    stack[ssize++] = new StackEntry(first, a, depth, limit);
                    first = c;
                    continue;
                }
                if (last - c <= c - b) {
                    stack[ssize++] = new StackEntry(first, a, depth, limit);
                    stack[ssize++] = new StackEntry(b, c, depth + 1, this.ssLog(c - b));
                    first = c;
                    continue;
                }
                stack[ssize++] = new StackEntry(first, a, depth, limit);
                stack[ssize++] = new StackEntry(c, last, depth, limit);
                first = b;
                last = c;
                ++depth;
                limit = this.ssLog(c - b);
                continue;
            }
            ++limit;
            if ((T[Td + SA[PA + SA[first]] - 1] & 0xFF) < v) {
                first = this.ssSubstringPartition(PA, first, last, depth);
                limit = this.ssLog(last - first);
            }
            ++depth;
        }
    }

    private void ssBlockSwap(int[] array1, int first1, int[] array2, int first2, int size) {
        int i = size;
        int a = first1;
        int b = first2;
        while (0 < i) {
            BZip2DivSufSort.swapElements(array1, a, array2, b);
            --i;
            ++a;
            ++b;
        }
    }

    private void ssMergeForward(int PA, int[] buf, int bufoffset, int first, int middle, int last, int depth) {
        int[] SA = this.SA;
        int bufend = bufoffset + (middle - first) - 1;
        this.ssBlockSwap(buf, bufoffset, SA, first, middle - first);
        int t = SA[first];
        int i = first;
        int j = bufoffset;
        int k = middle;
        while (true) {
            int r;
            if ((r = this.ssCompare(PA + buf[j], PA + SA[k], depth)) < 0) {
                do {
                    SA[i++] = buf[j];
                    if (bufend <= j) {
                        buf[j] = t;
                        return;
                    }
                    buf[j++] = SA[i];
                } while (buf[j] < 0);
                continue;
            }
            if (r > 0) {
                do {
                    SA[i++] = SA[k];
                    SA[k++] = SA[i];
                    if (last > k) continue;
                    while (j < bufend) {
                        SA[i++] = buf[j];
                        buf[j++] = SA[i];
                    }
                    SA[i] = buf[j];
                    buf[j] = t;
                    return;
                } while (SA[k] < 0);
                continue;
            }
            SA[k] = ~SA[k];
            do {
                SA[i++] = buf[j];
                if (bufend <= j) {
                    buf[j] = t;
                    return;
                }
                buf[j++] = SA[i];
            } while (buf[j] < 0);
            do {
                SA[i++] = SA[k];
                SA[k++] = SA[i];
                if (last > k) continue;
                while (j < bufend) {
                    SA[i++] = buf[j];
                    buf[j++] = SA[i];
                }
                SA[i] = buf[j];
                buf[j] = t;
                return;
            } while (SA[k] < 0);
        }
    }

    private void ssMergeBackward(int PA, int[] buf, int bufoffset, int first, int middle, int last, int depth) {
        int p2;
        int p1;
        int[] SA = this.SA;
        int bufend = bufoffset + (last - middle);
        this.ssBlockSwap(buf, bufoffset, SA, middle, last - middle);
        int x = 0;
        if (buf[bufend - 1] < 0) {
            x |= 1;
            p1 = PA + ~buf[bufend - 1];
        } else {
            p1 = PA + buf[bufend - 1];
        }
        if (SA[middle - 1] < 0) {
            x |= 2;
            p2 = PA + ~SA[middle - 1];
        } else {
            p2 = PA + SA[middle - 1];
        }
        int t = SA[last - 1];
        int i = last - 1;
        int j = bufend - 1;
        int k = middle - 1;
        while (true) {
            int r;
            if ((r = this.ssCompare(p1, p2, depth)) > 0) {
                if ((x & 1) != 0) {
                    do {
                        SA[i--] = buf[j];
                        buf[j--] = SA[i];
                    } while (buf[j] < 0);
                    x ^= 1;
                }
                SA[i--] = buf[j];
                if (j <= bufoffset) {
                    buf[j] = t;
                    return;
                }
                buf[j--] = SA[i];
                if (buf[j] < 0) {
                    x |= 1;
                    p1 = PA + ~buf[j];
                    continue;
                }
                p1 = PA + buf[j];
                continue;
            }
            if (r < 0) {
                if ((x & 2) != 0) {
                    do {
                        SA[i--] = SA[k];
                        SA[k--] = SA[i];
                    } while (SA[k] < 0);
                    x ^= 2;
                }
                SA[i--] = SA[k];
                SA[k--] = SA[i];
                if (k < first) {
                    while (bufoffset < j) {
                        SA[i--] = buf[j];
                        buf[j--] = SA[i];
                    }
                    SA[i] = buf[j];
                    buf[j] = t;
                    return;
                }
                if (SA[k] < 0) {
                    x |= 2;
                    p2 = PA + ~SA[k];
                    continue;
                }
                p2 = PA + SA[k];
                continue;
            }
            if ((x & 1) != 0) {
                do {
                    SA[i--] = buf[j];
                    buf[j--] = SA[i];
                } while (buf[j] < 0);
                x ^= 1;
            }
            SA[i--] = ~buf[j];
            if (j <= bufoffset) {
                buf[j] = t;
                return;
            }
            buf[j--] = SA[i];
            if ((x & 2) != 0) {
                do {
                    SA[i--] = SA[k];
                    SA[k--] = SA[i];
                } while (SA[k] < 0);
                x ^= 2;
            }
            SA[i--] = SA[k];
            SA[k--] = SA[i];
            if (k < first) {
                while (bufoffset < j) {
                    SA[i--] = buf[j];
                    buf[j--] = SA[i];
                }
                SA[i] = buf[j];
                buf[j] = t;
                return;
            }
            if (buf[j] < 0) {
                x |= 1;
                p1 = PA + ~buf[j];
            } else {
                p1 = PA + buf[j];
            }
            if (SA[k] < 0) {
                x |= 2;
                p2 = PA + ~SA[k];
                continue;
            }
            p2 = PA + SA[k];
        }
    }

    private static final int getIDX(int a) {
        return 0 <= a ? a : ~a;
    }

    private void ssMergeCheckEqual(int PA, int depth, int a) {
        int[] SA = this.SA;
        if (0 <= SA[a] && this.ssCompare(PA + BZip2DivSufSort.getIDX(SA[a - 1]), PA + SA[a], depth) == 0) {
            SA[a] = ~SA[a];
        }
    }

    private void ssMerge(int PA, int first, int middle, int last, int[] buf, int bufoffset, int bufsize, int depth) {
        int[] SA = this.SA;
        StackEntry[] stack = new StackEntry[64];
        int check = 0;
        int ssize = 0;
        while (true) {
            StackEntry entry;
            if (last - middle <= bufsize) {
                if (first < middle && middle < last) {
                    this.ssMergeBackward(PA, buf, bufoffset, first, middle, last, depth);
                }
                if (check & true) {
                    this.ssMergeCheckEqual(PA, depth, first);
                }
                if ((check & 2) != 0) {
                    this.ssMergeCheckEqual(PA, depth, last);
                }
                if (ssize == 0) {
                    return;
                }
                entry = stack[--ssize];
                first = entry.a;
                middle = entry.b;
                last = entry.c;
                check = entry.d;
                continue;
            }
            if (middle - first <= bufsize) {
                if (first < middle) {
                    this.ssMergeForward(PA, buf, bufoffset, first, middle, last, depth);
                }
                if ((check & 1) != 0) {
                    this.ssMergeCheckEqual(PA, depth, first);
                }
                if ((check & 2) != 0) {
                    this.ssMergeCheckEqual(PA, depth, last);
                }
                if (ssize == 0) {
                    return;
                }
                entry = stack[--ssize];
                first = entry.a;
                middle = entry.b;
                last = entry.c;
                check = entry.d;
                continue;
            }
            int m = 0;
            int len = Math.min(middle - first, last - middle);
            int half = len >> 1;
            while (0 < len) {
                if (this.ssCompare(PA + BZip2DivSufSort.getIDX(SA[middle + m + half]), PA + BZip2DivSufSort.getIDX(SA[middle - m - half - 1]), depth) < 0) {
                    m += half + 1;
                    half -= len & 1 ^ 1;
                }
                len = half;
                half >>= 1;
            }
            if (0 < m) {
                int j;
                this.ssBlockSwap(SA, middle - m, SA, middle, m);
                int i = j = middle;
                int next = 0;
                if (middle + m < last) {
                    if (SA[middle + m] < 0) {
                        while (SA[i - 1] < 0) {
                            --i;
                        }
                        SA[middle + m] = ~SA[middle + m];
                    }
                    j = middle;
                    while (SA[j] < 0) {
                        ++j;
                    }
                    next = 1;
                }
                if (i - first <= last - j) {
                    stack[ssize++] = new StackEntry(j, middle + m, last, check & 2 | next & 1);
                    middle -= m;
                    last = i;
                    check &= 1;
                    continue;
                }
                if (i == middle && middle == j) {
                    next <<= 1;
                }
                stack[ssize++] = new StackEntry(first, middle - m, i, check & 1 | next & 2);
                first = j;
                middle += m;
                check = check & 2 | next & 1;
                continue;
            }
            if ((check & 1) != 0) {
                this.ssMergeCheckEqual(PA, depth, first);
            }
            this.ssMergeCheckEqual(PA, depth, middle);
            if ((check & 2) != 0) {
                this.ssMergeCheckEqual(PA, depth, last);
            }
            if (ssize == 0) {
                return;
            }
            entry = stack[--ssize];
            first = entry.a;
            middle = entry.b;
            last = entry.c;
            check = entry.d;
        }
    }

    private void subStringSort(int PA, int first, int last, int[] buf, int bufoffset, int bufsize, int depth, boolean lastsuffix, int size) {
        int k;
        int[] SA = this.SA;
        if (lastsuffix) {
            ++first;
        }
        int a = first;
        int i = 0;
        while (a + 1024 < last) {
            this.ssMultiKeyIntroSort(PA, a, a + 1024, depth);
            int[] curbuf = SA;
            int curbufoffset = a + 1024;
            int curbufsize = last - (a + 1024);
            if (curbufsize <= bufsize) {
                curbufsize = bufsize;
                curbuf = buf;
                curbufoffset = bufoffset;
            }
            int b = a;
            k = 1024;
            int j = i;
            while ((j & 1) != 0) {
                this.ssMerge(PA, b - k, b, b + k, curbuf, curbufoffset, curbufsize, depth);
                b -= k;
                k <<= 1;
                j >>>= 1;
            }
            a += 1024;
            ++i;
        }
        this.ssMultiKeyIntroSort(PA, a, last, depth);
        k = 1024;
        while (i != 0) {
            if (i & true) {
                this.ssMerge(PA, a - k, a, last, buf, bufoffset, bufsize, depth);
                a -= k;
            }
            k <<= 1;
            i >>= 1;
        }
        if (lastsuffix) {
            i = SA[first - 1];
            int r = 1;
            for (a = first; a < last && (SA[a] < 0 || 0 < (r = this.ssCompareLast(PA, PA + i, PA + SA[a], depth, size))); ++a) {
                SA[a - 1] = SA[a];
            }
            if (r == 0) {
                SA[a] = ~SA[a];
            }
            SA[a - 1] = i;
        }
    }

    private int trGetC(int ISA, int ISAd, int ISAn, int p) {
        return ISAd + p < ISAn ? this.SA[ISAd + p] : this.SA[ISA + (ISAd - ISA + p) % (ISAn - ISA)];
    }

    private void trFixdown(int ISA, int ISAd, int ISAn, int sa, int i, int size) {
        int j;
        int[] SA = this.SA;
        int v = SA[sa + i];
        int c = this.trGetC(ISA, ISAd, ISAn, v);
        while ((j = 2 * i + 1) < size) {
            int e;
            int k;
            int d;
            if ((d = this.trGetC(ISA, ISAd, ISAn, SA[sa + (k = j++)])) < (e = this.trGetC(ISA, ISAd, ISAn, SA[sa + j]))) {
                k = j;
                d = e;
            }
            if (d <= c) break;
            SA[sa + i] = SA[sa + k];
            i = k;
        }
        SA[sa + i] = v;
    }

    private void trHeapSort(int ISA, int ISAd, int ISAn, int sa, int size) {
        int i;
        int[] SA = this.SA;
        int m = size;
        if (size % 2 == 0 && this.trGetC(ISA, ISAd, ISAn, SA[sa + --m / 2]) < this.trGetC(ISA, ISAd, ISAn, SA[sa + m])) {
            BZip2DivSufSort.swapElements(SA, sa + m, SA, sa + m / 2);
        }
        for (i = m / 2 - 1; 0 <= i; --i) {
            this.trFixdown(ISA, ISAd, ISAn, sa, i, m);
        }
        if (size % 2 == 0) {
            BZip2DivSufSort.swapElements(SA, sa + 0, SA, sa + m);
            this.trFixdown(ISA, ISAd, ISAn, sa, 0, m);
        }
        for (i = m - 1; 0 < i; --i) {
            int t = SA[sa + 0];
            SA[sa + 0] = SA[sa + i];
            this.trFixdown(ISA, ISAd, ISAn, sa, 0, i);
            SA[sa + i] = t;
        }
    }

    private void trInsertionSort(int ISA, int ISAd, int ISAn, int first, int last) {
        int[] SA = this.SA;
        for (int a = first + 1; a < last; ++a) {
            int r;
            int t = SA[a];
            int b = a - 1;
            while (0 > (r = this.trGetC(ISA, ISAd, ISAn, t) - this.trGetC(ISA, ISAd, ISAn, SA[b]))) {
                do {
                    SA[b + 1] = SA[b];
                } while (first <= --b && SA[b] < 0);
                if (b >= first) continue;
            }
            if (r == 0) {
                SA[b] = ~SA[b];
            }
            SA[b + 1] = t;
        }
    }

    private int trLog(int n) {
        return (n & 0xFFFF0000) != 0 ? ((n & 0xFF000000) != 0 ? 24 + log2table[n >> 24 & 0xFF] : 16 + log2table[n >> 16 & 0xFF]) : ((n & 0xFF00) != 0 ? 8 + log2table[n >> 8 & 0xFF] : 0 + log2table[n >> 0 & 0xFF]);
    }

    private int trMedian3(int ISA, int ISAd, int ISAn, int v1, int v2, int v3) {
        int[] SA = this.SA;
        int SA_v1 = this.trGetC(ISA, ISAd, ISAn, SA[v1]);
        int SA_v2 = this.trGetC(ISA, ISAd, ISAn, SA[v2]);
        int SA_v3 = this.trGetC(ISA, ISAd, ISAn, SA[v3]);
        if (SA_v1 > SA_v2) {
            int temp = v1;
            v1 = v2;
            v2 = temp;
            int SA_vtemp = SA_v1;
            SA_v1 = SA_v2;
            SA_v2 = SA_vtemp;
        }
        if (SA_v2 > SA_v3) {
            if (SA_v1 > SA_v3) {
                return v1;
            }
            return v3;
        }
        return v2;
    }

    private int trMedian5(int ISA, int ISAd, int ISAn, int v1, int v2, int v3, int v4, int v5) {
        int SA_vtemp;
        int temp;
        int[] SA = this.SA;
        int SA_v1 = this.trGetC(ISA, ISAd, ISAn, SA[v1]);
        int SA_v2 = this.trGetC(ISA, ISAd, ISAn, SA[v2]);
        int SA_v3 = this.trGetC(ISA, ISAd, ISAn, SA[v3]);
        int SA_v4 = this.trGetC(ISA, ISAd, ISAn, SA[v4]);
        int SA_v5 = this.trGetC(ISA, ISAd, ISAn, SA[v5]);
        if (SA_v2 > SA_v3) {
            temp = v2;
            v2 = v3;
            v3 = temp;
            SA_vtemp = SA_v2;
            SA_v2 = SA_v3;
            SA_v3 = SA_vtemp;
        }
        if (SA_v4 > SA_v5) {
            temp = v4;
            v4 = v5;
            v5 = temp;
            SA_vtemp = SA_v4;
            SA_v4 = SA_v5;
            SA_v5 = SA_vtemp;
        }
        if (SA_v2 > SA_v4) {
            temp = v2;
            v2 = v4;
            v4 = temp;
            SA_vtemp = SA_v2;
            SA_v2 = SA_v4;
            SA_v4 = SA_vtemp;
            temp = v3;
            v3 = v5;
            v5 = temp;
            SA_vtemp = SA_v3;
            SA_v3 = SA_v5;
            SA_v5 = SA_vtemp;
        }
        if (SA_v1 > SA_v3) {
            temp = v1;
            v1 = v3;
            v3 = temp;
            SA_vtemp = SA_v1;
            SA_v1 = SA_v3;
            SA_v3 = SA_vtemp;
        }
        if (SA_v1 > SA_v4) {
            temp = v1;
            v1 = v4;
            v4 = temp;
            SA_vtemp = SA_v1;
            SA_v1 = SA_v4;
            SA_v4 = SA_vtemp;
            temp = v3;
            v3 = v5;
            v5 = temp;
            SA_vtemp = SA_v3;
            SA_v3 = SA_v5;
            SA_v5 = SA_vtemp;
        }
        if (SA_v3 > SA_v4) {
            return v4;
        }
        return v3;
    }

    private int trPivot(int ISA, int ISAd, int ISAn, int first, int last) {
        int t = last - first;
        int middle = first + t / 2;
        if (t <= 512) {
            if (t <= 32) {
                return this.trMedian3(ISA, ISAd, ISAn, first, middle, last - 1);
            }
            return this.trMedian5(ISA, ISAd, ISAn, first, first + (t >>= 2), middle, last - 1 - t, last - 1);
        }
        return this.trMedian3(ISA, ISAd, ISAn, this.trMedian3(ISA, ISAd, ISAn, first, first + (t >>= 3), first + (t << 1)), this.trMedian3(ISA, ISAd, ISAn, middle - t, middle, middle + t), this.trMedian3(ISA, ISAd, ISAn, last - 1 - (t << 1), last - 1 - t, last - 1));
    }

    private void lsUpdateGroup(int ISA, int first, int last) {
        int[] SA = this.SA;
        for (int a = first; a < last; ++a) {
            int b;
            if (0 <= SA[a]) {
                b = a;
                do {
                    SA[ISA + SA[a]] = a;
                } while (++a < last && 0 <= SA[a]);
                SA[b] = b - a;
                if (last <= a) break;
            }
            b = a;
            do {
                SA[a] = ~SA[a];
            } while (SA[++a] < 0);
            int t = a;
            do {
                SA[ISA + SA[b]] = t;
            } while (++b <= a);
        }
    }

    private void lsIntroSort(int ISA, int ISAd, int ISAn, int first, int last) {
        int[] SA = this.SA;
        StackEntry[] stack = new StackEntry[64];
        int x = 0;
        int ssize = 0;
        int limit = this.trLog(last - first);
        while (true) {
            int b;
            int a;
            StackEntry entry;
            if (last - first <= 8) {
                if (1 < last - first) {
                    this.trInsertionSort(ISA, ISAd, ISAn, first, last);
                    this.lsUpdateGroup(ISA, first, last);
                } else if (last - first == 1) {
                    SA[first] = -1;
                }
                if (ssize == 0) {
                    return;
                }
                entry = stack[--ssize];
                first = entry.a;
                last = entry.b;
                limit = entry.c;
                continue;
            }
            if (limit-- == 0) {
                this.trHeapSort(ISA, ISAd, ISAn, first, last - first);
                a = last - 1;
                while (first < a) {
                    x = this.trGetC(ISA, ISAd, ISAn, SA[a]);
                    for (b = a - 1; first <= b && this.trGetC(ISA, ISAd, ISAn, SA[b]) == x; --b) {
                        SA[b] = ~SA[b];
                    }
                    a = b;
                }
                this.lsUpdateGroup(ISA, first, last);
                if (ssize == 0) {
                    return;
                }
                entry = stack[--ssize];
                first = entry.a;
                last = entry.b;
                limit = entry.c;
                continue;
            }
            a = this.trPivot(ISA, ISAd, ISAn, first, last);
            BZip2DivSufSort.swapElements(SA, first, SA, a);
            int v = this.trGetC(ISA, ISAd, ISAn, SA[first]);
            b = first;
            while (++b < last && (x = this.trGetC(ISA, ISAd, ISAn, SA[b])) == v) {
            }
            a = b;
            if (a < last && x < v) {
                while (++b < last && (x = this.trGetC(ISA, ISAd, ISAn, SA[b])) <= v) {
                    if (x != v) continue;
                    BZip2DivSufSort.swapElements(SA, b, SA, a);
                    ++a;
                }
            }
            int c = last;
            while (b < --c && (x = this.trGetC(ISA, ISAd, ISAn, SA[c])) == v) {
            }
            int d = c;
            if (b < d && x > v) {
                while (b < --c && (x = this.trGetC(ISA, ISAd, ISAn, SA[c])) >= v) {
                    if (x != v) continue;
                    BZip2DivSufSort.swapElements(SA, c, SA, d);
                    --d;
                }
            }
            while (b < c) {
                BZip2DivSufSort.swapElements(SA, b, SA, c);
                while (++b < c && (x = this.trGetC(ISA, ISAd, ISAn, SA[b])) <= v) {
                    if (x != v) continue;
                    BZip2DivSufSort.swapElements(SA, b, SA, a);
                    ++a;
                }
                while (b < --c && (x = this.trGetC(ISA, ISAd, ISAn, SA[c])) >= v) {
                    if (x != v) continue;
                    BZip2DivSufSort.swapElements(SA, c, SA, d);
                    --d;
                }
            }
            if (a <= d) {
                c = b - 1;
                int s = a - first;
                int t = b - a;
                if (s > t) {
                    s = t;
                }
                int e = first;
                int f = b - s;
                while (0 < s) {
                    BZip2DivSufSort.swapElements(SA, e, SA, f);
                    --s;
                    ++e;
                    ++f;
                }
                s = d - c;
                t = last - d - 1;
                if (s > t) {
                    s = t;
                }
                e = b;
                f = last - s;
                while (0 < s) {
                    BZip2DivSufSort.swapElements(SA, e, SA, f);
                    --s;
                    ++e;
                    ++f;
                }
                a = first + (b - a);
                b = last - (d - c);
                v = a - 1;
                for (c = first; c < a; ++c) {
                    SA[ISA + SA[c]] = v;
                }
                if (b < last) {
                    v = b - 1;
                    for (c = a; c < b; ++c) {
                        SA[ISA + SA[c]] = v;
                    }
                }
                if (b - a == 1) {
                    SA[a] = -1;
                }
                if (a - first <= last - b) {
                    if (first < a) {
                        stack[ssize++] = new StackEntry(b, last, limit, 0);
                        last = a;
                        continue;
                    }
                    first = b;
                    continue;
                }
                if (b < last) {
                    stack[ssize++] = new StackEntry(first, a, limit, 0);
                    first = b;
                    continue;
                }
                last = a;
                continue;
            }
            if (ssize == 0) {
                return;
            }
            entry = stack[--ssize];
            first = entry.a;
            last = entry.b;
            limit = entry.c;
        }
    }

    private void lsSort(int ISA, int n, int depth) {
        int[] SA = this.SA;
        int ISAd = ISA + depth;
        while (-n < SA[0]) {
            int last;
            int t;
            int first = 0;
            int skip = 0;
            do {
                if ((t = SA[first]) < 0) {
                    first -= t;
                    skip += t;
                    continue;
                }
                if (skip != 0) {
                    SA[first + skip] = skip;
                    skip = 0;
                }
                last = SA[ISA + t] + 1;
                this.lsIntroSort(ISA, ISAd, ISA + n, first, last);
                first = last;
            } while (first < n);
            if (skip != 0) {
                SA[first + skip] = skip;
            }
            if (n < ISAd - ISA) {
                first = 0;
                do {
                    if ((t = SA[first]) < 0) {
                        first -= t;
                        continue;
                    }
                    last = SA[ISA + t] + 1;
                    for (int i = first; i < last; ++i) {
                        SA[ISA + SA[i]] = i;
                    }
                    first = last;
                } while (first < n);
                break;
            }
            ISAd += ISAd - ISA;
        }
    }

    private PartitionResult trPartition(int ISA, int ISAd, int ISAn, int first, int last, int v) {
        int[] SA = this.SA;
        int x = 0;
        int b = first - 1;
        while (++b < last && (x = this.trGetC(ISA, ISAd, ISAn, SA[b])) == v) {
        }
        int a = b;
        if (a < last && x < v) {
            while (++b < last && (x = this.trGetC(ISA, ISAd, ISAn, SA[b])) <= v) {
                if (x != v) continue;
                BZip2DivSufSort.swapElements(SA, b, SA, a);
                ++a;
            }
        }
        int c = last;
        while (b < --c && (x = this.trGetC(ISA, ISAd, ISAn, SA[c])) == v) {
        }
        int d = c;
        if (b < d && x > v) {
            while (b < --c && (x = this.trGetC(ISA, ISAd, ISAn, SA[c])) >= v) {
                if (x != v) continue;
                BZip2DivSufSort.swapElements(SA, c, SA, d);
                --d;
            }
        }
        while (b < c) {
            BZip2DivSufSort.swapElements(SA, b, SA, c);
            while (++b < c && (x = this.trGetC(ISA, ISAd, ISAn, SA[b])) <= v) {
                if (x != v) continue;
                BZip2DivSufSort.swapElements(SA, b, SA, a);
                ++a;
            }
            while (b < --c && (x = this.trGetC(ISA, ISAd, ISAn, SA[c])) >= v) {
                if (x != v) continue;
                BZip2DivSufSort.swapElements(SA, c, SA, d);
                --d;
            }
        }
        if (a <= d) {
            c = b - 1;
            int s = a - first;
            int t = b - a;
            if (s > t) {
                s = t;
            }
            int e = first;
            int f = b - s;
            while (0 < s) {
                BZip2DivSufSort.swapElements(SA, e, SA, f);
                --s;
                ++e;
                ++f;
            }
            s = d - c;
            t = last - d - 1;
            if (s > t) {
                s = t;
            }
            e = b;
            f = last - s;
            while (0 < s) {
                BZip2DivSufSort.swapElements(SA, e, SA, f);
                --s;
                ++e;
                ++f;
            }
            first += b - a;
            last -= d - c;
        }
        return new PartitionResult(first, last);
    }

    private void trCopy(int ISA, int ISAn, int first, int a, int b, int last, int depth) {
        int s;
        int c;
        int[] SA = this.SA;
        int v = b - 1;
        int d = a - 1;
        for (c = first; c <= d; ++c) {
            s = SA[c] - depth;
            if (s < 0) {
                s += ISAn - ISA;
            }
            if (SA[ISA + s] != v) continue;
            SA[++d] = s;
            SA[ISA + s] = d;
        }
        c = last - 1;
        int e = d + 1;
        d = b;
        while (e < d) {
            s = SA[c] - depth;
            if (s < 0) {
                s += ISAn - ISA;
            }
            if (SA[ISA + s] == v) {
                SA[--d] = s;
                SA[ISA + s] = d;
            }
            --c;
        }
    }

    private void trIntroSort(int ISA, int ISAd, int ISAn, int first, int last, TRBudget budget, int size) {
        int s;
        int[] SA = this.SA;
        StackEntry[] stack = new StackEntry[64];
        int x = 0;
        int ssize = 0;
        int limit = this.trLog(last - first);
        while (true) {
            int next;
            StackEntry entry;
            int c;
            int v;
            int b;
            int a;
            if (limit < 0) {
                if (limit == -1) {
                    StackEntry entry2;
                    if (!budget.update(size, last - first)) break;
                    PartitionResult result = this.trPartition(ISA, ISAd - 1, ISAn, first, last, last - 1);
                    a = result.first;
                    b = result.last;
                    if (first < a || b < last) {
                        if (a < last) {
                            v = a - 1;
                            for (c = first; c < a; ++c) {
                                SA[ISA + SA[c]] = v;
                            }
                        }
                        if (b < last) {
                            v = b - 1;
                            for (c = a; c < b; ++c) {
                                SA[ISA + SA[c]] = v;
                            }
                        }
                        stack[ssize++] = new StackEntry(0, a, b, 0);
                        stack[ssize++] = new StackEntry(ISAd - 1, first, last, -2);
                        if (a - first <= last - b) {
                            if (1 < a - first) {
                                stack[ssize++] = new StackEntry(ISAd, b, last, this.trLog(last - b));
                                last = a;
                                limit = this.trLog(a - first);
                                continue;
                            }
                            if (1 < last - b) {
                                first = b;
                                limit = this.trLog(last - b);
                                continue;
                            }
                            if (ssize == 0) {
                                return;
                            }
                            entry2 = stack[--ssize];
                            ISAd = entry2.a;
                            first = entry2.b;
                            last = entry2.c;
                            limit = entry2.d;
                            continue;
                        }
                        if (1 < last - b) {
                            stack[ssize++] = new StackEntry(ISAd, first, a, this.trLog(a - first));
                            first = b;
                            limit = this.trLog(last - b);
                            continue;
                        }
                        if (1 < a - first) {
                            last = a;
                            limit = this.trLog(a - first);
                            continue;
                        }
                        if (ssize == 0) {
                            return;
                        }
                        entry2 = stack[--ssize];
                        ISAd = entry2.a;
                        first = entry2.b;
                        last = entry2.c;
                        limit = entry2.d;
                        continue;
                    }
                    for (c = first; c < last; ++c) {
                        SA[ISA + SA[c]] = c;
                    }
                    if (ssize == 0) {
                        return;
                    }
                    entry2 = stack[--ssize];
                    ISAd = entry2.a;
                    first = entry2.b;
                    last = entry2.c;
                    limit = entry2.d;
                    continue;
                }
                if (limit == -2) {
                    a = stack[--ssize].b;
                    b = stack[ssize].c;
                    this.trCopy(ISA, ISAn, first, a, b, last, ISAd - ISA);
                    if (ssize == 0) {
                        return;
                    }
                    entry = stack[--ssize];
                    ISAd = entry.a;
                    first = entry.b;
                    last = entry.c;
                    limit = entry.d;
                    continue;
                }
                if (0 <= SA[first]) {
                    a = first;
                    do {
                        SA[ISA + SA[a]] = a;
                    } while (++a < last && 0 <= SA[a]);
                    first = a;
                }
                if (first < last) {
                    a = first;
                    do {
                        SA[a] = ~SA[a];
                    } while (SA[++a] < 0);
                    int n = next = SA[ISA + SA[a]] != SA[ISAd + SA[a]] ? this.trLog(a - first + 1) : -1;
                    if (++a < last) {
                        v = a - 1;
                        for (b = first; b < a; ++b) {
                            SA[ISA + SA[b]] = v;
                        }
                    }
                    if (a - first <= last - a) {
                        stack[ssize++] = new StackEntry(ISAd, a, last, -3);
                        ++ISAd;
                        last = a;
                        limit = next;
                        continue;
                    }
                    if (1 < last - a) {
                        stack[ssize++] = new StackEntry(ISAd + 1, first, a, next);
                        first = a;
                        limit = -3;
                        continue;
                    }
                    ++ISAd;
                    last = a;
                    limit = next;
                    continue;
                }
                if (ssize == 0) {
                    return;
                }
                entry = stack[--ssize];
                ISAd = entry.a;
                first = entry.b;
                last = entry.c;
                limit = entry.d;
                continue;
            }
            if (last - first <= 8) {
                if (!budget.update(size, last - first)) break;
                this.trInsertionSort(ISA, ISAd, ISAn, first, last);
                limit = -3;
                continue;
            }
            if (limit-- == 0) {
                if (!budget.update(size, last - first)) break;
                this.trHeapSort(ISA, ISAd, ISAn, first, last - first);
                a = last - 1;
                while (first < a) {
                    x = this.trGetC(ISA, ISAd, ISAn, SA[a]);
                    for (b = a - 1; first <= b && this.trGetC(ISA, ISAd, ISAn, SA[b]) == x; --b) {
                        SA[b] = ~SA[b];
                    }
                    a = b;
                }
                limit = -3;
                continue;
            }
            a = this.trPivot(ISA, ISAd, ISAn, first, last);
            BZip2DivSufSort.swapElements(SA, first, SA, a);
            v = this.trGetC(ISA, ISAd, ISAn, SA[first]);
            b = first;
            while (++b < last && (x = this.trGetC(ISA, ISAd, ISAn, SA[b])) == v) {
            }
            a = b;
            if (a < last && x < v) {
                while (++b < last && (x = this.trGetC(ISA, ISAd, ISAn, SA[b])) <= v) {
                    if (x != v) continue;
                    BZip2DivSufSort.swapElements(SA, b, SA, a);
                    ++a;
                }
            }
            c = last;
            while (b < --c && (x = this.trGetC(ISA, ISAd, ISAn, SA[c])) == v) {
            }
            int d = c;
            if (b < d && x > v) {
                while (b < --c && (x = this.trGetC(ISA, ISAd, ISAn, SA[c])) >= v) {
                    if (x != v) continue;
                    BZip2DivSufSort.swapElements(SA, c, SA, d);
                    --d;
                }
            }
            while (b < c) {
                BZip2DivSufSort.swapElements(SA, b, SA, c);
                while (++b < c && (x = this.trGetC(ISA, ISAd, ISAn, SA[b])) <= v) {
                    if (x != v) continue;
                    BZip2DivSufSort.swapElements(SA, b, SA, a);
                    ++a;
                }
                while (b < --c && (x = this.trGetC(ISA, ISAd, ISAn, SA[c])) >= v) {
                    if (x != v) continue;
                    BZip2DivSufSort.swapElements(SA, c, SA, d);
                    --d;
                }
            }
            if (a <= d) {
                c = b - 1;
                s = a - first;
                int t = b - a;
                if (s > t) {
                    s = t;
                }
                int e = first;
                int f = b - s;
                while (0 < s) {
                    BZip2DivSufSort.swapElements(SA, e, SA, f);
                    --s;
                    ++e;
                    ++f;
                }
                s = d - c;
                t = last - d - 1;
                if (s > t) {
                    s = t;
                }
                e = b;
                f = last - s;
                while (0 < s) {
                    BZip2DivSufSort.swapElements(SA, e, SA, f);
                    --s;
                    ++e;
                    ++f;
                }
                a = first + (b - a);
                b = last - (d - c);
                next = SA[ISA + SA[a]] != v ? this.trLog(b - a) : -1;
                v = a - 1;
                for (c = first; c < a; ++c) {
                    SA[ISA + SA[c]] = v;
                }
                if (b < last) {
                    v = b - 1;
                    for (c = a; c < b; ++c) {
                        SA[ISA + SA[c]] = v;
                    }
                }
                if (a - first <= last - b) {
                    if (last - b <= b - a) {
                        if (1 < a - first) {
                            stack[ssize++] = new StackEntry(ISAd + 1, a, b, next);
                            stack[ssize++] = new StackEntry(ISAd, b, last, limit);
                            last = a;
                            continue;
                        }
                        if (1 < last - b) {
                            stack[ssize++] = new StackEntry(ISAd + 1, a, b, next);
                            first = b;
                            continue;
                        }
                        if (1 < b - a) {
                            ++ISAd;
                            first = a;
                            last = b;
                            limit = next;
                            continue;
                        }
                        if (ssize == 0) {
                            return;
                        }
                        entry = stack[--ssize];
                        ISAd = entry.a;
                        first = entry.b;
                        last = entry.c;
                        limit = entry.d;
                        continue;
                    }
                    if (a - first <= b - a) {
                        if (1 < a - first) {
                            stack[ssize++] = new StackEntry(ISAd, b, last, limit);
                            stack[ssize++] = new StackEntry(ISAd + 1, a, b, next);
                            last = a;
                            continue;
                        }
                        if (1 < b - a) {
                            stack[ssize++] = new StackEntry(ISAd, b, last, limit);
                            ++ISAd;
                            first = a;
                            last = b;
                            limit = next;
                            continue;
                        }
                        first = b;
                        continue;
                    }
                    if (1 < b - a) {
                        stack[ssize++] = new StackEntry(ISAd, b, last, limit);
                        stack[ssize++] = new StackEntry(ISAd, first, a, limit);
                        ++ISAd;
                        first = a;
                        last = b;
                        limit = next;
                        continue;
                    }
                    stack[ssize++] = new StackEntry(ISAd, b, last, limit);
                    last = a;
                    continue;
                }
                if (a - first <= b - a) {
                    if (1 < last - b) {
                        stack[ssize++] = new StackEntry(ISAd + 1, a, b, next);
                        stack[ssize++] = new StackEntry(ISAd, first, a, limit);
                        first = b;
                        continue;
                    }
                    if (1 < a - first) {
                        stack[ssize++] = new StackEntry(ISAd + 1, a, b, next);
                        last = a;
                        continue;
                    }
                    if (1 < b - a) {
                        ++ISAd;
                        first = a;
                        last = b;
                        limit = next;
                        continue;
                    }
                    stack[ssize++] = new StackEntry(ISAd, first, last, limit);
                    continue;
                }
                if (last - b <= b - a) {
                    if (1 < last - b) {
                        stack[ssize++] = new StackEntry(ISAd, first, a, limit);
                        stack[ssize++] = new StackEntry(ISAd + 1, a, b, next);
                        first = b;
                        continue;
                    }
                    if (1 < b - a) {
                        stack[ssize++] = new StackEntry(ISAd, first, a, limit);
                        ++ISAd;
                        first = a;
                        last = b;
                        limit = next;
                        continue;
                    }
                    last = a;
                    continue;
                }
                if (1 < b - a) {
                    stack[ssize++] = new StackEntry(ISAd, first, a, limit);
                    stack[ssize++] = new StackEntry(ISAd, b, last, limit);
                    ++ISAd;
                    first = a;
                    last = b;
                    limit = next;
                    continue;
                }
                stack[ssize++] = new StackEntry(ISAd, first, a, limit);
                first = b;
                continue;
            }
            if (!budget.update(size, last - first)) break;
            ++limit;
            ++ISAd;
        }
        for (s = 0; s < ssize; ++s) {
            if (stack[s].d != -3) continue;
            this.lsUpdateGroup(ISA, stack[s].b, stack[s].c);
        }
    }

    private void trSort(int ISA, int n, int depth) {
        int[] SA = this.SA;
        int first = 0;
        if (-n < SA[0]) {
            TRBudget budget = new TRBudget(n, this.trLog(n) * 2 / 3 + 1);
            do {
                int t;
                if ((t = SA[first]) < 0) {
                    first -= t;
                    continue;
                }
                int last = SA[ISA + t] + 1;
                if (1 < last - first) {
                    this.trIntroSort(ISA, ISA + depth, ISA + n, first, last, budget, n);
                    if (budget.chance == 0) {
                        if (0 < first) {
                            SA[0] = -first;
                        }
                        this.lsSort(ISA, n, depth);
                        break;
                    }
                }
                first = last;
            } while (first < n);
        }
    }

    private static final int BUCKET_B(int c0, int c1) {
        return c1 << 8 | c0;
    }

    private static final int BUCKET_BSTAR(int c0, int c1) {
        return c0 << 8 | c1;
    }

    private int sortTypeBstar(int[] bucketA, int[] bucketB) {
        int c1;
        int t;
        int c0;
        int ti1;
        int i;
        byte[] T = this.T;
        int[] SA = this.SA;
        int n = this.n;
        int[] tempbuf = new int[256];
        boolean flag = true;
        for (i = 1; i < n; ++i) {
            if (T[i - 1] == T[i]) continue;
            if ((T[i - 1] & 0xFF) <= (T[i] & 0xFF)) break;
            flag = false;
            break;
        }
        i = n - 1;
        int m = n;
        int ti = T[i] & 0xFF;
        int t0 = T[0] & 0xFF;
        if (ti < t0 || T[i] == T[0] && flag) {
            if (!flag) {
                int n2 = BZip2DivSufSort.BUCKET_BSTAR(ti, t0);
                bucketB[n2] = bucketB[n2] + 1;
                SA[--m] = i;
            } else {
                int n3 = BZip2DivSufSort.BUCKET_B(ti, t0);
                bucketB[n3] = bucketB[n3] + 1;
            }
            --i;
            while (0 <= i && (ti = T[i] & 0xFF) <= (ti1 = T[i + 1] & 0xFF)) {
                int n4 = BZip2DivSufSort.BUCKET_B(ti, ti1);
                bucketB[n4] = bucketB[n4] + 1;
                --i;
            }
        }
        while (0 <= i) {
            do {
                int n5 = T[i] & 0xFF;
                bucketA[n5] = bucketA[n5] + 1;
            } while (0 <= --i && (T[i] & 0xFF) >= (T[i + 1] & 0xFF));
            if (0 > i) continue;
            int n6 = BZip2DivSufSort.BUCKET_BSTAR(T[i] & 0xFF, T[i + 1] & 0xFF);
            bucketB[n6] = bucketB[n6] + 1;
            SA[--m] = i--;
            while (0 <= i && (ti = T[i] & 0xFF) <= (ti1 = T[i + 1] & 0xFF)) {
                int n7 = BZip2DivSufSort.BUCKET_B(ti, ti1);
                bucketB[n7] = bucketB[n7] + 1;
                --i;
            }
        }
        if ((m = n - m) == 0) {
            for (i = 0; i < n; ++i) {
                SA[i] = i;
            }
            return 0;
        }
        i = -1;
        int j = 0;
        for (c0 = 0; c0 < 256; ++c0) {
            t = i + bucketA[c0];
            bucketA[c0] = i + j;
            i = t + bucketB[BZip2DivSufSort.BUCKET_B(c0, c0)];
            for (c1 = c0 + 1; c1 < 256; ++c1) {
                bucketB[c0 << 8 | c1] = j += bucketB[BZip2DivSufSort.BUCKET_BSTAR(c0, c1)];
                i += bucketB[BZip2DivSufSort.BUCKET_B(c0, c1)];
            }
        }
        int PAb = n - m;
        int ISAb = m;
        i = m - 2;
        while (0 <= i) {
            t = SA[PAb + i];
            c0 = T[t] & 0xFF;
            c1 = T[t + 1] & 0xFF;
            int n8 = BZip2DivSufSort.BUCKET_BSTAR(c0, c1);
            int n9 = bucketB[n8] - 1;
            bucketB[n8] = n9;
            SA[n9] = i--;
        }
        t = SA[PAb + m - 1];
        c0 = T[t] & 0xFF;
        c1 = T[t + 1] & 0xFF;
        int n10 = BZip2DivSufSort.BUCKET_BSTAR(c0, c1);
        int n11 = bucketB[n10] - 1;
        bucketB[n10] = n11;
        SA[n11] = m - 1;
        int[] buf = SA;
        int bufoffset = m;
        int bufsize = n - 2 * m;
        if (bufsize <= 256) {
            buf = tempbuf;
            bufoffset = 0;
            bufsize = 256;
        }
        c0 = 255;
        j = m;
        while (0 < j) {
            for (c1 = 255; c0 < c1; --c1) {
                i = bucketB[BZip2DivSufSort.BUCKET_BSTAR(c0, c1)];
                if (1 < j - i) {
                    this.subStringSort(PAb, i, j, buf, bufoffset, bufsize, 2, SA[i] == m - 1, n);
                }
                j = i;
            }
            --c0;
        }
        for (i = m - 1; 0 <= i; --i) {
            if (0 <= SA[i]) {
                j = i;
                do {
                    SA[ISAb + SA[i]] = i;
                } while (0 <= --i && 0 <= SA[i]);
                SA[i + 1] = i - j;
                if (i <= 0) break;
            }
            j = i;
            do {
                SA[i] = ~SA[i];
                SA[ISAb + SA[i]] = j;
            } while (SA[--i] < 0);
            SA[ISAb + SA[i]] = j;
        }
        this.trSort(ISAb, m, 1);
        i = n - 1;
        j = m;
        if ((T[i] & 0xFF) < (T[0] & 0xFF) || T[i] == T[0] && flag) {
            if (!flag) {
                SA[SA[ISAb + --j]] = i;
            }
            --i;
            while (0 <= i && (T[i] & 0xFF) <= (T[i + 1] & 0xFF)) {
                --i;
            }
        }
        while (0 <= i) {
            --i;
            while (0 <= i && (T[i] & 0xFF) >= (T[i + 1] & 0xFF)) {
                --i;
            }
            if (0 > i) continue;
            SA[SA[ISAb + --j]] = i--;
            while (0 <= i && (T[i] & 0xFF) <= (T[i + 1] & 0xFF)) {
                --i;
            }
        }
        i = n - 1;
        int k = m - 1;
        for (c0 = 255; 0 <= c0; --c0) {
            for (c1 = 255; c0 < c1; --c1) {
                t = i - bucketB[BZip2DivSufSort.BUCKET_B(c0, c1)];
                bucketB[BZip2DivSufSort.BUCKET_B((int)c0, (int)c1)] = i + 1;
                i = t;
                j = bucketB[BZip2DivSufSort.BUCKET_BSTAR(c0, c1)];
                while (j <= k) {
                    SA[i] = SA[k];
                    --i;
                    --k;
                }
            }
            t = i - bucketB[BZip2DivSufSort.BUCKET_B(c0, c0)];
            bucketB[BZip2DivSufSort.BUCKET_B((int)c0, (int)c0)] = i + 1;
            if (c0 < 255) {
                bucketB[BZip2DivSufSort.BUCKET_BSTAR((int)c0, (int)(c0 + 1))] = t + 1;
            }
            i = bucketA[c0];
        }
        return m;
    }

    private int constructBWT(int[] bucketA, int[] bucketB) {
        int s1;
        int s;
        int i;
        byte[] T = this.T;
        int[] SA = this.SA;
        int n = this.n;
        int t = 0;
        int c0 = 0;
        int c2 = 0;
        int orig = -1;
        for (int c1 = 254; 0 <= c1; --c1) {
            i = bucketB[BZip2DivSufSort.BUCKET_BSTAR(c1, c1 + 1)];
            t = 0;
            c2 = -1;
            for (int j = bucketA[c1 + 1]; i <= j; --j) {
                s1 = s = SA[j];
                if (0 <= s) {
                    if (--s < 0) {
                        s = n - 1;
                    }
                    if ((c0 = T[s] & 0xFF) > c1) continue;
                    SA[j] = ~s1;
                    if (0 < s && (T[s - 1] & 0xFF) > c0) {
                        s ^= 0xFFFFFFFF;
                    }
                    if (c2 == c0) {
                        SA[--t] = s;
                        continue;
                    }
                    if (0 <= c2) {
                        bucketB[BZip2DivSufSort.BUCKET_B((int)c2, (int)c1)] = t;
                    }
                    c2 = c0;
                    t = bucketB[BZip2DivSufSort.BUCKET_B(c2, c1)] - 1;
                    SA[t] = s;
                    continue;
                }
                SA[j] = ~s;
            }
        }
        for (i = 0; i < n; ++i) {
            s1 = s = SA[i];
            if (0 <= s) {
                if (--s < 0) {
                    s = n - 1;
                }
                if ((c0 = T[s] & 0xFF) >= (T[s + 1] & 0xFF)) {
                    if (0 < s && (T[s - 1] & 0xFF) < c0) {
                        s ^= 0xFFFFFFFF;
                    }
                    if (c0 == c2) {
                        SA[++t] = s;
                    } else {
                        if (c2 != -1) {
                            bucketA[c2] = t;
                        }
                        c2 = c0;
                        t = bucketA[c2] + 1;
                        SA[t] = s;
                    }
                }
            } else {
                s1 ^= 0xFFFFFFFF;
            }
            if (s1 == 0) {
                SA[i] = T[n - 1];
                orig = i;
                continue;
            }
            SA[i] = T[s1 - 1];
        }
        return orig;
    }

    public int bwt() {
        int[] SA = this.SA;
        byte[] T = this.T;
        int n = this.n;
        int[] bucketA = new int[256];
        int[] bucketB = new int[65536];
        if (n == 0) {
            return 0;
        }
        if (n == 1) {
            SA[0] = T[0];
            return 0;
        }
        int m = this.sortTypeBstar(bucketA, bucketB);
        if (0 < m) {
            return this.constructBWT(bucketA, bucketB);
        }
        return 0;
    }

    public BZip2DivSufSort(byte[] T, int[] SA, int n) {
        this.T = T;
        this.SA = SA;
        this.n = n;
    }

    private static class TRBudget {
        int budget;
        int chance;

        public boolean update(int size, int n) {
            this.budget -= n;
            if (this.budget <= 0) {
                if (--this.chance == 0) {
                    return false;
                }
                this.budget += size;
            }
            return true;
        }

        public TRBudget(int budget, int chance) {
            this.budget = budget;
            this.chance = chance;
        }
    }

    private final class PartitionResult {
        final int first;
        final int last;

        public PartitionResult(int first, int last) {
            this.first = first;
            this.last = last;
        }
    }

    private static class StackEntry {
        final int a;
        final int b;
        final int c;
        final int d;

        public StackEntry(int a, int b, int c, int d) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }
    }
}

