/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.eval.TwoValueWorker;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class MatrixMultiplyEvaluator
extends RecursiveObjectEvaluator
implements TwoValueWorker {
    protected static final long serialVersionUID = 1L;

    public MatrixMultiplyEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object first, Object second) throws IOException {
        if (null == first) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the first value", this.toExpression(this.constructingFactory)));
        }
        if (null == second) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the second value", this.toExpression(this.constructingFactory)));
        }
        Array2DRowRealMatrix realMatrix1 = this.getMatrix(first);
        Array2DRowRealMatrix realMatrix2 = this.getMatrix(second);
        Array2DRowRealMatrix realMatrix3 = realMatrix1.multiply(realMatrix2);
        return new Matrix(realMatrix3.getDataRef());
    }

    private Array2DRowRealMatrix getMatrix(Object o) throws IOException {
        if (o instanceof Matrix) {
            Matrix matrix = (Matrix)o;
            return new Array2DRowRealMatrix(matrix.getData(), false);
        }
        if (o instanceof List) {
            List vec = (List)o;
            double[][] data1 = new double[1][vec.size()];
            for (int i = 0; i < vec.size(); ++i) {
                data1[0][i] = ((Number)vec.get(i)).doubleValue();
            }
            return new Array2DRowRealMatrix(data1, false);
        }
        throw new IOException("The matrixMult function can only be applied to numeric arrays and matrices:" + o.getClass().toString());
    }
}

