/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.BindException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.internal.HttpClientFactory;
import org.openqa.selenium.remote.internal.HttpUrlBuilder;

@Deprecated
public class ApacheHttpClient
implements HttpClient {
    private static final int MAX_REDIRECTS = 10;
    private static final int MAX_CACHED_HOSTS = 50;
    private final URL url;
    private final org.apache.http.client.HttpClient client;
    private final Map<Map.Entry<String, Integer>, HttpHost> cachedHosts;

    public ApacheHttpClient(org.apache.http.client.HttpClient client, URL url) {
        this.client = (org.apache.http.client.HttpClient)Preconditions.checkNotNull((Object)client, (Object)"null HttpClient");
        this.url = (URL)Preconditions.checkNotNull((Object)url, (Object)"null URL");
        this.cachedHosts = new LinkedHashMap<Map.Entry<String, Integer>, HttpHost>(200){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > 50;
            }
        };
    }

    @Override
    public org.openqa.selenium.remote.http.HttpResponse execute(org.openqa.selenium.remote.http.HttpRequest request) throws IOException {
        HttpContext context = this.createContext();
        URL url = HttpUrlBuilder.toUrl(this.url, request);
        HttpUriRequest httpMethod = ApacheHttpClient.createHttpUriRequest(request.getMethod(), url);
        for (String name : request.getHeaderNames()) {
            if ("Content-Length".equalsIgnoreCase(name)) continue;
            for (String value : request.getHeaders(name)) {
                httpMethod.addHeader(name, value);
            }
        }
        if (request.getHeader("User-Agent") == null) {
            httpMethod.addHeader("User-Agent", USER_AGENT);
        }
        if (httpMethod instanceof HttpPost) {
            ((HttpPost)httpMethod).setEntity((HttpEntity)new ByteArrayEntity(request.getContent()));
        }
        HttpResponse response = this.fallBackExecute(context, httpMethod);
        response = this.followRedirects(this.client, context, response, 0);
        return this.createResponse(response, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private org.openqa.selenium.remote.http.HttpResponse createResponse(HttpResponse response, HttpContext context) throws IOException {
        Object host;
        org.openqa.selenium.remote.http.HttpResponse internalResponse = new org.openqa.selenium.remote.http.HttpResponse();
        internalResponse.setStatus(response.getStatusLine().getStatusCode());
        for (Header header : response.getAllHeaders()) {
            internalResponse.addHeader(header.getName(), header.getValue());
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            try {
                internalResponse.setContent(EntityUtils.toByteArray((HttpEntity)entity));
            }
            finally {
                EntityUtils.consume((HttpEntity)entity);
            }
        }
        if ((host = context.getAttribute("http.target_host")) instanceof HttpHost) {
            internalResponse.setTargetHost(((HttpHost)host).toURI());
        }
        return internalResponse;
    }

    protected HttpContext createContext() {
        return new BasicHttpContext();
    }

    private static HttpUriRequest createHttpUriRequest(HttpMethod method, URL url) throws IOException {
        URI uri = null;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        switch (method) {
            case DELETE: {
                return new HttpDelete(uri);
            }
            case GET: {
                return new HttpGet(uri);
            }
            case POST: {
                return new HttpPost(uri);
            }
        }
        throw new AssertionError((Object)("Unsupported method: " + (Object)((Object)method)));
    }

    private HttpResponse fallBackExecute(HttpContext context, HttpUriRequest httpMethod) throws IOException {
        try {
            return this.client.execute(this.getHost(httpMethod), (HttpRequest)httpMethod, context);
        }
        catch (BindException | NoHttpResponseException e) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
            return this.client.execute(this.getHost(httpMethod), (HttpRequest)httpMethod, context);
        }
    }

    private HttpResponse followRedirects(org.apache.http.client.HttpClient client, HttpContext context, HttpResponse response, int redirectCount) {
        if (!this.isRedirect(response)) {
            return response;
        }
        try {
            HttpEntity httpEntity = response.getEntity();
            if (httpEntity != null) {
                EntityUtils.consume((HttpEntity)httpEntity);
            }
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
        if (redirectCount > 10) {
            throw new WebDriverException("Maximum number of redirects exceeded. Aborting");
        }
        String location = response.getFirstHeader("location").getValue();
        try {
            URI uri = this.buildUri(context, location);
            HttpGet get = new HttpGet(uri);
            get.setHeader("Accept", "application/json; charset=utf-8");
            HttpResponse newResponse = client.execute(this.getHost((HttpUriRequest)get), (HttpRequest)get, context);
            return this.followRedirects(client, context, newResponse, redirectCount + 1);
        }
        catch (IOException | URISyntaxException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpHost getHost(HttpUriRequest method) {
        String host = method.getURI().getHost().replace(".localdomain", "");
        int port = method.getURI().getPort();
        if (port == -1) {
            switch (method.getURI().getScheme()) {
                case "http": {
                    port = 80;
                    break;
                }
                case "https": {
                    port = 443;
                    break;
                }
            }
        }
        Object object = this.cachedHosts;
        synchronized (object) {
            AbstractMap.SimpleImmutableEntry<String, Integer> entry = new AbstractMap.SimpleImmutableEntry<String, Integer>(host, port);
            HttpHost httpHost = this.cachedHosts.computeIfAbsent(entry, e -> new HttpHost((String)e.getKey(), ((Integer)e.getValue()).intValue()));
            return httpHost;
        }
    }

    private URI buildUri(HttpContext context, String location) throws URISyntaxException {
        URI uri = new URI(location);
        if (!uri.isAbsolute()) {
            HttpHost host = (HttpHost)context.getAttribute("http.target_host");
            uri = new URI(host.toURI() + location);
        }
        return uri;
    }

    private boolean isRedirect(HttpResponse response) {
        int code = response.getStatusLine().getStatusCode();
        return (code == 301 || code == 302 || code == 303 || code == 307) && response.containsHeader("location");
    }

    @Deprecated
    public static class Factory
    implements HttpClient.Factory {
        private static HttpClientFactory defaultClientFactory;
        private final HttpClientFactory clientFactory;

        public Factory() {
            this(Factory.getDefaultHttpClientFactory());
        }

        public Factory(HttpClientFactory clientFactory) {
            this.clientFactory = (HttpClientFactory)Preconditions.checkNotNull((Object)clientFactory, (Object)"null HttpClientFactory");
        }

        @Override
        public HttpClient createClient(URL url) {
            org.apache.http.client.HttpClient client;
            Preconditions.checkNotNull((Object)url, (Object)"null URL");
            if (url.getUserInfo() != null) {
                StringTokenizer tokens = new StringTokenizer(url.getUserInfo(), ":");
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(tokens.nextToken(), tokens.nextToken());
                client = this.clientFactory.createHttpClient((Credentials)credentials);
            } else {
                client = this.clientFactory.getHttpClient();
            }
            return new ApacheHttpClient(client, url);
        }

        @Override
        public void cleanupIdleClients() {
            this.clientFactory.cleanupIdleClients();
        }

        private static synchronized HttpClientFactory getDefaultHttpClientFactory() {
            if (defaultClientFactory == null) {
                defaultClientFactory = new HttpClientFactory();
            }
            return defaultClientFactory;
        }
    }
}

