/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.incrementalingest;

import java.io.IOException;
import java.io.Reader;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.core.interfaces.BinaryInput;
import org.apache.manifoldcf.core.interfaces.CharacterInput;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.TempFileCharacterInput;
import org.apache.manifoldcf.core.interfaces.TempFileInput;

public class RepositoryDocumentFactory {
    protected final RepositoryDocument original;
    protected BinaryInput binaryTracker;
    protected final Map<String, CharacterInput[]> metadataReaders = new HashMap<String, CharacterInput[]>();

    public RepositoryDocumentFactory(RepositoryDocument document) throws ManifoldCFException, IOException {
        this.original = document;
        try {
            this.binaryTracker = new TempFileInput(document.getBinaryStream());
            Iterator<String> iter = document.getFields();
            while (iter.hasNext()) {
                String fieldName = iter.next();
                Object[] objects = document.getField(fieldName);
                if (!(objects instanceof Reader[])) continue;
                CharacterInput[] newValues = new CharacterInput[objects.length];
                this.metadataReaders.put(fieldName, newValues);
                for (int i = 0; i < newValues.length; ++i) {
                    newValues[i] = new TempFileCharacterInput((Reader)objects[i]);
                }
            }
        }
        catch (Throwable e) {
            if (this.binaryTracker != null) {
                this.binaryTracker.discard();
            }
            for (String key : this.metadataReaders.keySet()) {
                CharacterInput[] rt;
                for (CharacterInput r : rt = this.metadataReaders.get(key)) {
                    if (r == null) continue;
                    r.discard();
                }
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RuntimeException("Unknown exception type: " + e.getClass().getName() + ": " + e.getMessage(), e);
        }
    }

    public RepositoryDocument createDocument() throws ManifoldCFException {
        RepositoryDocument rd = new RepositoryDocument();
        rd.setCreatedDate(this.original.getCreatedDate());
        rd.setModifiedDate(this.original.getModifiedDate());
        rd.setIndexingDate(this.original.getIndexingDate());
        rd.setMimeType(this.original.getMimeType());
        rd.setFileName(this.original.getFileName());
        Iterator<String> securityTypes = this.original.securityTypesIterator();
        while (securityTypes.hasNext()) {
            String securityType = securityTypes.next();
            rd.setSecurityACL(securityType, this.original.getSecurityACL(securityType));
            rd.setSecurityDenyACL(securityType, this.original.getSecurityDenyACL(securityType));
        }
        this.binaryTracker.doneWithStream();
        rd.setBinary(this.binaryTracker.getStream(), this.original.getBinaryLength());
        Iterator<String> iter = this.original.getFields();
        while (iter.hasNext()) {
            String fieldName = iter.next();
            Object[] objects = this.original.getField(fieldName);
            if (objects instanceof Reader[]) {
                CharacterInput[] rts = this.metadataReaders.get(fieldName);
                Reader[] newReaders = new Reader[rts.length];
                for (int i = 0; i < rts.length; ++i) {
                    rts[i].doneWithStream();
                    newReaders[i] = rts[i].getStream();
                }
                rd.addField(fieldName, newReaders);
                continue;
            }
            if (objects instanceof Date[]) {
                rd.addField(fieldName, (Date[])objects);
                continue;
            }
            if (objects instanceof String[]) {
                rd.addField(fieldName, (String[])objects);
                continue;
            }
            throw new RuntimeException("Unknown kind of metadata: " + objects.getClass().getName());
        }
        return rd;
    }

    public void close() throws ManifoldCFException {
        this.binaryTracker.discard();
        for (String key : this.metadataReaders.keySet()) {
            CharacterInput[] rt;
            for (CharacterInput r : rt = this.metadataReaders.get(key)) {
                r.discard();
            }
        }
    }
}

