/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.webcrawler;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.connectors.webcrawler.FindHandler;
import org.apache.manifoldcf.crawler.connectors.webcrawler.IHTMLHandler;
import org.apache.manifoldcf.crawler.connectors.webcrawler.LoginParameters;

public class FindContentHandler
extends FindHandler
implements IHTMLHandler {
    protected final List<Pattern> contentPatterns;
    protected final StringBuilder contentBuffer = new StringBuilder();
    protected static final int MAX_LENGTH = 65536;
    protected static final int OVERLAP_AMOUNT = 16384;

    public FindContentHandler(String parentURI, Pattern contentPattern) {
        super(parentURI);
        this.contentPatterns = Arrays.asList(contentPattern);
    }

    public FindContentHandler(String parentURI, List<Pattern> contentPatterns) {
        super(parentURI);
        this.contentPatterns = contentPatterns;
    }

    public void applyOverrides(LoginParameters lp) throws ManifoldCFException {
        if (this.targetURI != null && lp != null && lp.getOverrideTargetURL() != null) {
            super.noteDiscoveredLink(lp.getOverrideTargetURL());
        }
    }

    @Override
    public void noteTextCharacter(char textCharacter) throws ManifoldCFException {
        if (this.targetURI != null) {
            return;
        }
        if (textCharacter == '\t' || textCharacter >= ' ') {
            this.contentBuffer.append(textCharacter);
            if (this.contentBuffer.length() >= 65536) {
                String bufferContents = this.contentBuffer.toString();
                this.contentBuffer.setLength(0);
                for (Pattern contentPattern : this.contentPatterns) {
                    if (!contentPattern.matcher(bufferContents).find()) continue;
                    this.targetURI = "";
                    break;
                }
                if (this.targetURI == null) {
                    this.contentBuffer.append(bufferContents.substring(bufferContents.length() - 16384));
                }
            }
        } else {
            this.processBuffer();
        }
    }

    @Override
    public void noteMetaTag(Map metaAttributes) throws ManifoldCFException {
    }

    @Override
    public void noteFormStart(Map formAttributes) throws ManifoldCFException {
    }

    @Override
    public void noteFormInput(Map inputAttributes) throws ManifoldCFException {
    }

    @Override
    public void noteFormEnd() throws ManifoldCFException {
    }

    @Override
    public void noteAHREF(String rawURL) throws ManifoldCFException {
    }

    @Override
    public void noteBASEHREF(String rawURL) throws ManifoldCFException {
    }

    @Override
    public void noteLINKHREF(String rawURL) throws ManifoldCFException {
    }

    @Override
    public void noteIMGSRC(String rawURL) throws ManifoldCFException {
    }

    @Override
    public void noteFRAMESRC(String rawURL) throws ManifoldCFException {
    }

    @Override
    public void finishUp() throws ManifoldCFException {
        if (this.targetURI == null) {
            this.processBuffer();
        }
    }

    protected void processBuffer() {
        String bufferContents = this.contentBuffer.toString();
        this.contentBuffer.setLength(0);
        for (Pattern contentPattern : this.contentPatterns) {
            if (!contentPattern.matcher(bufferContents).find()) continue;
            this.targetURI = "";
            return;
        }
    }
}

