/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.transformation.tika;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.WriteOutContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TikaParser {
    private final Parser parser;

    public TikaParser(String tikaConfig) throws ManifoldCFException {
        if (tikaConfig == null || tikaConfig.length() == 0) {
            this.parser = new AutoDetectParser();
        } else {
            ByteArrayInputStream is = new ByteArrayInputStream(tikaConfig.getBytes(StandardCharsets.UTF_8));
            try {
                TikaConfig conf = new TikaConfig((InputStream)is);
                this.parser = new AutoDetectParser(conf);
            }
            catch (IOException | TikaException | SAXException e) {
                throw new ManifoldCFException(e.getMessage(), e);
            }
        }
    }

    public static ContentHandler newWriteOutBodyContentHandler(Writer w, int writeLimit) {
        WriteOutContentHandler writeOutContentHandler = new WriteOutContentHandler(w, writeLimit);
        return new BodyContentHandler((ContentHandler)writeOutContentHandler);
    }

    public void parse(InputStream stream, Metadata metadata, ContentHandler handler) throws IOException, SAXException, TikaException {
        ParseContext context = new ParseContext();
        context.set(Parser.class, (Object)this.parser);
        this.parser.parse(stream, handler, metadata, context);
    }
}

