/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.transformation.forcedmetadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.manifoldcf.agents.transformation.forcedmetadata.FieldDataFactory;
import org.apache.manifoldcf.agents.transformation.forcedmetadata.IDataSource;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class FieldSource
implements IDataSource {
    protected static final int CASE_EXACT = 0;
    protected static final int CASE_LOWER = 1;
    protected static final int CASE_UPPER = 2;
    protected static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected final FieldDataFactory rd;
    protected final String fieldName;
    protected final Pattern regExpPattern;
    protected final int groupNumber;
    protected final int caseSpecifier;
    protected String[] cachedValue;

    public FieldSource(FieldDataFactory rd, String fieldName, String regExp, String groupNumber) throws ManifoldCFException {
        this.rd = rd;
        this.fieldName = fieldName;
        if (regExp == null || regExp.length() == 0) {
            this.regExpPattern = null;
            this.groupNumber = 0;
            this.caseSpecifier = 0;
        } else {
            try {
                this.regExpPattern = Pattern.compile(regExp);
                if (groupNumber == null || groupNumber.length() == 0) {
                    this.groupNumber = 0;
                    this.caseSpecifier = 0;
                } else {
                    StringBuilder sb = new StringBuilder();
                    int caseResult = 0;
                    int i = 0;
                    while (i < groupNumber.length()) {
                        char theChar;
                        if ((theChar = groupNumber.charAt(i++)) >= '0' && theChar <= '9') {
                            sb.append(theChar);
                            continue;
                        }
                        if (theChar == 'l') {
                            caseResult = 1;
                            continue;
                        }
                        if (theChar == 'u') {
                            caseResult = 2;
                            continue;
                        }
                        throw new ManifoldCFException("Regular expression group specifier '" + groupNumber + "' has illegal character '" + theChar + "'; should be a number, or number + l, or number + u");
                    }
                    if (sb.length() == 0) {
                        throw new ManifoldCFException("Regular expression group specifier '" + groupNumber + "' must include a number");
                    }
                    this.caseSpecifier = caseResult;
                    this.groupNumber = Integer.parseInt(sb.toString());
                }
            }
            catch (NumberFormatException e) {
                throw new ManifoldCFException("Regular expression group specifier '" + groupNumber + "': " + e.getMessage(), (Throwable)e);
            }
            catch (PatternSyntaxException e) {
                throw new ManifoldCFException("Regular expression '" + regExp + "': " + e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public int getSize() throws IOException, ManifoldCFException {
        return this.getRawForm().length;
    }

    @Override
    public Object[] getRawForm() throws IOException, ManifoldCFException {
        if (this.regExpPattern != null) {
            return this.calculateExtractedResult();
        }
        Object[] rval = this.rd.getField(this.fieldName);
        if (rval == null) {
            return EMPTY_OBJECT_ARRAY;
        }
        return rval;
    }

    @Override
    public String[] getStringForm() throws IOException, ManifoldCFException {
        if (this.regExpPattern != null) {
            return this.calculateExtractedResult();
        }
        String[] rval = this.rd.getFieldAsStrings(this.fieldName);
        if (rval == null) {
            return EMPTY_STRING_ARRAY;
        }
        return rval;
    }

    protected String[] calculateExtractedResult() throws IOException, ManifoldCFException {
        if (this.cachedValue == null) {
            String[] resultSources = this.rd.getFieldAsStrings(this.fieldName);
            ArrayList<String> resultList = new ArrayList<String>(resultSources.length);
            for (String x : resultSources) {
                Matcher m = this.regExpPattern.matcher(x);
                if (!m.find()) continue;
                String result = x.substring(m.start(this.groupNumber), m.end(this.groupNumber));
                switch (this.caseSpecifier) {
                    case 1: {
                        result = result.toLowerCase(Locale.ROOT);
                        break;
                    }
                    case 2: {
                        result = result.toUpperCase(Locale.ROOT);
                        break;
                    }
                }
                resultList.add(result);
            }
            this.cachedValue = resultList.toArray(EMPTY_STRING_ARRAY);
        }
        return this.cachedValue;
    }
}

