/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.gridfs;

import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DBTCPConnector;
import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPasswordMapperActivity;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.crawler.connectors.BaseRepositoryConnector;
import org.apache.manifoldcf.crawler.connectors.gridfs.Messages;
import org.apache.manifoldcf.crawler.interfaces.IExistingVersions;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;
import org.apache.manifoldcf.crawler.system.Logging;
import org.bson.types.ObjectId;

public class GridFSRepositoryConnector
extends BaseRepositoryConnector {
    protected static final String ACTIVITY_FETCH = "fetch";
    protected static final String SERVER = "MongoDB - GridFS";
    protected static final long SESSION_EXPIRATION_MILLISECONDS = 30000L;
    protected String username = null;
    protected String password = null;
    protected String host = null;
    protected String port = null;
    protected String db = null;
    protected String bucket = null;
    protected String url = null;
    protected String acl = null;
    protected String denyAcl = null;
    protected DB session = null;
    protected long lastSessionFetch = -1L;
    private static final String EDIT_CONFIG_HEADER_FORWARD = "editConfiguration.js";
    private static final String VIEW_CONFIG_FORWARD = "viewConfiguration.html";
    private static final String EDIT_CONFIG_FORWARD_SERVER = "editConfiguration_Server.html";
    private static final String GRIDFS_SERVER_TAB_RESOURCE = "GridFSConnector.Server";
    private static final String TAB_NAME_PARAM = "TabName";
    protected static HashMap documentKnownColumns = new HashMap();

    public String[] getBinNames(String documentIdentifier) {
        return new String[]{this.host};
    }

    public int getConnectorModel() {
        return super.getConnectorModel();
    }

    public String[] getActivitiesList() {
        return new String[]{ACTIVITY_FETCH};
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.username = this.params.getParameter("username");
        this.password = this.params.getObfuscatedParameter("password");
        this.host = this.params.getParameter("host");
        this.port = this.params.getParameter("port");
        this.db = this.params.getParameter("db");
        this.bucket = this.params.getParameter("bucket");
        this.url = this.params.getParameter("url");
        this.acl = this.params.getParameter("acl");
        this.denyAcl = this.params.getParameter("denyAcl");
    }

    public String check() throws ManifoldCFException {
        try {
            this.getSession();
            if (this.session != null) {
                Mongo currentMongoSession = this.session.getMongo();
                currentMongoSession.getConnector().getDBPortPool(currentMongoSession.getAddress()).get().ensureOpen();
                this.session.getMongo().close();
                this.session = null;
                return super.check();
            }
            return "Not connected.";
        }
        catch (ManifoldCFException e) {
            return e.getMessage();
        }
        catch (IOException ex) {
            return ex.getMessage();
        }
    }

    public void disconnect() throws ManifoldCFException {
        if (this.session != null) {
            try {
                this.session.getMongo().close();
            }
            catch (Exception e) {
                Logging.connectors.error((Object)("GridFS: Error when trying to disconnect: " + e.getMessage()));
                throw new ManifoldCFException("GridFS: Error when trying to disconnect: " + e.getMessage(), (Throwable)e);
            }
            this.session = null;
            this.lastSessionFetch = -1L;
            this.username = null;
            this.password = null;
            this.host = null;
            this.port = null;
            this.db = null;
            this.bucket = null;
            this.url = null;
            this.acl = null;
            this.denyAcl = null;
        }
    }

    public void poll() throws ManifoldCFException {
        if (this.lastSessionFetch == -1L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.lastSessionFetch + 30000L) {
            if (this.session != null) {
                this.session.getMongo().close();
                this.session = null;
            }
            this.lastSessionFetch = -1L;
        }
    }

    public boolean isConnected() {
        if (this.session == null) {
            return false;
        }
        Mongo currentMongoSession = this.session.getMongo();
        DBTCPConnector currentTCPConnection = currentMongoSession.getConnector();
        return currentTCPConnection.isOpen();
    }

    public int getMaxDocumentRequest() {
        return super.getMaxDocumentRequest();
    }

    public String[] getRelationshipTypes() {
        return super.getRelationshipTypes();
    }

    public String addSeedDocuments(ISeedingActivity activities, Specification spec, String lastSeedVersion, long seedTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        DBCollection fsFiles = this.session.getCollection(this.bucket + ".files");
        DBCursor dnc = fsFiles.find();
        while (dnc.hasNext()) {
            DBObject dbo = dnc.next();
            String _id = dbo.get("_id").toString();
            activities.addSeedDocument(_id);
            if (!Logging.connectors.isDebugEnabled()) continue;
            Logging.connectors.debug((Object)("GridFS: Document _id = " + _id + " added to queue"));
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDocuments(String[] documentIdentifiers, IExistingVersions statuses, Specification spec, IProcessActivity activities, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        for (String documentIdentifier : documentIdentifiers) {
            String versionString;
            this.getSession();
            String _id = documentIdentifier;
            GridFS gfs = new GridFS(this.session, this.bucket);
            GridFSDBFile document = gfs.findOne(new ObjectId(_id));
            if (document == null) {
                activities.deleteDocument(documentIdentifier);
                continue;
            }
            DBObject metadata = document.getMetaData();
            String string = versionString = document.getMD5() + "+" + String.valueOf(metadata) != null ? Integer.toString(metadata.hashCode()) : "";
            if (versionString.length() != 0 && !activities.checkDocumentNeedsReindexing(documentIdentifier, versionString)) continue;
            long startTime = System.currentTimeMillis();
            String errorCode = null;
            Object errorDesc = null;
            String version = versionString;
            try {
                String urlValue;
                DBObject metadata2;
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("GridFS: Processing document _id = " + _id));
                }
                if ((metadata2 = document.getMetaData()) == null) {
                    errorCode = "NULLMETADATA";
                    errorDesc = "Excluded because document had a null Metadata";
                    Logging.connectors.warn((Object)("GridFS: Document " + _id + " has a null metadata - skipping."));
                    activities.noDocument(_id, version);
                    continue;
                }
                String string2 = urlValue = document.getMetaData().get(this.url) == null ? "" : document.getMetaData().get(this.url).toString();
                if (!StringUtils.isEmpty((String)urlValue)) {
                    boolean validURL;
                    try {
                        new URI(urlValue);
                        validURL = true;
                    }
                    catch (URISyntaxException e) {
                        validURL = false;
                    }
                    if (validURL) {
                        long fileLenght = document.getLength();
                        Date createdDate = document.getUploadDate();
                        String fileName = document.getFilename();
                        String mimeType = document.getContentType();
                        if (!activities.checkURLIndexable(urlValue)) {
                            Logging.connectors.warn((Object)("GridFS: Document " + _id + " has a URL excluded by the output connector ('" + urlValue + "') - skipping."));
                            errorCode = "EXCLUDEDURL";
                            errorDesc = "Excluded because of URL (" + urlValue + ")";
                            activities.noDocument(_id, version);
                            continue;
                        }
                        if (!activities.checkLengthIndexable(fileLenght)) {
                            Logging.connectors.warn((Object)("GridFS: Document " + _id + " has a length excluded by the output connector (" + fileLenght + ") - skipping."));
                            errorCode = "EXCLUDEDLENGTH";
                            errorDesc = "Excluded because of length (" + fileLenght + ")";
                            activities.noDocument(_id, version);
                            continue;
                        }
                        if (!activities.checkMimeTypeIndexable(mimeType)) {
                            Logging.connectors.warn((Object)("GridFS: Document " + _id + " has a mime type excluded by the output connector ('" + mimeType + "') - skipping."));
                            errorCode = "EXCLUDEDMIMETYPE";
                            errorDesc = "Excluded because of mime type (" + mimeType + ")";
                            activities.noDocument(_id, version);
                            continue;
                        }
                        if (!activities.checkDateIndexable(createdDate)) {
                            Logging.connectors.warn((Object)("GridFS: Document " + _id + " has a date excluded by the output connector (" + String.valueOf(createdDate) + ") - skipping."));
                            errorCode = "EXCLUDEDDATE";
                            errorDesc = "Excluded because of date (" + String.valueOf(createdDate) + ")";
                            activities.noDocument(_id, version);
                            continue;
                        }
                        RepositoryDocument rd = new RepositoryDocument();
                        rd.setCreatedDate(createdDate);
                        rd.setModifiedDate(createdDate);
                        rd.setFileName(fileName);
                        rd.setMimeType(mimeType);
                        String[] aclsArray = null;
                        String[] denyAclsArray = null;
                        if (this.acl != null) {
                            try {
                                Object aclObject = document.getMetaData().get(this.acl);
                                if (aclObject != null) {
                                    List acls = (List)aclObject;
                                    aclsArray = (String[])acls.toArray();
                                }
                            }
                            catch (ClassCastException e) {
                                Logging.connectors.warn((Object)("GridFS: Document " + _id + " metadata ACL field doesn't contain List<String> type."));
                                errorCode = "ACLTYPE";
                                errorDesc = "Allow ACL field doesn't contain List<String> type.";
                                throw new ManifoldCFException("Security decoding error: " + e.getMessage(), (Throwable)e);
                            }
                        }
                        if (this.denyAcl != null) {
                            try {
                                Object denyAclObject = document.getMetaData().get(this.denyAcl);
                                if (denyAclObject != null) {
                                    List denyAcls = (List)denyAclObject;
                                    denyAcls.add("DEAD_AUTHORITY");
                                    denyAclsArray = (String[])denyAcls.toArray();
                                }
                            }
                            catch (ClassCastException e) {
                                Logging.connectors.warn((Object)("GridFS: Document " + _id + " metadata DenyACL field doesn't contain List<String> type."));
                                errorCode = "ACLTYPE";
                                errorDesc = "Deny ACL field doesn't contain List<String> type.";
                                throw new ManifoldCFException("Security decoding error: " + e.getMessage(), (Throwable)e);
                            }
                        }
                        rd.setSecurity("document", aclsArray, denyAclsArray);
                        InputStream is = document.getInputStream();
                        try {
                            rd.setBinary(is, fileLenght);
                            try {
                                activities.ingestDocumentWithException(_id, version, urlValue, rd);
                            }
                            catch (IOException e) {
                                GridFSRepositoryConnector.handleIOException(e);
                            }
                        }
                        finally {
                            try {
                                is.close();
                            }
                            catch (IOException e) {
                                GridFSRepositoryConnector.handleIOException(e);
                            }
                        }
                        gfs.getDB().getMongo().close();
                        this.session = null;
                        errorCode = "OK";
                        continue;
                    }
                    Logging.connectors.warn((Object)("GridFS: Document " + _id + " has a invalid URL: " + urlValue + " - skipping."));
                    errorCode = "BADURL";
                    errorDesc = "Excluded because document had illegal URL ('" + urlValue + "')";
                    activities.noDocument(_id, version);
                    continue;
                }
                Logging.connectors.warn((Object)("GridFS: Document " + _id + " has a null URL - skipping."));
                errorCode = "NULLURL";
                errorDesc = "Excluded because document had a null URL.";
                activities.noDocument(_id, version);
            }
            finally {
                if (errorCode != null) {
                    activities.recordActivity(Long.valueOf(startTime), ACTIVITY_FETCH, Long.valueOf(document.getLength()), _id, errorCode, (String)errorDesc, null);
                }
            }
        }
    }

    protected static void handleIOException(IOException e) throws ManifoldCFException, ServiceInterruption {
        if (e instanceof InterruptedIOException) {
            throw new ManifoldCFException(e.getMessage(), (Throwable)e, 2);
        }
        throw new ManifoldCFException(e.getMessage(), (Throwable)e);
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, GRIDFS_SERVER_TAB_RESOURCE));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        this.fillInServerParameters(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIG_HEADER_FORWARD, paramMap, true);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put(TAB_NAME_PARAM, tabName);
        this.fillInServerParameters(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIG_FORWARD_SERVER, paramMap, true);
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String denyAcl;
        String acl;
        String url;
        String host;
        String port;
        String bucket;
        String db;
        String password;
        String username = variableContext.getParameter("username");
        if (username != null) {
            parameters.setParameter("username", username);
        }
        if ((password = variableContext.getParameter("password")) != null) {
            parameters.setObfuscatedParameter("password", variableContext.mapKeyToPassword(password));
        }
        if ((db = variableContext.getParameter("db")) != null) {
            parameters.setParameter("db", db);
        }
        if ((bucket = variableContext.getParameter("bucket")) != null) {
            parameters.setParameter("bucket", bucket);
        }
        if ((port = variableContext.getParameter("port")) != null) {
            parameters.setParameter("port", port);
        }
        if ((host = variableContext.getParameter("host")) != null) {
            parameters.setParameter("host", host);
        }
        if ((url = variableContext.getParameter("url")) != null) {
            parameters.setParameter("url", url);
        }
        if ((acl = variableContext.getParameter("acl")) != null) {
            parameters.setParameter("acl", acl);
        }
        if ((denyAcl = variableContext.getParameter("denyAcl")) != null) {
            parameters.setParameter("denyAcl", denyAcl);
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        this.fillInServerParameters(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, VIEW_CONFIG_FORWARD, paramMap, true);
    }

    protected void getSession() throws ManifoldCFException {
        if (this.session == null) {
            boolean auth;
            int integerPort;
            if (StringUtils.isEmpty((String)this.db) || StringUtils.isEmpty((String)this.bucket)) {
                throw new ManifoldCFException("GridFS: Database or bucket name cannot be empty.");
            }
            if (StringUtils.isEmpty((String)this.url)) {
                throw new ManifoldCFException("GridFS: Metadata URL field cannot be empty.");
            }
            if (StringUtils.isEmpty((String)this.host) && StringUtils.isEmpty((String)this.port)) {
                try {
                    this.session = new MongoClient().getDB(this.db);
                }
                catch (UnknownHostException ex) {
                    throw new ManifoldCFException("GridFS: Default host is not found. Does mongod process run?" + ex.getMessage(), (Throwable)ex);
                }
            }
            if (!StringUtils.isEmpty((String)this.host) && StringUtils.isEmpty((String)this.port)) {
                try {
                    this.session = new MongoClient(this.host).getDB(this.db);
                }
                catch (UnknownHostException ex) {
                    throw new ManifoldCFException("GridFS: Given host information is not valid or mongod process doesn't run" + ex.getMessage(), (Throwable)ex);
                }
            }
            if (!StringUtils.isEmpty((String)this.host) && !StringUtils.isEmpty((String)this.port)) {
                try {
                    integerPort = Integer.parseInt(this.port);
                    this.session = new MongoClient(this.host, integerPort).getDB(this.db);
                }
                catch (UnknownHostException ex) {
                    throw new ManifoldCFException("GridFS: Given information is not valid or mongod process doesn't run" + ex.getMessage(), (Throwable)ex);
                }
                catch (NumberFormatException ex) {
                    throw new ManifoldCFException("GridFS: Given port is not valid number. " + ex.getMessage(), (Throwable)ex);
                }
            }
            if (StringUtils.isEmpty((String)this.host) && !StringUtils.isEmpty((String)this.port)) {
                try {
                    integerPort = Integer.parseInt(this.port);
                    this.session = new MongoClient(this.host, integerPort).getDB(this.db);
                }
                catch (UnknownHostException ex) {
                    throw new ManifoldCFException("GridFS: Given information is not valid or mongod process doesn't run" + ex.getMessage(), (Throwable)ex);
                }
                catch (NumberFormatException ex) {
                    throw new ManifoldCFException("GridFS: Given port is not valid number. " + ex.getMessage(), (Throwable)ex);
                }
            }
            if (!(StringUtils.isEmpty((String)this.username) || StringUtils.isEmpty((String)this.password) || (auth = this.session.authenticate(this.username, this.password.toCharArray())))) {
                throw new ManifoldCFException("GridFS: Given database username and password doesn't match.");
            }
            this.lastSessionFetch = System.currentTimeMillis();
        }
    }

    public void fillInServerParameters(Map<String, String> paramMap, IPasswordMapperActivity mapper, ConfigParams parameters) {
        String usernameParam = parameters.getParameter("username");
        paramMap.put("username", usernameParam);
        String passwordParam = parameters.getObfuscatedParameter("password");
        passwordParam = passwordParam == null ? "" : mapper.mapPasswordToKey(passwordParam);
        paramMap.put("password", passwordParam);
        String dbParam = parameters.getParameter("db");
        if (StringUtils.isEmpty((String)dbParam)) {
            dbParam = "test";
        }
        paramMap.put("db", dbParam);
        String bucketParam = parameters.getParameter("bucket");
        if (StringUtils.isEmpty((String)bucketParam)) {
            bucketParam = "fs";
        }
        paramMap.put("bucket", bucketParam);
        String hostParam = parameters.getParameter("host");
        paramMap.put("host", hostParam);
        String portParam = parameters.getParameter("port");
        paramMap.put("port", portParam);
        String urlParam = parameters.getParameter("url");
        paramMap.put("url", urlParam);
        String aclParam = parameters.getParameter("acl");
        paramMap.put("acl", aclParam);
        String denyAclParam = parameters.getParameter("denyAcl");
        paramMap.put("denyAcl", denyAclParam);
    }

    protected void applyMetadata(RepositoryDocument rd, DBObject metadataMap) throws ManifoldCFException {
        for (String fieldName : metadataMap.keySet()) {
            if (documentKnownColumns.get(fieldName) != null) continue;
            Object metadata = metadataMap.get(fieldName);
            if (!(metadata instanceof String)) {
                throw new ManifoldCFException("Metadata field '" + fieldName + "' must be convertible to a string.");
            }
            rd.addField(fieldName, metadata.toString());
        }
    }

    static {
        documentKnownColumns.put("_id", "");
        documentKnownColumns.put("url", "");
    }
}

