/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class AssessmentThread
extends Thread {
    public static final String _rcsid = "@(#)$Id$";
    protected final String processID;

    public AssessmentThread(String processID) throws ManifoldCFException {
        this.processID = processID;
        this.setName("Assessment thread");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        Logging.threads.debug((Object)"Start up assessment thread");
        try {
            IThreadContext threadContext = ThreadContextFactory.make();
            IJobManager jobManager = JobManagerFactory.make(threadContext);
            while (true) {
                try {
                    while (true) {
                        jobManager.assessMarkedJobs();
                        ManifoldCF.sleep((long)5000L);
                    }
                }
                catch (ManifoldCFException e) {
                    if (e.getErrorCode() == 2) break;
                    if (e.getErrorCode() == 4) {
                        Logging.threads.error((Object)("Assessment thread aborting and restarting due to database connection reset: " + e.getMessage()), (Throwable)e);
                        try {
                            ManifoldCF.sleep((long)10000L);
                            continue;
                        }
                        catch (InterruptedException se) {
                            break;
                        }
                    }
                    Logging.threads.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                    if (e.getErrorCode() != 3) continue;
                    ManifoldCF.systemExit((int)1);
                    continue;
                }
                catch (InterruptedException e) {
                }
                catch (OutOfMemoryError e) {
                    System.err.println("agents process ran out of memory - shutting down");
                    e.printStackTrace(System.err);
                    ManifoldCF.systemExit((int)-200);
                    continue;
                }
                catch (Throwable e) {
                    Logging.threads.fatal((Object)("Error tossed: " + e.getMessage()), e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            System.err.println("agents process could not start - shutting down");
            Logging.threads.fatal((Object)("AssessmentThread initialization error tossed: " + e.getMessage()), e);
            ManifoldCF.systemExit((int)-300);
        }
    }
}

