/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Collection;
import java.util.Objects;
import org.apache.sis.feature.AbstractAssociation;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.PropertyView;
import org.opengis.util.GenericName;

class AssociationView
extends AbstractAssociation {
    private static final long serialVersionUID = -148100967531766909L;
    final AbstractFeature feature;
    final String name;

    private AssociationView(AbstractFeature abstractFeature, DefaultAssociationRole defaultAssociationRole) {
        super(defaultAssociationRole);
        this.feature = abstractFeature;
        this.name = defaultAssociationRole.getName().toString();
    }

    static AbstractAssociation create(AbstractFeature abstractFeature, DefaultAssociationRole defaultAssociationRole) {
        if (AssociationView.isSingleton(defaultAssociationRole.getMaximumOccurs())) {
            return new Singleton(abstractFeature, defaultAssociationRole);
        }
        return new AssociationView(abstractFeature, defaultAssociationRole);
    }

    @Override
    public final GenericName getName() {
        return this.role.getName();
    }

    @Override
    public AbstractFeature getValue() {
        return (AbstractFeature)PropertyView.getValue(this.feature, this.name);
    }

    @Override
    public void setValue(AbstractFeature abstractFeature) {
        PropertyView.setValue(this.feature, this.name, abstractFeature);
    }

    @Override
    public Collection<AbstractFeature> getValues() {
        return PropertyView.getValues(this.feature, this.name, AbstractFeature.class);
    }

    @Override
    public final void setValues(Collection<? extends AbstractFeature> collection) {
        PropertyView.setValues(this.feature, this.name, collection);
    }

    public final int hashCode() {
        return PropertyView.hashCode(this.feature, this.name);
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            AssociationView associationView = (AssociationView)object;
            return this.feature == associationView.feature && Objects.equals(this.name, associationView.name);
        }
        return false;
    }

    @Override
    public final String toString() {
        return PropertyView.toString(this.getClass(), AbstractFeature.class, this.getName(), this.getValues());
    }

    private static final class Singleton
    extends AssociationView {
        private static final long serialVersionUID = 2574475751526292380L;

        Singleton(AbstractFeature abstractFeature, DefaultAssociationRole defaultAssociationRole) {
            super(abstractFeature, defaultAssociationRole);
        }

        @Override
        public AbstractFeature getValue() {
            return (AbstractFeature)this.feature.getPropertyValue(this.name);
        }

        @Override
        public void setValue(AbstractFeature abstractFeature) {
            this.feature.setPropertyValue(this.name, abstractFeature);
        }

        @Override
        public Collection<AbstractFeature> getValues() {
            return PropertyView.singletonOrEmpty(this.getValue());
        }
    }
}

