/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.util.Validator;

class EnumValidator
extends Validator<List<String>> {
    private Set<String> enumVals;

    EnumValidator(Map<?, ?> schema, List<String> properties) {
        super(schema, properties);
        this.enumVals = new HashSet<String>(properties);
    }

    @Override
    boolean validate(Object o, List<String> errs) {
        if (o instanceof String) {
            if (!this.enumVals.contains(o)) {
                errs.add("Value of enum must be one of " + this.enumVals);
                return false;
            }
            return true;
        }
        return false;
    }
}

