/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.storedobj.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlListImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.InMemoryAce;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.Permission;

public class InMemoryAcl
implements Cloneable {
    private List<InMemoryAce> acl;
    private int id;
    private static final Comparator<? super InMemoryAce> COMP = new AceComparator<InMemoryAce>();
    private static final InMemoryAcl DEFAULT_ACL = new InMemoryAcl((List<InMemoryAce>)new ArrayList<InMemoryAce>(){
        {
            this.add(InMemoryAce.getDefaultAce());
        }
    });

    public static InMemoryAcl createFromCommonsAcl(Acl commonsAcl) {
        InMemoryAcl acl = new InMemoryAcl();
        for (Ace cace : commonsAcl.getAces()) {
            if (acl.hasPrincipal(cace.getPrincipalId())) {
                Permission perm = acl.getPermission(cace.getPrincipalId());
                Permission newPerm = Permission.fromCmisString((String)cace.getPermissions().get(0));
                if (perm.ordinal() <= newPerm.ordinal()) continue;
                acl.setPermission(cace.getPrincipalId(), newPerm);
                continue;
            }
            acl.addAce(new InMemoryAce(cace));
        }
        return acl;
    }

    public static InMemoryAcl getDefaultAcl() {
        return DEFAULT_ACL;
    }

    public InMemoryAcl() {
        this.acl = new ArrayList<InMemoryAce>(3);
    }

    public InMemoryAcl(List<InMemoryAce> arg) {
        int i;
        this.acl = new ArrayList<InMemoryAce>(arg);
        Collections.sort(this.acl, COMP);
        for (i = 0; i < this.acl.size(); ++i) {
            InMemoryAce ace = this.acl.get(i);
            if (ace != null) continue;
            throw new IllegalArgumentException("Cannot create ACLs with a null principal id or permission.");
        }
        for (i = 0; i < this.acl.size() - 1; ++i) {
            if (!this.acl.get(i).equals(this.acl.get(i + 1))) continue;
            throw new IllegalArgumentException("Cannot create ACLs with same principal id in more than one ACE.");
        }
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public final List<InMemoryAce> getAces() {
        return this.acl;
    }

    public boolean addAce(InMemoryAce ace) {
        if (ace == null) {
            return false;
        }
        for (InMemoryAce ace2 : this.acl) {
            if (!ace2.getPrincipalId().equals(ace.getPrincipalId())) continue;
            return false;
        }
        this.acl.add(ace);
        Collections.sort(this.acl, COMP);
        return true;
    }

    public boolean removeAce(InMemoryAce ace) {
        return this.acl.remove(ace);
    }

    public void mergeAcl(InMemoryAcl acl2) {
        if (acl2 == null) {
            return;
        }
        for (InMemoryAce ace : acl2.getAces()) {
            InMemoryAce existingAce = this.getAce(ace.getPrincipalId());
            if (existingAce == null) {
                this.acl.add(ace);
                continue;
            }
            if (existingAce.getPermission().ordinal() >= ace.getPermission().ordinal()) continue;
            existingAce.setPermission(ace.getPermission());
        }
        Collections.sort(this.acl, COMP);
    }

    public Permission getPermission(String principalId) {
        InMemoryAce ace = this.getAce(principalId);
        return ace == null ? Permission.NONE : ace.getPermission();
    }

    private InMemoryAce getAce(String principalId) {
        if (null == principalId) {
            return null;
        }
        for (InMemoryAce ace : this.acl) {
            if (!ace.getPrincipalId().equals(principalId)) continue;
            return ace;
        }
        return null;
    }

    public boolean hasPermission(String principalId, Permission permission) {
        if (null == permission) {
            return false;
        }
        if (null == principalId) {
            for (InMemoryAce ace : this.acl) {
                if (!ace.getPrincipalId().equals(InMemoryAce.getAnonymousUser())) continue;
                return ace.hasPermission(permission);
            }
        }
        for (InMemoryAce ace : this.acl) {
            if (!ace.getPrincipalId().equals(principalId) && !ace.getPrincipalId().equals(InMemoryAce.getAnyoneUser()) && !ace.getPrincipalId().equals(InMemoryAce.getAnonymousUser())) continue;
            return ace.hasPermission(permission);
        }
        return false;
    }

    public void setPermission(String principalId, Permission permission) {
        for (InMemoryAce ace : this.acl) {
            if (!ace.getPrincipalId().equals(principalId)) continue;
            ace.setPermission(permission);
        }
        throw new IllegalArgumentException("Unknown principalId in setPermission: " + principalId);
    }

    public int size() {
        return this.acl.size();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.acl == null ? 0 : this.acl.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InMemoryAcl other = (InMemoryAcl)obj;
        return !(this.acl == null ? other.acl != null : !this.acl.equals(other.acl));
    }

    public String toString() {
        return "InMemoryAcl [acl=" + this.acl + "]";
    }

    private boolean hasPrincipal(String principalId) {
        for (InMemoryAce ace : this.acl) {
            if (!ace.getPrincipalId().equals(principalId)) continue;
            return true;
        }
        return false;
    }

    public Acl toCommonsAcl() {
        ArrayList<Ace> commonsAcl = new ArrayList<Ace>();
        for (InMemoryAce memAce : this.acl) {
            commonsAcl.add(memAce.toCommonsAce());
        }
        return new AccessControlListImpl(commonsAcl);
    }

    public InMemoryAcl clone() throws CloneNotSupportedException {
        InMemoryAcl newAcl = new InMemoryAcl(this.acl);
        return newAcl;
    }

    private static class AceComparator<T extends InMemoryAce>
    implements Comparator<T> {
        private AceComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            if (null == o1 || null == o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                return -1;
            }
            int res = ((InMemoryAce)o1).getPrincipalId().compareTo(((InMemoryAce)o2).getPrincipalId());
            return res;
        }
    }
}

