/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.configuration.internal;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.maven.configuration.internal.EnhancedCompositeBeanHelper;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.composite.ObjectWithFieldsConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.configurator.expression.TypeAwareExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

class EnhancedConfigurationConverter
extends ObjectWithFieldsConverter {
    private static final ConcurrentMap<String, Object> EXPRESSION_CACHE = new ConcurrentHashMap<String, Object>();

    EnhancedConfigurationConverter() {
    }

    protected Object fromExpression(PlexusConfiguration configuration, ExpressionEvaluator evaluator, Class<?> type) throws ComponentConfigurationException {
        String value = configuration.getValue();
        try {
            TypeAwareExpressionEvaluator typeAwareExpressionEvaluator;
            Object result = null;
            if (null != value && !value.isEmpty()) {
                if (evaluator instanceof TypeAwareExpressionEvaluator) {
                    typeAwareExpressionEvaluator = (TypeAwareExpressionEvaluator)evaluator;
                    result = typeAwareExpressionEvaluator.evaluate(value, type);
                } else {
                    result = evaluator.evaluate(value);
                }
            }
            if (null == result && configuration.getChildCount() == 0 && null != (value = configuration.getAttribute("default-value")) && !value.isEmpty()) {
                if (evaluator instanceof TypeAwareExpressionEvaluator) {
                    typeAwareExpressionEvaluator = (TypeAwareExpressionEvaluator)evaluator;
                    result = typeAwareExpressionEvaluator.evaluate(value, type);
                } else {
                    result = evaluator.evaluate(value);
                }
            }
            this.failIfNotTypeCompatible(result, type, configuration);
            return result;
        }
        catch (ExpressionEvaluationException e) {
            String reason = String.format("Cannot evaluate expression '%s' for configuration entry '%s'", value, configuration.getName());
            throw new ComponentConfigurationException(configuration, reason, (Throwable)e);
        }
    }

    public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Object value = this.fromExpression(configuration, evaluator, type);
        if (type.isInstance(value)) {
            return value;
        }
        try {
            Class implType = this.getClassForImplementationHint(type, configuration, loader);
            if (null == value && implType.isInterface() && configuration.getChildCount() == 0) {
                return null;
            }
            Object bean = this.instantiateObject(implType);
            if (null == value) {
                this.processConfiguration(lookup, bean, loader, configuration, evaluator, listener);
            } else {
                new EnhancedCompositeBeanHelper(lookup, loader, evaluator, listener).setDefault(bean, value, configuration);
            }
            return bean;
        }
        catch (ComponentConfigurationException e) {
            if (null == e.getFailedConfiguration()) {
                e.setFailedConfiguration(configuration);
            }
            throw e;
        }
    }

    public void processConfiguration(ConverterLookup lookup, Object bean, ClassLoader loader, PlexusConfiguration configuration, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        EnhancedCompositeBeanHelper helper = new EnhancedCompositeBeanHelper(lookup, loader, evaluator, listener);
        int size = configuration.getChildCount();
        for (int i = 0; i < size; ++i) {
            Class valueType;
            PlexusConfiguration element = configuration.getChild(i);
            String propertyName = this.fromXML(element.getName());
            try {
                valueType = this.getClassForImplementationHint(null, element, loader);
            }
            catch (ComponentConfigurationException e) {
                valueType = null;
            }
            helper.setProperty(bean, propertyName, valueType, element);
        }
    }

    public static void clearCaches() {
        EXPRESSION_CACHE.clear();
        EnhancedCompositeBeanHelper.clearCaches();
    }
}

