/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.scope;

import java.util.Objects;
import org.eclipse.aether.collection.DependencyGraphTransformationContext;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.impl.scope.BuildScope;
import org.eclipse.aether.impl.scope.InternalScopeManager;
import org.eclipse.aether.scope.DependencyScope;

public final class ManagedDependencyContextRefiner
implements DependencyGraphTransformer {
    private final InternalScopeManager scopeManager;

    public ManagedDependencyContextRefiner(InternalScopeManager scopeManager) {
        this.scopeManager = Objects.requireNonNull(scopeManager, "scopeManager");
    }

    public DependencyNode transformGraph(DependencyNode node, DependencyGraphTransformationContext context) {
        String scope;
        Objects.requireNonNull(node, "node cannot be null");
        Objects.requireNonNull(context, "context cannot be null");
        String ctx = node.getRequestContext();
        if ("project".equals(ctx) && (scope = this.getBuildpathScope(node)) != null) {
            ctx = ctx + '/' + scope;
            node.setRequestContext(ctx);
        }
        for (DependencyNode child : node.getChildren()) {
            this.transformGraph(child, context);
        }
        return node;
    }

    private String getBuildpathScope(DependencyNode node) {
        Dependency dependency = node.getDependency();
        if (dependency == null) {
            return null;
        }
        return this.scopeManager.getDependencyScope(dependency.getScope()).flatMap(s -> this.scopeManager.getDependencyScopeMainProjectBuildScope((DependencyScope)s).map(BuildScope::getId)).orElse(null);
    }
}

