/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.api.services.Transport;
import org.eclipse.aether.spi.connector.transport.GetTask;
import org.eclipse.aether.spi.connector.transport.PutTask;
import org.eclipse.aether.spi.connector.transport.Transporter;

public class DefaultTransport
implements Transport {
    private final URI baseURI;
    private final Transporter transporter;

    public DefaultTransport(URI baseURI, Transporter transporter) {
        this.baseURI = Objects.requireNonNull(baseURI);
        this.transporter = Objects.requireNonNull(transporter);
    }

    public boolean get(URI relativeSource, Path target) {
        Objects.requireNonNull(relativeSource, "relativeSource is null");
        Objects.requireNonNull(target, "target is null");
        if (relativeSource.isAbsolute()) {
            throw new IllegalArgumentException("Supplied URI is not relative");
        }
        URI source = this.baseURI.resolve(relativeSource);
        if (!source.toASCIIString().startsWith(this.baseURI.toASCIIString())) {
            throw new IllegalArgumentException("Supplied relative URI escapes baseUrl");
        }
        GetTask getTask = new GetTask(source);
        getTask.setDataPath(target);
        try {
            this.transporter.get(getTask);
            return true;
        }
        catch (Exception e) {
            if (1 != this.transporter.classify((Throwable)e)) {
                throw new RuntimeException(e);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<byte[]> getBytes(URI relativeSource) {
        try {
            Path tempPath = null;
            try {
                tempPath = Files.createTempFile("transport-get", "tmp", new FileAttribute[0]);
                if (this.get(relativeSource, tempPath)) {
                    Optional<byte[]> optional2 = Optional.of(Files.readAllBytes(tempPath));
                    return optional2;
                }
                Optional<byte[]> optional = Optional.empty();
                return optional;
            }
            finally {
                if (tempPath != null) {
                    Files.deleteIfExists(tempPath);
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Optional<String> getString(URI relativeSource, Charset charset) {
        Objects.requireNonNull(charset, "charset is null");
        Optional<byte[]> data = this.getBytes(relativeSource);
        return data.map(bytes -> new String((byte[])bytes, charset));
    }

    public void put(Path source, URI relativeTarget) {
        Objects.requireNonNull(source, "source is null");
        Objects.requireNonNull(relativeTarget, "relativeTarget is null");
        if (Files.isRegularFile(source, new LinkOption[0])) {
            throw new IllegalArgumentException("source file does not exist or is not a file");
        }
        if (relativeTarget.isAbsolute()) {
            throw new IllegalArgumentException("Supplied URI is not relative");
        }
        URI target = this.baseURI.resolve(relativeTarget);
        if (!target.toASCIIString().startsWith(this.baseURI.toASCIIString())) {
            throw new IllegalArgumentException("Supplied relative URI escapes baseUrl");
        }
        PutTask putTask = new PutTask(target);
        putTask.setDataPath(source);
        try {
            this.transporter.put(putTask);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putBytes(byte[] source, URI relativeTarget) {
        Objects.requireNonNull(source, "source is null");
        try {
            Path tempPath = null;
            try {
                tempPath = Files.createTempFile("transport-get", "tmp", new FileAttribute[0]);
                Files.write(tempPath, source, new OpenOption[0]);
                this.put(tempPath, relativeTarget);
            }
            finally {
                if (tempPath != null) {
                    Files.deleteIfExists(tempPath);
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void putString(String source, Charset charset, URI relativeTarget) {
        Objects.requireNonNull(source, "source string is null");
        Objects.requireNonNull(charset, "charset is null");
        this.putBytes(source.getBytes(charset), relativeTarget);
    }

    public void close() {
        this.transporter.close();
    }
}

