/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.Comparator;
import java.util.List;
import org.apache.maven.lifecycle.internal.PhaseId;

public class PhaseComparator
implements Comparator<String> {
    private final List<String> lifecyclePhases;

    public PhaseComparator(List<String> lifecyclePhases) {
        this.lifecyclePhases = lifecyclePhases;
    }

    @Override
    public int compare(String o1, String o2) {
        PhaseId p1 = PhaseId.of(o1);
        PhaseId p2 = PhaseId.of(o2);
        int i1 = this.lifecyclePhases.indexOf(p1.executionPoint().prefix() + p1.phase());
        int i2 = this.lifecyclePhases.indexOf(p2.executionPoint().prefix() + p2.phase());
        if (i1 == -1 && i2 == -1) {
            return 0;
        }
        if (i1 == -1) {
            return 1;
        }
        if (i2 == -1) {
            return -1;
        }
        int rv = Integer.compare(i1, i2);
        if (rv != 0) {
            return rv;
        }
        return Integer.compare(p1.priority(), p2.priority());
    }
}

