/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.mina;

import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSessionConfig;
import org.apache.mina.transport.socket.SocketSessionConfig;
import org.apache.mina.transport.socket.nio.NioSession;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.Property;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoService;
import org.apache.sshd.common.io.IoServiceEventListener;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.mina.MinaSession;
import org.apache.sshd.mina.MinaSupport;

public abstract class MinaService
extends AbstractCloseable
implements IoService,
org.apache.mina.core.service.IoHandler,
Closeable {
    protected final FactoryManager manager;
    protected final IoHandler handler;
    protected final IoProcessor<NioSession> ioProcessor;
    protected IoSessionConfig sessionConfig;
    private IoServiceEventListener eventListener;

    protected MinaService(FactoryManager manager, IoHandler handler, IoProcessor<NioSession> ioProcessor) {
        this.manager = Objects.requireNonNull(manager, "No factory manager provided");
        this.handler = Objects.requireNonNull(handler, "No IoHandler provided");
        this.ioProcessor = Objects.requireNonNull(ioProcessor, "No IoProcessor provided");
    }

    public IoServiceEventListener getIoServiceEventListener() {
        return this.eventListener;
    }

    public void setIoServiceEventListener(IoServiceEventListener listener) {
        this.eventListener = listener;
    }

    protected abstract org.apache.mina.core.service.IoService getIoService();

    public void dispose() {
        org.apache.mina.core.service.IoService ioService = this.getIoService();
        ioService.dispose();
    }

    protected void doCloseImmediately() {
        try {
            this.dispose();
        }
        finally {
            super.doCloseImmediately();
        }
    }

    public Map<Long, IoSession> getManagedSessions() {
        org.apache.mina.core.service.IoService ioService = this.getIoService();
        Map managedMap = ioService.getManagedSessions();
        HashMap mina = new HashMap(managedMap);
        HashMap<Long, IoSession> sessions = new HashMap<Long, IoSession>(mina.size());
        for (Long id : mina.keySet()) {
            org.apache.mina.core.session.IoSession minaSession = (org.apache.mina.core.session.IoSession)mina.get(id);
            IoSession session = this.getSession(minaSession);
            if (session == null) continue;
            sessions.put(id, session);
        }
        return sessions;
    }

    public void sessionOpened(org.apache.mina.core.session.IoSession session) throws Exception {
    }

    public void sessionIdle(org.apache.mina.core.session.IoSession session, IdleStatus status) throws Exception {
    }

    public void messageSent(org.apache.mina.core.session.IoSession session, Object message) throws Exception {
    }

    public void inputClosed(org.apache.mina.core.session.IoSession session) throws Exception {
        session.closeNow();
    }

    protected void sessionCreated(org.apache.mina.core.session.IoSession session, SocketAddress acceptanceAddress) throws Exception {
        MinaSession ioSession = new MinaSession(this, session, acceptanceAddress);
        try {
            session.setAttribute(IoSession.class, (Object)ioSession);
            this.handler.sessionCreated((IoSession)ioSession);
        }
        catch (Exception e) {
            this.log.warn("sessionCreated({}) failed {} to handle creation event: {}", new Object[]{session, e.getClass().getSimpleName(), e.getMessage()});
            ioSession.close(true);
            throw e;
        }
    }

    public void sessionClosed(org.apache.mina.core.session.IoSession ioSession) throws Exception {
        IoSession session = this.getSession(ioSession);
        this.handler.sessionClosed(session);
    }

    public void exceptionCaught(org.apache.mina.core.session.IoSession ioSession, Throwable cause) throws Exception {
        IoSession session = this.getSession(ioSession);
        this.handler.exceptionCaught(session, cause);
    }

    public void messageReceived(org.apache.mina.core.session.IoSession ioSession, Object message) throws Exception {
        IoSession session = this.getSession(ioSession);
        Readable ioBuffer = MinaSupport.asReadable((IoBuffer)message);
        this.handler.messageReceived(session, ioBuffer);
    }

    protected IoSession getSession(org.apache.mina.core.session.IoSession session) {
        return (IoSession)session.getAttribute(IoSession.class);
    }

    protected void configure(SocketSessionConfig config) {
        int readBufferSize;
        Integer intVal;
        Boolean boolVal = this.getBoolean((Property<Boolean>)CoreModuleProperties.SOCKET_KEEPALIVE);
        if (boolVal != null) {
            try {
                config.setKeepAlive(boolVal.booleanValue());
            }
            catch (RuntimeIoException t) {
                this.handleConfigurationError(config, CoreModuleProperties.SOCKET_KEEPALIVE, boolVal, t);
            }
        }
        if ((intVal = this.getInteger((Property<Integer>)CoreModuleProperties.SOCKET_SNDBUF)) != null) {
            try {
                config.setSendBufferSize(intVal.intValue());
            }
            catch (RuntimeIoException t) {
                this.handleConfigurationError(config, CoreModuleProperties.SOCKET_SNDBUF, intVal, t);
            }
        }
        if ((intVal = this.getInteger((Property<Integer>)CoreModuleProperties.SOCKET_RCVBUF)) != null) {
            try {
                config.setReceiveBufferSize(intVal.intValue());
            }
            catch (RuntimeIoException t) {
                this.handleConfigurationError(config, CoreModuleProperties.SOCKET_RCVBUF, intVal, t);
            }
        }
        if ((intVal = this.getInteger((Property<Integer>)CoreModuleProperties.SOCKET_LINGER)) != null) {
            try {
                config.setSoLinger(intVal.intValue());
            }
            catch (RuntimeIoException t) {
                this.handleConfigurationError(config, CoreModuleProperties.SOCKET_LINGER, intVal, t);
            }
        }
        if ((boolVal = this.getBoolean((Property<Boolean>)CoreModuleProperties.TCP_NODELAY)) != null) {
            try {
                config.setTcpNoDelay(boolVal.booleanValue());
            }
            catch (RuntimeIoException t) {
                this.handleConfigurationError(config, CoreModuleProperties.TCP_NODELAY, boolVal, t);
            }
        }
        int defaultMinReadBufferSize = config.getMinReadBufferSize();
        intVal = this.getInteger((Property<Integer>)CoreModuleProperties.MIN_READ_BUFFER_SIZE);
        if (intVal != null && (readBufferSize = intVal.intValue()) > defaultMinReadBufferSize) {
            readBufferSize = Math.min(readBufferSize, config.getMaxReadBufferSize());
            config.setMinReadBufferSize(readBufferSize);
            int defaultReadBufferSize = config.getReadBufferSize();
            if (defaultReadBufferSize < readBufferSize) {
                config.setReadBufferSize(readBufferSize);
            }
        }
        if ((intVal = this.getInteger((Property<Integer>)CoreModuleProperties.NIO2_READ_BUFFER_SIZE)) != null && (readBufferSize = intVal.intValue()) >= defaultMinReadBufferSize) {
            readBufferSize = Math.max(readBufferSize, config.getMinReadBufferSize());
            readBufferSize = Math.min(readBufferSize, config.getMaxReadBufferSize());
            config.setReadBufferSize(readBufferSize);
        }
        if (this.sessionConfig != null) {
            config.setAll(this.sessionConfig);
        }
    }

    protected void handleConfigurationError(SocketSessionConfig config, Property<?> property, Object propValue, RuntimeIoException t) {
        Throwable e = ExceptionUtils.resolveExceptionCause((Throwable)t);
        this.log.warn("handleConfigurationError({}={}) failed ({}) to configure: {}", new Object[]{property.getName(), propValue, e.getClass().getSimpleName(), e.getMessage()});
    }

    protected Integer getInteger(Property<Integer> property) {
        return (Integer)property.getOrNull((PropertyResolver)this.manager);
    }

    protected Boolean getBoolean(Property<Boolean> property) {
        return (Boolean)property.getOrNull((PropertyResolver)this.manager);
    }
}

