/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.cryptography;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Security;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.apache.vysper.xmpp.cryptography.TLSContextFactory;
import org.apache.vysper.xmpp.cryptography.TrustManagerFactory;

public abstract class AbstractTLSContextFactory
implements TLSContextFactory {
    private static final String PROTOCOL = "TLS";
    private static final String KEY_MANAGER_FACTORY_ALGORITHM;
    private SSLContext sslContext = null;
    protected String password = null;
    protected TrustManagerFactory trustManagerFactory = null;

    protected abstract InputStream getCertificateInputStream() throws IOException;

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTrustManagerFactory(TrustManagerFactory trustManagerFactory) {
        this.trustManagerFactory = trustManagerFactory;
    }

    public SSLContext getSSLContext() throws GeneralSecurityException, IOException {
        if (this.sslContext == null) {
            this.sslContext = this.createSSLContext();
        }
        return this.sslContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLContext createSSLContext() throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("JKS");
        InputStream in = null;
        try {
            in = this.getCertificateInputStream();
            ks.load(in, this.password.toCharArray());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignored) {}
            }
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KEY_MANAGER_FACTORY_ALGORITHM);
        kmf.init(ks, this.password.toCharArray());
        SSLContext sslContext = SSLContext.getInstance(PROTOCOL);
        sslContext.init(kmf.getKeyManagers(), this.trustManagerFactory.getTrustManagers(), null);
        return sslContext;
    }

    static {
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (algorithm == null) {
            algorithm = "SunX509";
        }
        KEY_MANAGER_FACTORY_ALGORITHM = algorithm;
    }
}

